/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpMethod;
import org.springframework.security.web.servlet.util.matcher.PathPatternRequestMatcher;
import org.springframework.util.StringUtils;

public final class PathPatternRequestMatcherFactoryBean
implements FactoryBean<PathPatternRequestMatcher>,
ApplicationContextAware,
InitializingBean {
    private final String pattern;
    private String basePath;
    private HttpMethod method;
    private PathPatternRequestMatcher.Builder builder;

    PathPatternRequestMatcherFactoryBean(String pattern) {
        this.pattern = pattern;
    }

    PathPatternRequestMatcherFactoryBean(String pattern, String method) {
        this.pattern = pattern;
        this.method = StringUtils.hasText((String)method) ? HttpMethod.valueOf((String)method) : null;
    }

    public @Nullable PathPatternRequestMatcher getObject() throws Exception {
        return this.builder.matcher(this.method, this.pattern);
    }

    public @Nullable Class<?> getObjectType() {
        return PathPatternRequestMatcher.class;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.builder = (PathPatternRequestMatcher.Builder)context.getBeanProvider(PathPatternRequestMatcher.Builder.class).getIfUnique(PathPatternRequestMatcher::withDefaults);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.basePath != null) {
            this.builder.basePath(this.basePath);
        }
    }
}

