/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.messaging;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.messaging.Message;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.security.access.expression.SecurityExpressionHandler;
import org.springframework.security.messaging.access.expression.DefaultMessageSecurityExpressionHandler;
import org.springframework.security.messaging.access.expression.ExpressionBasedMessageSecurityMetadataSourceFactory;
import org.springframework.security.messaging.access.intercept.MessageSecurityMetadataSource;
import org.springframework.security.messaging.util.matcher.MessageMatcher;
import org.springframework.security.messaging.util.matcher.SimpDestinationMessageMatcher;
import org.springframework.security.messaging.util.matcher.SimpMessageTypeMatcher;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

@Deprecated
public class MessageSecurityMetadataSourceRegistry {
    private static final String permitAll = "permitAll";
    private static final String denyAll = "denyAll";
    private static final String anonymous = "anonymous";
    private static final String authenticated = "authenticated";
    private static final String fullyAuthenticated = "fullyAuthenticated";
    private static final String rememberMe = "rememberMe";
    private SecurityExpressionHandler<Message<Object>> expressionHandler = new DefaultMessageSecurityExpressionHandler();
    private final LinkedHashMap<MatcherBuilder, String> matcherToExpression = new LinkedHashMap();
    private DelegatingPathMatcher pathMatcher = new DelegatingPathMatcher();
    private boolean defaultPathMatcher = true;

    public Constraint anyMessage() {
        return this.matchers(MessageMatcher.ANY_MESSAGE);
    }

    public Constraint nullDestMatcher() {
        return this.matchers(SimpDestinationMessageMatcher.NULL_DESTINATION_MATCHER);
    }

    public Constraint simpTypeMatchers(SimpMessageType ... typesToMatch) {
        MessageMatcher[] typeMatchers = new MessageMatcher[typesToMatch.length];
        for (int i = 0; i < typesToMatch.length; ++i) {
            SimpMessageType typeToMatch = typesToMatch[i];
            typeMatchers[i] = new SimpMessageTypeMatcher(typeToMatch);
        }
        return this.matchers(typeMatchers);
    }

    public Constraint simpDestMatchers(String ... patterns) {
        return this.simpDestMatchers((SimpMessageType)null, patterns);
    }

    public Constraint simpMessageDestMatchers(String ... patterns) {
        return this.simpDestMatchers(SimpMessageType.MESSAGE, patterns);
    }

    public Constraint simpSubscribeDestMatchers(String ... patterns) {
        return this.simpDestMatchers(SimpMessageType.SUBSCRIBE, patterns);
    }

    private Constraint simpDestMatchers(SimpMessageType type, String ... patterns) {
        ArrayList<PathMatcherMessageMatcherBuilder> matchers = new ArrayList<PathMatcherMessageMatcherBuilder>(patterns.length);
        for (String pattern : patterns) {
            matchers.add(new PathMatcherMessageMatcherBuilder(pattern, type));
        }
        return new Constraint(matchers);
    }

    public MessageSecurityMetadataSourceRegistry simpDestPathMatcher(PathMatcher pathMatcher) {
        Assert.notNull((Object)pathMatcher, (String)"pathMatcher cannot be null");
        this.pathMatcher.setPathMatcher(pathMatcher);
        this.defaultPathMatcher = false;
        return this;
    }

    protected boolean isSimpDestPathMatcherConfigured() {
        return !this.defaultPathMatcher;
    }

    public Constraint matchers(MessageMatcher<?> ... matchers) {
        ArrayList<PreBuiltMatcherBuilder> builders = new ArrayList<PreBuiltMatcherBuilder>(matchers.length);
        for (MessageMatcher<?> matcher : matchers) {
            builders.add(new PreBuiltMatcherBuilder(matcher));
        }
        return new Constraint(builders);
    }

    public MessageSecurityMetadataSourceRegistry expressionHandler(SecurityExpressionHandler<Message<Object>> expressionHandler) {
        Assert.notNull(expressionHandler, (String)"expressionHandler cannot be null");
        this.expressionHandler = expressionHandler;
        return this;
    }

    protected MessageSecurityMetadataSource createMetadataSource() {
        LinkedHashMap matcherToExpression = new LinkedHashMap();
        for (Map.Entry<MatcherBuilder, String> entry : this.matcherToExpression.entrySet()) {
            matcherToExpression.put(entry.getKey().build(), entry.getValue());
        }
        return ExpressionBasedMessageSecurityMetadataSourceFactory.createExpressionMessageMetadataSource(matcherToExpression, this.expressionHandler);
    }

    protected boolean containsMapping() {
        return !this.matcherToExpression.isEmpty();
    }

    private static String hasAnyRole(String ... authorities) {
        String anyAuthorities = StringUtils.arrayToDelimitedString((Object[])authorities, (String)"','ROLE_");
        return "hasAnyRole('ROLE_" + anyAuthorities + "')";
    }

    private static String hasRole(String role) {
        Assert.notNull((Object)role, (String)"role cannot be null");
        if (role.startsWith("ROLE_")) {
            throw new IllegalArgumentException("role should not start with 'ROLE_' since it is automatically inserted. Got '" + role + "'");
        }
        return "hasRole('ROLE_" + role + "')";
    }

    private static String hasAuthority(String authority) {
        return "hasAuthority('" + authority + "')";
    }

    private static String hasAnyAuthority(String ... authorities) {
        String anyAuthorities = StringUtils.arrayToDelimitedString((Object[])authorities, (String)"','");
        return "hasAnyAuthority('" + anyAuthorities + "')";
    }

    static class DelegatingPathMatcher
    implements PathMatcher {
        private PathMatcher delegate = new AntPathMatcher();

        DelegatingPathMatcher() {
        }

        public boolean isPattern(String path) {
            return this.delegate.isPattern(path);
        }

        public boolean match(String pattern, String path) {
            return this.delegate.match(pattern, path);
        }

        public boolean matchStart(String pattern, String path) {
            return this.delegate.matchStart(pattern, path);
        }

        public String extractPathWithinPattern(String pattern, String path) {
            return this.delegate.extractPathWithinPattern(pattern, path);
        }

        public Map<String, String> extractUriTemplateVariables(String pattern, String path) {
            return this.delegate.extractUriTemplateVariables(pattern, path);
        }

        public Comparator<String> getPatternComparator(String path) {
            return this.delegate.getPatternComparator(path);
        }

        public String combine(String pattern1, String pattern2) {
            return this.delegate.combine(pattern1, pattern2);
        }

        void setPathMatcher(PathMatcher pathMatcher) {
            this.delegate = pathMatcher;
        }
    }

    public final class Constraint {
        private final List<? extends MatcherBuilder> messageMatchers;

        private Constraint(List<? extends MatcherBuilder> messageMatchers) {
            Assert.notEmpty(messageMatchers, (String)"messageMatchers cannot be null or empty");
            this.messageMatchers = messageMatchers;
        }

        public MessageSecurityMetadataSourceRegistry hasRole(String role) {
            return this.access(MessageSecurityMetadataSourceRegistry.hasRole(role));
        }

        public MessageSecurityMetadataSourceRegistry hasAnyRole(String ... roles) {
            return this.access(MessageSecurityMetadataSourceRegistry.hasAnyRole(roles));
        }

        public MessageSecurityMetadataSourceRegistry hasAuthority(String authority) {
            return this.access(MessageSecurityMetadataSourceRegistry.hasAuthority(authority));
        }

        public MessageSecurityMetadataSourceRegistry hasAnyAuthority(String ... authorities) {
            return this.access(MessageSecurityMetadataSourceRegistry.hasAnyAuthority(authorities));
        }

        public MessageSecurityMetadataSourceRegistry permitAll() {
            return this.access(MessageSecurityMetadataSourceRegistry.permitAll);
        }

        public MessageSecurityMetadataSourceRegistry anonymous() {
            return this.access(MessageSecurityMetadataSourceRegistry.anonymous);
        }

        public MessageSecurityMetadataSourceRegistry rememberMe() {
            return this.access(MessageSecurityMetadataSourceRegistry.rememberMe);
        }

        public MessageSecurityMetadataSourceRegistry denyAll() {
            return this.access(MessageSecurityMetadataSourceRegistry.denyAll);
        }

        public MessageSecurityMetadataSourceRegistry authenticated() {
            return this.access(MessageSecurityMetadataSourceRegistry.authenticated);
        }

        public MessageSecurityMetadataSourceRegistry fullyAuthenticated() {
            return this.access(MessageSecurityMetadataSourceRegistry.fullyAuthenticated);
        }

        public MessageSecurityMetadataSourceRegistry access(String attribute) {
            for (MatcherBuilder matcherBuilder : this.messageMatchers) {
                MessageSecurityMetadataSourceRegistry.this.matcherToExpression.put(matcherBuilder, attribute);
            }
            return MessageSecurityMetadataSourceRegistry.this;
        }
    }

    private final class PathMatcherMessageMatcherBuilder
    implements MatcherBuilder {
        private final String pattern;
        private final SimpMessageType type;

        private PathMatcherMessageMatcherBuilder(String pattern, SimpMessageType type) {
            this.pattern = pattern;
            this.type = type;
        }

        @Override
        public MessageMatcher<?> build() {
            if (this.type == null) {
                return new SimpDestinationMessageMatcher(this.pattern, (PathMatcher)MessageSecurityMetadataSourceRegistry.this.pathMatcher);
            }
            if (SimpMessageType.MESSAGE == this.type) {
                return SimpDestinationMessageMatcher.createMessageMatcher((String)this.pattern, (PathMatcher)MessageSecurityMetadataSourceRegistry.this.pathMatcher);
            }
            if (SimpMessageType.SUBSCRIBE == this.type) {
                return SimpDestinationMessageMatcher.createSubscribeMatcher((String)this.pattern, (PathMatcher)MessageSecurityMetadataSourceRegistry.this.pathMatcher);
            }
            throw new IllegalStateException(String.valueOf(this.type) + " is not supported since it does not have a destination");
        }
    }

    private static final class PreBuiltMatcherBuilder
    implements MatcherBuilder {
        private MessageMatcher<?> matcher;

        private PreBuiltMatcherBuilder(MessageMatcher<?> matcher) {
            this.matcher = matcher;
        }

        @Override
        public MessageMatcher<?> build() {
            return this.matcher;
        }
    }

    private static interface MatcherBuilder {
        public MessageMatcher<?> build();
    }
}

