/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.http;

import io.micrometer.observation.ObservationRegistry;
import jakarta.servlet.ServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanReference;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.parsing.BeanComponentDefinition;
import org.springframework.beans.factory.parsing.ComponentDefinition;
import org.springframework.beans.factory.parsing.CompositeComponentDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.access.vote.AuthenticatedVoter;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.config.http.AuthorizationFilterParser;
import org.springframework.security.config.http.ChannelAttributeFactory;
import org.springframework.security.config.http.CorsBeanDefinitionParser;
import org.springframework.security.config.http.CsrfBeanDefinitionParser;
import org.springframework.security.config.http.FilterInvocationSecurityMetadataSourceParser;
import org.springframework.security.config.http.GrantedAuthorityDefaultsParserUtils;
import org.springframework.security.config.http.HeadersBeanDefinitionParser;
import org.springframework.security.config.http.MatcherType;
import org.springframework.security.config.http.OrderDecorator;
import org.springframework.security.config.http.SecurityFilters;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.config.http.WellKnownChangePasswordBeanDefinitionParser;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.core.session.SessionRegistryImpl;
import org.springframework.security.web.access.AuthorizationManagerWebInvocationPrivilegeEvaluator;
import org.springframework.security.web.access.DefaultWebInvocationPrivilegeEvaluator;
import org.springframework.security.web.access.HandlerMappingIntrospectorRequestTransformer;
import org.springframework.security.web.access.channel.ChannelDecisionManagerImpl;
import org.springframework.security.web.access.channel.ChannelProcessingFilter;
import org.springframework.security.web.access.channel.InsecureChannelProcessor;
import org.springframework.security.web.access.channel.RetryWithHttpEntryPoint;
import org.springframework.security.web.access.channel.RetryWithHttpsEntryPoint;
import org.springframework.security.web.access.channel.SecureChannelProcessor;
import org.springframework.security.web.access.expression.WebExpressionVoter;
import org.springframework.security.web.access.intercept.DefaultFilterInvocationSecurityMetadataSource;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.authentication.session.ChangeSessionIdAuthenticationStrategy;
import org.springframework.security.web.authentication.session.CompositeSessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.ConcurrentSessionControlAuthenticationStrategy;
import org.springframework.security.web.authentication.session.RegisterSessionAuthenticationStrategy;
import org.springframework.security.web.authentication.session.SessionFixationProtectionStrategy;
import org.springframework.security.web.context.HttpSessionSecurityContextRepository;
import org.springframework.security.web.context.RequestAttributeSecurityContextRepository;
import org.springframework.security.web.context.SecurityContextHolderFilter;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.context.request.async.WebAsyncManagerIntegrationFilter;
import org.springframework.security.web.jaasapi.JaasApiIntegrationFilter;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.NullRequestCache;
import org.springframework.security.web.savedrequest.RequestCacheAwareFilter;
import org.springframework.security.web.servletapi.SecurityContextHolderAwareRequestFilter;
import org.springframework.security.web.session.ConcurrentSessionFilter;
import org.springframework.security.web.session.DisableEncodeUrlFilter;
import org.springframework.security.web.session.ForceEagerSessionCreationFilter;
import org.springframework.security.web.session.SessionManagementFilter;
import org.springframework.security.web.session.SimpleRedirectInvalidSessionStrategy;
import org.springframework.security.web.session.SimpleRedirectSessionInformationExpiredStrategy;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;
import org.w3c.dom.Element;

class HttpConfigurationBuilder {
    private static final String HANDLER_MAPPING_INTROSPECTOR = "org.springframework.web.servlet.handler.HandlerMappingIntrospector";
    private static final boolean mvcPresent = ClassUtils.isPresent((String)"org.springframework.web.servlet.handler.HandlerMappingIntrospector", (ClassLoader)HttpConfigurationBuilder.class.getClassLoader());
    private static final String ATT_CREATE_SESSION = "create-session";
    private static final String ATT_SESSION_FIXATION_PROTECTION = "session-fixation-protection";
    private static final String OPT_SESSION_FIXATION_NO_PROTECTION = "none";
    private static final String OPT_SESSION_FIXATION_MIGRATE_SESSION = "migrateSession";
    private static final String OPT_CHANGE_SESSION_ID = "changeSessionId";
    private static final String ATT_AUTHENTICATION_STRATEGY_EXPLICIT_INVOCATION = "authentication-strategy-explicit-invocation";
    private static final String ATT_INVALID_SESSION_URL = "invalid-session-url";
    private static final String ATT_OBSERVATION_REGISTRY_REF = "observation-registry-ref";
    private static final String ATT_SESSION_AUTH_STRATEGY_REF = "session-authentication-strategy-ref";
    private static final String ATT_SESSION_AUTH_ERROR_URL = "session-authentication-error-url";
    private static final String ATT_SECURITY_CONTEXT_HOLDER_STRATEGY = "security-context-holder-strategy-ref";
    private static final String ATT_SECURITY_CONTEXT_REPOSITORY = "security-context-repository-ref";
    private static final String ATT_SECURITY_CONTEXT_EXPLICIT_SAVE = "security-context-explicit-save";
    private static final String ATT_INVALID_SESSION_STRATEGY_REF = "invalid-session-strategy-ref";
    private static final String ATT_DISABLE_URL_REWRITING = "disable-url-rewriting";
    private static final String ATT_USE_AUTHORIZATION_MGR = "use-authorization-manager";
    private static final String ATT_AUTHORIZATION_MGR = "authorization-manager-ref";
    private static final String ATT_ACCESS_MGR = "access-decision-manager-ref";
    private static final String ATT_ONCE_PER_REQUEST = "once-per-request";
    private static final String ATT_REF = "ref";
    private static final String ATT_EXPIRY_URL = "expired-url";
    private static final String ATT_EXPIRED_SESSION_STRATEGY_REF = "expired-session-strategy-ref";
    private static final String ATT_SESSION_REGISTRY_ALIAS = "session-registry-alias";
    private static final String ATT_SESSION_REGISTRY_REF = "session-registry-ref";
    private static final String ATT_SERVLET_API_PROVISION = "servlet-api-provision";
    private static final String DEF_SERVLET_API_PROVISION = "true";
    private static final String ATT_JAAS_API_PROVISION = "jaas-api-provision";
    private static final String DEF_JAAS_API_PROVISION = "false";
    private final Element httpElt;
    private final ParserContext pc;
    private final SessionCreationPolicy sessionPolicy;
    private final List<Element> interceptUrls;
    private final MatcherType matcherType;
    private BeanDefinition cpf;
    private BeanDefinition securityContextPersistenceFilter;
    private BeanDefinition forceEagerSessionCreationFilter;
    private BeanMetadataElement holderStrategyRef;
    private BeanReference contextRepoRef;
    private BeanReference sessionRegistryRef;
    private BeanDefinition concurrentSessionFilter;
    private BeanDefinition webAsyncManagerFilter;
    private BeanDefinition requestCacheAwareFilter;
    private BeanReference sessionStrategyRef;
    private RootBeanDefinition sfpf;
    private BeanDefinition servApiFilter;
    private BeanDefinition jaasApiFilter;
    private final BeanReference portMapper;
    private final BeanReference portResolver;
    private BeanReference fsi;
    private BeanReference requestCache;
    private BeanDefinition addHeadersFilter;
    private BeanMetadataElement corsFilter;
    private BeanDefinition csrfFilter;
    private BeanDefinition disableUrlRewriteFilter;
    private BeanDefinition wellKnownChangePasswordRedirectFilter;
    private BeanMetadataElement csrfLogoutHandler;
    private BeanMetadataElement csrfAuthStrategy;
    private CsrfBeanDefinitionParser csrfParser;
    private BeanDefinition invalidSession;
    private boolean addAllAuth;

    HttpConfigurationBuilder(Element element, boolean addAllAuth, ParserContext pc, BeanReference portMapper, BeanReference portResolver, BeanReference authenticationManager, BeanMetadataElement observationRegistry) {
        this.httpElt = element;
        this.addAllAuth = addAllAuth;
        this.pc = pc;
        this.portMapper = portMapper;
        this.portResolver = portResolver;
        this.matcherType = MatcherType.fromElementOrMvc(element);
        this.interceptUrls = DomUtils.getChildElementsByTagName((Element)element, (String)"intercept-url");
        this.validateInterceptUrls(pc);
        String createSession = element.getAttribute(ATT_CREATE_SESSION);
        this.sessionPolicy = !StringUtils.hasText((String)createSession) ? SessionCreationPolicy.IF_REQUIRED : this.createPolicy(createSession);
        this.createSecurityContextHolderStrategy();
        this.createForceEagerSessionCreationFilter();
        this.createDisableEncodeUrlFilter();
        this.createCsrfFilter(observationRegistry);
        this.createSecurityPersistence();
        this.createSessionManagementFilters();
        this.createWebAsyncManagerFilter();
        this.createRequestCacheFilter();
        this.createServletApiFilter(authenticationManager);
        this.createJaasApiFilter();
        this.createChannelProcessingFilter();
        this.createFilterSecurity(authenticationManager);
        this.createAddHeadersFilter();
        this.createCorsFilter();
        this.createWellKnownChangePasswordRedirectFilter();
    }

    private void validateInterceptUrls(ParserContext pc) {
        for (Element element : this.interceptUrls) {
            if (!StringUtils.hasText((String)element.getAttribute("filters"))) continue;
            String message = "The use of \"filters='none'\" is no longer supported. Please define a separate <http> element for the pattern you want to exclude and use the attribute \"security='none'\".";
            pc.getReaderContext().error(message, pc.extractSource((Object)element));
        }
    }

    private SessionCreationPolicy createPolicy(String createSession) {
        if ("ifRequired".equals(createSession)) {
            return SessionCreationPolicy.IF_REQUIRED;
        }
        if ("always".equals(createSession)) {
            return SessionCreationPolicy.ALWAYS;
        }
        if ("never".equals(createSession)) {
            return SessionCreationPolicy.NEVER;
        }
        if ("stateless".equals(createSession)) {
            return SessionCreationPolicy.STATELESS;
        }
        throw new IllegalStateException("Cannot convert " + createSession + " to " + SessionCreationPolicy.class.getName());
    }

    void setLogoutHandlers(ManagedList logoutHandlers) {
        if (logoutHandlers != null) {
            if (this.concurrentSessionFilter != null) {
                this.concurrentSessionFilter.getPropertyValues().add("logoutHandlers", (Object)logoutHandlers);
            }
            if (this.servApiFilter != null) {
                this.servApiFilter.getPropertyValues().add("logoutHandlers", (Object)logoutHandlers);
            }
        }
    }

    void setEntryPoint(BeanMetadataElement entryPoint) {
        if (this.servApiFilter != null) {
            this.servApiFilter.getPropertyValues().add("authenticationEntryPoint", (Object)entryPoint);
        }
    }

    void setAccessDeniedHandler(BeanMetadataElement accessDeniedHandler) {
        if (this.csrfParser != null) {
            this.csrfParser.initAccessDeniedHandler(this.invalidSession, accessDeniedHandler);
        }
    }

    void setCsrfIgnoreRequestMatchers(List<BeanDefinition> requestMatchers) {
        if (this.csrfParser != null) {
            this.csrfParser.setIgnoreCsrfRequestMatchers(requestMatchers);
        }
    }

    static String createPath(String path, boolean lowerCase) {
        return lowerCase ? path.toLowerCase(Locale.ENGLISH) : path;
    }

    BeanMetadataElement getSecurityContextHolderStrategyForAuthenticationFilters() {
        return this.holderStrategyRef;
    }

    BeanReference getSecurityContextRepositoryForAuthenticationFilters() {
        return this.isExplicitSave() ? this.contextRepoRef : null;
    }

    private void createSecurityPersistence() {
        this.createSecurityContextRepository();
        if (this.isExplicitSave()) {
            this.createSecurityContextHolderFilter();
        } else {
            this.createSecurityContextPersistenceFilter();
        }
    }

    private boolean isExplicitSave() {
        String explicitSaveAttr = this.httpElt.getAttribute(ATT_SECURITY_CONTEXT_EXPLICIT_SAVE);
        return !StringUtils.hasText((String)explicitSaveAttr) || Boolean.parseBoolean(explicitSaveAttr);
    }

    private void createForceEagerSessionCreationFilter() {
        if (this.sessionPolicy == SessionCreationPolicy.ALWAYS) {
            this.forceEagerSessionCreationFilter = new RootBeanDefinition(ForceEagerSessionCreationFilter.class);
        }
    }

    private void createSecurityContextPersistenceFilter() {
        BeanDefinitionBuilder scpf = BeanDefinitionBuilder.rootBeanDefinition(SecurityContextPersistenceFilter.class);
        switch (this.sessionPolicy) {
            case ALWAYS: {
                scpf.addPropertyValue("forceEagerSessionCreation", (Object)Boolean.TRUE);
                break;
            }
            case NEVER: {
                scpf.addPropertyValue("forceEagerSessionCreation", (Object)Boolean.FALSE);
                break;
            }
            default: {
                scpf.addPropertyValue("forceEagerSessionCreation", (Object)Boolean.FALSE);
            }
        }
        scpf.addPropertyValue("securityContextHolderStrategy", (Object)this.holderStrategyRef);
        scpf.addConstructorArgValue((Object)this.contextRepoRef);
        this.securityContextPersistenceFilter = scpf.getBeanDefinition();
    }

    private void createSecurityContextHolderStrategy() {
        String holderStrategyRef = this.httpElt.getAttribute(ATT_SECURITY_CONTEXT_HOLDER_STRATEGY);
        if (StringUtils.hasText((String)holderStrategyRef)) {
            this.holderStrategyRef = new RuntimeBeanReference(holderStrategyRef);
            return;
        }
        this.holderStrategyRef = BeanDefinitionBuilder.rootBeanDefinition(SecurityContextHolderStrategyFactory.class).getBeanDefinition();
    }

    private void createSecurityContextRepository() {
        String repoRef = this.httpElt.getAttribute(ATT_SECURITY_CONTEXT_REPOSITORY);
        if (!StringUtils.hasText((String)repoRef)) {
            BeanDefinitionBuilder contextRepo;
            if (this.sessionPolicy == SessionCreationPolicy.STATELESS) {
                contextRepo = BeanDefinitionBuilder.rootBeanDefinition(RequestAttributeSecurityContextRepository.class);
            } else {
                contextRepo = BeanDefinitionBuilder.rootBeanDefinition(HttpSessionSecurityContextRepository.class);
                switch (this.sessionPolicy) {
                    case ALWAYS: {
                        contextRepo.addPropertyValue("allowSessionCreation", (Object)Boolean.TRUE);
                        break;
                    }
                    case NEVER: {
                        contextRepo.addPropertyValue("allowSessionCreation", (Object)Boolean.FALSE);
                        break;
                    }
                    default: {
                        contextRepo.addPropertyValue("allowSessionCreation", (Object)Boolean.TRUE);
                    }
                }
                if (this.isDisableUrlRewriting()) {
                    contextRepo.addPropertyValue("disableUrlRewriting", (Object)Boolean.TRUE);
                }
            }
            contextRepo.addPropertyValue("securityContextHolderStrategy", (Object)this.holderStrategyRef);
            AbstractBeanDefinition repoBean = contextRepo.getBeanDefinition();
            repoRef = this.pc.getReaderContext().generateBeanName((BeanDefinition)repoBean);
            this.pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)repoBean, repoRef));
        }
        this.contextRepoRef = new RuntimeBeanReference(repoRef);
    }

    private boolean isDisableUrlRewriting() {
        String disableUrlRewriting = this.httpElt.getAttribute(ATT_DISABLE_URL_REWRITING);
        return !DEF_JAAS_API_PROVISION.equals(disableUrlRewriting);
    }

    private void createSecurityContextHolderFilter() {
        BeanDefinitionBuilder filter = BeanDefinitionBuilder.rootBeanDefinition(SecurityContextHolderFilter.class);
        filter.addPropertyValue("securityContextHolderStrategy", (Object)this.holderStrategyRef);
        filter.addConstructorArgValue((Object)this.contextRepoRef);
        this.securityContextPersistenceFilter = filter.getBeanDefinition();
    }

    private void createSessionManagementFilters() {
        boolean registerSessionMgmtFilter;
        Element sessionMgmtElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"session-management");
        Element sessionCtrlElt = null;
        String sessionFixationAttribute = null;
        String invalidSessionUrl = null;
        String invalidSessionStrategyRef = null;
        String sessionAuthStratRef = null;
        String errorUrl = null;
        boolean sessionControlEnabled = false;
        if (sessionMgmtElt != null) {
            if (this.sessionPolicy == SessionCreationPolicy.STATELESS) {
                this.pc.getReaderContext().error("session-management  cannot be used in combination with create-session='" + SessionCreationPolicy.STATELESS + "'", this.pc.extractSource((Object)sessionMgmtElt));
            }
            sessionFixationAttribute = sessionMgmtElt.getAttribute(ATT_SESSION_FIXATION_PROTECTION);
            invalidSessionUrl = sessionMgmtElt.getAttribute(ATT_INVALID_SESSION_URL);
            invalidSessionStrategyRef = sessionMgmtElt.getAttribute(ATT_INVALID_SESSION_STRATEGY_REF);
            sessionAuthStratRef = sessionMgmtElt.getAttribute(ATT_SESSION_AUTH_STRATEGY_REF);
            errorUrl = sessionMgmtElt.getAttribute(ATT_SESSION_AUTH_ERROR_URL);
            sessionCtrlElt = DomUtils.getChildElementByTagName((Element)sessionMgmtElt, (String)"concurrency-control");
            boolean bl = sessionControlEnabled = sessionCtrlElt != null;
            if (StringUtils.hasText((String)invalidSessionUrl) && StringUtils.hasText((String)invalidSessionStrategyRef)) {
                this.pc.getReaderContext().error("invalid-session-url attribute cannot be used in combination with the invalid-session-strategy-ref attribute.", (Object)sessionMgmtElt);
            }
            if (sessionControlEnabled) {
                if (StringUtils.hasText((String)sessionAuthStratRef)) {
                    this.pc.getReaderContext().error("session-authentication-strategy-ref attribute cannot be used in combination with <concurrency-control>", this.pc.extractSource((Object)sessionCtrlElt));
                }
                this.createConcurrencyControlFilterAndSessionRegistry(sessionCtrlElt);
            }
        }
        if (!StringUtils.hasText(sessionFixationAttribute)) {
            sessionFixationAttribute = OPT_CHANGE_SESSION_ID;
        } else if (StringUtils.hasText(sessionAuthStratRef)) {
            this.pc.getReaderContext().error("session-fixation-protection attribute cannot be used in combination with session-authentication-strategy-ref", this.pc.extractSource((Object)sessionMgmtElt));
        }
        if (this.sessionPolicy == SessionCreationPolicy.STATELESS) {
            return;
        }
        boolean sessionFixationProtectionRequired = !sessionFixationAttribute.equals(OPT_SESSION_FIXATION_NO_PROTECTION);
        ManagedList delegateSessionStrategies = new ManagedList();
        BeanDefinitionBuilder sessionFixationStrategy = null;
        if (this.csrfAuthStrategy != null) {
            delegateSessionStrategies.add((Object)this.csrfAuthStrategy);
        }
        if (sessionControlEnabled) {
            String exceptionIfMaximumExceeded;
            Assert.state((this.sessionRegistryRef != null ? 1 : 0) != 0, (String)"No sessionRegistryRef found");
            BeanDefinitionBuilder concurrentSessionStrategy = BeanDefinitionBuilder.rootBeanDefinition(ConcurrentSessionControlAuthenticationStrategy.class);
            concurrentSessionStrategy.addConstructorArgValue((Object)this.sessionRegistryRef);
            String maxSessions = this.pc.getReaderContext().getEnvironment().resolvePlaceholders(sessionCtrlElt.getAttribute("max-sessions"));
            if (StringUtils.hasText((String)maxSessions)) {
                concurrentSessionStrategy.addPropertyValue("maximumSessions", (Object)maxSessions);
            }
            if (StringUtils.hasText((String)(exceptionIfMaximumExceeded = sessionCtrlElt.getAttribute("error-if-maximum-exceeded")))) {
                concurrentSessionStrategy.addPropertyValue("exceptionIfMaximumExceeded", (Object)exceptionIfMaximumExceeded);
            }
            delegateSessionStrategies.add((Object)concurrentSessionStrategy.getBeanDefinition());
        }
        boolean useChangeSessionId = OPT_CHANGE_SESSION_ID.equals(sessionFixationAttribute);
        if (sessionFixationProtectionRequired || StringUtils.hasText((String)invalidSessionUrl)) {
            sessionFixationStrategy = useChangeSessionId ? BeanDefinitionBuilder.rootBeanDefinition(ChangeSessionIdAuthenticationStrategy.class) : BeanDefinitionBuilder.rootBeanDefinition(SessionFixationProtectionStrategy.class);
            delegateSessionStrategies.add((Object)sessionFixationStrategy.getBeanDefinition());
        }
        if (StringUtils.hasText((String)sessionAuthStratRef)) {
            delegateSessionStrategies.add((Object)new RuntimeBeanReference(sessionAuthStratRef));
        }
        if (sessionControlEnabled) {
            BeanDefinitionBuilder registerSessionStrategy = BeanDefinitionBuilder.rootBeanDefinition(RegisterSessionAuthenticationStrategy.class);
            registerSessionStrategy.addConstructorArgValue((Object)this.sessionRegistryRef);
            delegateSessionStrategies.add((Object)registerSessionStrategy.getBeanDefinition());
        }
        if (delegateSessionStrategies.isEmpty()) {
            this.sfpf = null;
            return;
        }
        BeanDefinitionBuilder sessionMgmtFilter = BeanDefinitionBuilder.rootBeanDefinition(SessionManagementFilter.class);
        RootBeanDefinition failureHandler = new RootBeanDefinition(SimpleUrlAuthenticationFailureHandler.class);
        if (StringUtils.hasText((String)errorUrl)) {
            failureHandler.getPropertyValues().addPropertyValue("defaultFailureUrl", (Object)errorUrl);
        }
        sessionMgmtFilter.addPropertyValue("securityContextHolderStrategy", (Object)this.holderStrategyRef);
        sessionMgmtFilter.addPropertyValue("authenticationFailureHandler", (Object)failureHandler);
        sessionMgmtFilter.addConstructorArgValue((Object)this.contextRepoRef);
        if (!StringUtils.hasText((String)sessionAuthStratRef) && sessionFixationStrategy != null && !useChangeSessionId && sessionFixationProtectionRequired) {
            sessionFixationStrategy.addPropertyValue("migrateSessionAttributes", (Object)sessionFixationAttribute.equals(OPT_SESSION_FIXATION_MIGRATE_SESSION));
        }
        if (!delegateSessionStrategies.isEmpty()) {
            BeanDefinitionBuilder sessionStrategy = BeanDefinitionBuilder.rootBeanDefinition(CompositeSessionAuthenticationStrategy.class);
            AbstractBeanDefinition strategyBean = sessionStrategy.getBeanDefinition();
            sessionStrategy.addConstructorArgValue((Object)delegateSessionStrategies);
            sessionAuthStratRef = this.pc.getReaderContext().generateBeanName((BeanDefinition)strategyBean);
            this.pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)strategyBean, sessionAuthStratRef));
        }
        if (StringUtils.hasText((String)invalidSessionUrl)) {
            BeanDefinitionBuilder invalidSessionBldr = BeanDefinitionBuilder.rootBeanDefinition(SimpleRedirectInvalidSessionStrategy.class);
            invalidSessionBldr.addConstructorArgValue((Object)invalidSessionUrl);
            this.invalidSession = invalidSessionBldr.getBeanDefinition();
            sessionMgmtFilter.addPropertyValue("invalidSessionStrategy", (Object)this.invalidSession);
        } else if (StringUtils.hasText((String)invalidSessionStrategyRef)) {
            sessionMgmtFilter.addPropertyReference("invalidSessionStrategy", invalidSessionStrategyRef);
        }
        sessionMgmtFilter.addConstructorArgReference(sessionAuthStratRef);
        boolean bl = registerSessionMgmtFilter = sessionMgmtElt != null && DEF_JAAS_API_PROVISION.equals(sessionMgmtElt.getAttribute(ATT_AUTHENTICATION_STRATEGY_EXPLICIT_INVOCATION));
        if (registerSessionMgmtFilter || StringUtils.hasText((String)errorUrl) || StringUtils.hasText((String)invalidSessionUrl) || StringUtils.hasText((String)invalidSessionStrategyRef)) {
            this.sfpf = (RootBeanDefinition)sessionMgmtFilter.getBeanDefinition();
        }
        this.sessionStrategyRef = new RuntimeBeanReference(sessionAuthStratRef);
    }

    private void createConcurrencyControlFilterAndSessionRegistry(Element element) {
        String registryAlias;
        CompositeComponentDefinition compositeDef = new CompositeComponentDefinition(element.getTagName(), this.pc.extractSource((Object)element));
        this.pc.pushContainingComponent(compositeDef);
        BeanDefinitionRegistry beanRegistry = this.pc.getRegistry();
        String sessionRegistryId = element.getAttribute(ATT_SESSION_REGISTRY_REF);
        if (!StringUtils.hasText((String)sessionRegistryId)) {
            RootBeanDefinition sessionRegistry = new RootBeanDefinition(SessionRegistryImpl.class);
            sessionRegistryId = this.pc.getReaderContext().registerWithGeneratedName((BeanDefinition)sessionRegistry);
            this.pc.registerComponent((ComponentDefinition)new BeanComponentDefinition((BeanDefinition)sessionRegistry, sessionRegistryId));
        }
        if (StringUtils.hasText((String)(registryAlias = element.getAttribute(ATT_SESSION_REGISTRY_ALIAS)))) {
            beanRegistry.registerAlias(sessionRegistryId, registryAlias);
        }
        BeanDefinitionBuilder filterBuilder = BeanDefinitionBuilder.rootBeanDefinition(ConcurrentSessionFilter.class);
        filterBuilder.addConstructorArgReference(sessionRegistryId);
        Object source = this.pc.extractSource((Object)element);
        filterBuilder.getRawBeanDefinition().setSource(source);
        filterBuilder.setRole(2);
        String expiryUrl = element.getAttribute(ATT_EXPIRY_URL);
        String expiredSessionStrategyRef = element.getAttribute(ATT_EXPIRED_SESSION_STRATEGY_REF);
        if (StringUtils.hasText((String)expiryUrl) && StringUtils.hasText((String)expiredSessionStrategyRef)) {
            this.pc.getReaderContext().error("Cannot use 'expired-url' attribute and 'expired-session-strategy-ref' attribute together.", source);
        }
        if (StringUtils.hasText((String)expiryUrl)) {
            BeanDefinitionBuilder expiredSessionBldr = BeanDefinitionBuilder.rootBeanDefinition(SimpleRedirectSessionInformationExpiredStrategy.class);
            expiredSessionBldr.addConstructorArgValue((Object)expiryUrl);
            filterBuilder.addConstructorArgValue((Object)expiredSessionBldr.getBeanDefinition());
        } else if (StringUtils.hasText((String)expiredSessionStrategyRef)) {
            filterBuilder.addConstructorArgReference(expiredSessionStrategyRef);
        }
        this.pc.popAndRegisterContainingComponent();
        this.concurrentSessionFilter = filterBuilder.getBeanDefinition();
        this.sessionRegistryRef = new RuntimeBeanReference(sessionRegistryId);
    }

    private void createWebAsyncManagerFilter() {
        boolean asyncSupported = ClassUtils.hasMethod(ServletRequest.class, (String)"startAsync", (Class[])new Class[0]);
        if (asyncSupported) {
            this.webAsyncManagerFilter = new RootBeanDefinition(WebAsyncManagerIntegrationFilter.class);
            this.webAsyncManagerFilter.getPropertyValues().add("securityContextHolderStrategy", (Object)this.holderStrategyRef);
        }
    }

    private void createServletApiFilter(BeanReference authenticationManager) {
        String provideServletApi = this.httpElt.getAttribute(ATT_SERVLET_API_PROVISION);
        if (!StringUtils.hasText((String)provideServletApi)) {
            provideServletApi = DEF_SERVLET_API_PROVISION;
        }
        if (DEF_SERVLET_API_PROVISION.equals(provideServletApi)) {
            this.servApiFilter = GrantedAuthorityDefaultsParserUtils.registerWithDefaultRolePrefix(this.pc, SecurityContextHolderAwareRequestFilterBeanFactory.class);
            this.servApiFilter.getPropertyValues().add("authenticationManager", (Object)authenticationManager);
            this.servApiFilter.getPropertyValues().add("securityContextHolderStrategy", (Object)this.holderStrategyRef);
        }
    }

    private void createJaasApiFilter() {
        String provideJaasApi = this.httpElt.getAttribute(ATT_JAAS_API_PROVISION);
        if (!StringUtils.hasText((String)provideJaasApi)) {
            provideJaasApi = DEF_JAAS_API_PROVISION;
        }
        if (DEF_SERVLET_API_PROVISION.equals(provideJaasApi)) {
            this.jaasApiFilter = BeanDefinitionBuilder.rootBeanDefinition(JaasApiIntegrationFilter.class).addPropertyValue("securityContextHolderStrategy", (Object)this.holderStrategyRef).getBeanDefinition();
        }
    }

    private void createChannelProcessingFilter() {
        ManagedMap<BeanMetadataElement, BeanDefinition> channelRequestMap = this.parseInterceptUrlsForChannelSecurity();
        if (channelRequestMap.isEmpty()) {
            return;
        }
        RootBeanDefinition channelFilter = new RootBeanDefinition(ChannelProcessingFilter.class);
        BeanDefinitionBuilder metadataSourceBldr = BeanDefinitionBuilder.rootBeanDefinition(DefaultFilterInvocationSecurityMetadataSource.class);
        metadataSourceBldr.addConstructorArgValue(channelRequestMap);
        channelFilter.getPropertyValues().addPropertyValue("securityMetadataSource", (Object)metadataSourceBldr.getBeanDefinition());
        RootBeanDefinition channelDecisionManager = new RootBeanDefinition(ChannelDecisionManagerImpl.class);
        ManagedList channelProcessors = new ManagedList(3);
        RootBeanDefinition secureChannelProcessor = new RootBeanDefinition(SecureChannelProcessor.class);
        RootBeanDefinition retryWithHttp = new RootBeanDefinition(RetryWithHttpEntryPoint.class);
        RootBeanDefinition retryWithHttps = new RootBeanDefinition(RetryWithHttpsEntryPoint.class);
        retryWithHttp.getPropertyValues().addPropertyValue("portMapper", (Object)this.portMapper);
        retryWithHttp.getPropertyValues().addPropertyValue("portResolver", (Object)this.portResolver);
        retryWithHttps.getPropertyValues().addPropertyValue("portMapper", (Object)this.portMapper);
        retryWithHttps.getPropertyValues().addPropertyValue("portResolver", (Object)this.portResolver);
        secureChannelProcessor.getPropertyValues().addPropertyValue("entryPoint", (Object)retryWithHttps);
        RootBeanDefinition inSecureChannelProcessor = new RootBeanDefinition(InsecureChannelProcessor.class);
        inSecureChannelProcessor.getPropertyValues().addPropertyValue("entryPoint", (Object)retryWithHttp);
        channelProcessors.add((Object)secureChannelProcessor);
        channelProcessors.add((Object)inSecureChannelProcessor);
        channelDecisionManager.getPropertyValues().addPropertyValue("channelProcessors", (Object)channelProcessors);
        String id = this.pc.getReaderContext().registerWithGeneratedName((BeanDefinition)channelDecisionManager);
        channelFilter.getPropertyValues().addPropertyValue("channelDecisionManager", (Object)new RuntimeBeanReference(id));
        this.cpf = channelFilter;
    }

    private ManagedMap<BeanMetadataElement, BeanDefinition> parseInterceptUrlsForChannelSecurity() {
        ManagedMap channelRequestMap = new ManagedMap();
        for (Element urlElt : this.interceptUrls) {
            String requiredChannel;
            String path = urlElt.getAttribute("pattern");
            String method = urlElt.getAttribute("method");
            String matcherRef = urlElt.getAttribute("request-matcher-ref");
            boolean hasMatcherRef = StringUtils.hasText((String)matcherRef);
            if (!hasMatcherRef && !StringUtils.hasText((String)path)) {
                this.pc.getReaderContext().error("pattern attribute cannot be empty or null", (Object)urlElt);
            }
            if (!StringUtils.hasText((String)(requiredChannel = urlElt.getAttribute("requires-channel")))) continue;
            RuntimeBeanReference matcher = hasMatcherRef ? new RuntimeBeanReference(matcherRef) : this.matcherType.createMatcher(this.pc, path, method);
            RootBeanDefinition channelAttributes = new RootBeanDefinition(ChannelAttributeFactory.class);
            channelAttributes.getConstructorArgumentValues().addGenericArgumentValue((Object)requiredChannel);
            channelAttributes.setFactoryMethodName("createChannelAttributes");
            channelRequestMap.put((Object)matcher, (Object)channelAttributes);
        }
        return channelRequestMap;
    }

    private void createRequestCacheFilter() {
        Element requestCacheElt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"request-cache");
        if (requestCacheElt != null) {
            this.requestCache = new RuntimeBeanReference(requestCacheElt.getAttribute(ATT_REF));
        } else {
            BeanDefinitionBuilder requestCacheBldr;
            if (this.sessionPolicy == SessionCreationPolicy.STATELESS) {
                requestCacheBldr = BeanDefinitionBuilder.rootBeanDefinition(NullRequestCache.class);
            } else {
                requestCacheBldr = BeanDefinitionBuilder.rootBeanDefinition(HttpSessionRequestCache.class);
                requestCacheBldr.addPropertyValue("createSessionAllowed", (Object)(this.sessionPolicy == SessionCreationPolicy.IF_REQUIRED ? 1 : 0));
                requestCacheBldr.addPropertyValue("portResolver", (Object)this.portResolver);
                if (this.csrfFilter != null) {
                    BeanDefinitionBuilder requestCacheMatcherBldr = BeanDefinitionBuilder.rootBeanDefinition(AntPathRequestMatcher.class);
                    requestCacheMatcherBldr.addConstructorArgValue((Object)"/**");
                    requestCacheMatcherBldr.addConstructorArgValue((Object)"GET");
                    requestCacheBldr.addPropertyValue("requestMatcher", (Object)requestCacheMatcherBldr.getBeanDefinition());
                }
            }
            AbstractBeanDefinition bean = requestCacheBldr.getBeanDefinition();
            String id = this.pc.getReaderContext().generateBeanName((BeanDefinition)bean);
            this.pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)bean, id));
            this.requestCache = new RuntimeBeanReference(id);
        }
        this.requestCacheAwareFilter = new RootBeanDefinition(RequestCacheAwareFilter.class);
        this.requestCacheAwareFilter.getConstructorArgumentValues().addGenericArgumentValue((Object)this.requestCache);
    }

    private void createFilterSecurity(BeanReference authManager) {
        if (StringUtils.hasText((String)this.httpElt.getAttribute(ATT_AUTHORIZATION_MGR))) {
            this.createAuthorizationFilter();
            return;
        }
        boolean useAuthorizationManager = true;
        if (StringUtils.hasText((String)this.httpElt.getAttribute(ATT_USE_AUTHORIZATION_MGR))) {
            useAuthorizationManager = Boolean.parseBoolean(this.httpElt.getAttribute(ATT_USE_AUTHORIZATION_MGR));
        }
        if (useAuthorizationManager) {
            this.createAuthorizationFilter();
            return;
        }
        this.createFilterSecurityInterceptor(authManager);
    }

    private void createAuthorizationFilter() {
        AuthorizationFilterParser authorizationFilterParser = new AuthorizationFilterParser(this.holderStrategyRef);
        BeanDefinition fsiBean = authorizationFilterParser.parse(this.httpElt, this.pc);
        String fsiId = this.pc.getReaderContext().generateBeanName(fsiBean);
        this.pc.registerBeanComponent(new BeanComponentDefinition(fsiBean, fsiId));
        BeanDefinitionBuilder wipeBldr = BeanDefinitionBuilder.rootBeanDefinition(AuthorizationManagerWebInvocationPrivilegeEvaluator.class).addConstructorArgReference(authorizationFilterParser.getAuthorizationManagerRef());
        if (mvcPresent) {
            wipeBldr.addPropertyValue("requestTransformer", (Object)new RootBeanDefinition(HandlerMappingIntrospectorRequestTransformerFactoryBean.class));
        }
        AbstractBeanDefinition wipe = wipeBldr.getBeanDefinition();
        this.pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)wipe, this.pc.getReaderContext().generateBeanName((BeanDefinition)wipe)));
        this.fsi = new RuntimeBeanReference(fsiId);
    }

    private void createFilterSecurityInterceptor(BeanReference authManager) {
        boolean useExpressions = FilterInvocationSecurityMetadataSourceParser.isUseExpressions(this.httpElt);
        RootBeanDefinition securityMds = FilterInvocationSecurityMetadataSourceParser.createSecurityMetadataSource(this.interceptUrls, this.addAllAuth, this.httpElt, this.pc);
        ManagedList voters = new ManagedList(2);
        if (useExpressions) {
            BeanDefinitionBuilder expressionVoter = BeanDefinitionBuilder.rootBeanDefinition(WebExpressionVoter.class);
            RuntimeBeanReference expressionHandler = (RuntimeBeanReference)securityMds.getConstructorArgumentValues().getArgumentValue(1, RuntimeBeanReference.class).getValue();
            expressionVoter.addPropertyValue("expressionHandler", (Object)expressionHandler);
            voters.add((Object)expressionVoter.getBeanDefinition());
        } else {
            voters.add((Object)GrantedAuthorityDefaultsParserUtils.registerWithDefaultRolePrefix(this.pc, RoleVoterBeanFactory.class));
            voters.add((Object)new RootBeanDefinition(AuthenticatedVoter.class));
        }
        RootBeanDefinition accessDecisionMgr = new RootBeanDefinition(AffirmativeBased.class);
        accessDecisionMgr.getConstructorArgumentValues().addGenericArgumentValue((Object)voters);
        accessDecisionMgr.setSource(this.pc.extractSource((Object)this.httpElt));
        String accessManagerId = this.httpElt.getAttribute(ATT_ACCESS_MGR);
        if (!StringUtils.hasText((String)accessManagerId)) {
            accessManagerId = this.pc.getReaderContext().generateBeanName((BeanDefinition)accessDecisionMgr);
            this.pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)accessDecisionMgr, accessManagerId));
        }
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(FilterSecurityInterceptor.class);
        builder.addPropertyReference("accessDecisionManager", accessManagerId);
        builder.addPropertyValue("authenticationManager", (Object)authManager);
        if (DEF_SERVLET_API_PROVISION.equals(this.httpElt.getAttribute(ATT_ONCE_PER_REQUEST))) {
            builder.addPropertyValue("observeOncePerRequest", (Object)Boolean.TRUE);
        }
        builder.addPropertyValue("securityMetadataSource", (Object)securityMds);
        builder.addPropertyValue("securityContextHolderStrategy", (Object)this.holderStrategyRef);
        AbstractBeanDefinition fsiBean = builder.getBeanDefinition();
        String fsiId = this.pc.getReaderContext().generateBeanName((BeanDefinition)fsiBean);
        this.pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)fsiBean, fsiId));
        RootBeanDefinition wipe = new RootBeanDefinition(DefaultWebInvocationPrivilegeEvaluator.class);
        wipe.getConstructorArgumentValues().addGenericArgumentValue((Object)new RuntimeBeanReference(fsiId));
        this.pc.registerBeanComponent(new BeanComponentDefinition((BeanDefinition)wipe, this.pc.getReaderContext().generateBeanName((BeanDefinition)wipe)));
        this.fsi = new RuntimeBeanReference(fsiId);
    }

    private void createAddHeadersFilter() {
        Element elmt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"headers");
        this.addHeadersFilter = new HeadersBeanDefinitionParser().parse(elmt, this.pc);
    }

    private void createCorsFilter() {
        Element elmt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"cors");
        this.corsFilter = new CorsBeanDefinitionParser().parse(elmt, this.pc);
    }

    private void createDisableEncodeUrlFilter() {
        if (this.isDisableUrlRewriting()) {
            this.disableUrlRewriteFilter = new RootBeanDefinition(DisableEncodeUrlFilter.class);
        }
    }

    private void createCsrfFilter(BeanMetadataElement observationRegistry) {
        Element elmt = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"csrf");
        this.csrfParser = new CsrfBeanDefinitionParser();
        this.csrfParser.setObservationRegistry(observationRegistry);
        this.csrfFilter = this.csrfParser.parse(elmt, this.pc);
        if (this.csrfFilter == null) {
            this.csrfParser = null;
            return;
        }
        this.csrfAuthStrategy = this.csrfParser.getCsrfAuthenticationStrategy();
        this.csrfLogoutHandler = this.csrfParser.getCsrfLogoutHandler();
    }

    private void createWellKnownChangePasswordRedirectFilter() {
        Element element = DomUtils.getChildElementByTagName((Element)this.httpElt, (String)"password-management");
        if (element == null) {
            return;
        }
        WellKnownChangePasswordBeanDefinitionParser parser = new WellKnownChangePasswordBeanDefinitionParser();
        this.wellKnownChangePasswordRedirectFilter = parser.parse(element, this.pc);
    }

    BeanMetadataElement getCsrfLogoutHandler() {
        return this.csrfLogoutHandler;
    }

    BeanReference getSessionStrategy() {
        return this.sessionStrategyRef;
    }

    SessionCreationPolicy getSessionCreationPolicy() {
        return this.sessionPolicy;
    }

    BeanReference getRequestCache() {
        return this.requestCache;
    }

    List<OrderDecorator> getFilters() {
        ArrayList<OrderDecorator> filters = new ArrayList<OrderDecorator>();
        if (this.forceEagerSessionCreationFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.forceEagerSessionCreationFilter, SecurityFilters.FORCE_EAGER_SESSION_FILTER));
        }
        if (this.disableUrlRewriteFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.disableUrlRewriteFilter, SecurityFilters.DISABLE_ENCODE_URL_FILTER));
        }
        if (this.cpf != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.cpf, SecurityFilters.CHANNEL_FILTER));
        }
        if (this.concurrentSessionFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.concurrentSessionFilter, SecurityFilters.CONCURRENT_SESSION_FILTER));
        }
        if (this.webAsyncManagerFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.webAsyncManagerFilter, SecurityFilters.WEB_ASYNC_MANAGER_FILTER));
        }
        filters.add(new OrderDecorator((BeanMetadataElement)this.securityContextPersistenceFilter, SecurityFilters.SECURITY_CONTEXT_FILTER));
        if (this.servApiFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.servApiFilter, SecurityFilters.SERVLET_API_SUPPORT_FILTER));
        }
        if (this.jaasApiFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.jaasApiFilter, SecurityFilters.JAAS_API_SUPPORT_FILTER));
        }
        if (this.sfpf != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.sfpf, SecurityFilters.SESSION_MANAGEMENT_FILTER));
        }
        filters.add(new OrderDecorator((BeanMetadataElement)this.fsi, SecurityFilters.FILTER_SECURITY_INTERCEPTOR));
        if (this.sessionPolicy != SessionCreationPolicy.STATELESS) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.requestCacheAwareFilter, SecurityFilters.REQUEST_CACHE_FILTER));
        }
        if (this.corsFilter != null) {
            filters.add(new OrderDecorator(this.corsFilter, SecurityFilters.CORS_FILTER));
        }
        if (this.addHeadersFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.addHeadersFilter, SecurityFilters.HEADERS_FILTER));
        }
        if (this.csrfFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.csrfFilter, SecurityFilters.CSRF_FILTER));
        }
        if (this.wellKnownChangePasswordRedirectFilter != null) {
            filters.add(new OrderDecorator((BeanMetadataElement)this.wellKnownChangePasswordRedirectFilter, SecurityFilters.WELL_KNOWN_CHANGE_PASSWORD_REDIRECT_FILTER));
        }
        return filters;
    }

    private static BeanMetadataElement getObservationRegistry(Element httpElmt) {
        String holderStrategyRef = httpElmt.getAttribute(ATT_OBSERVATION_REGISTRY_REF);
        if (StringUtils.hasText((String)holderStrategyRef)) {
            return new RuntimeBeanReference(holderStrategyRef);
        }
        return BeanDefinitionBuilder.rootBeanDefinition(ObservationRegistryFactory.class).getBeanDefinition();
    }

    static class SecurityContextHolderStrategyFactory
    implements FactoryBean<SecurityContextHolderStrategy> {
        SecurityContextHolderStrategyFactory() {
        }

        public SecurityContextHolderStrategy getObject() throws Exception {
            return SecurityContextHolder.getContextHolderStrategy();
        }

        public Class<?> getObjectType() {
            return SecurityContextHolderStrategy.class;
        }
    }

    static class SecurityContextHolderAwareRequestFilterBeanFactory
    extends GrantedAuthorityDefaultsParserUtils.AbstractGrantedAuthorityDefaultsBeanFactory {
        private SecurityContextHolderAwareRequestFilter filter = new SecurityContextHolderAwareRequestFilter();
        private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();

        SecurityContextHolderAwareRequestFilterBeanFactory() {
        }

        public SecurityContextHolderAwareRequestFilter getBean() {
            this.filter.setSecurityContextHolderStrategy(this.securityContextHolderStrategy);
            this.filter.setRolePrefix(this.rolePrefix);
            return this.filter;
        }

        void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
            this.securityContextHolderStrategy = securityContextHolderStrategy;
        }
    }

    static class HandlerMappingIntrospectorRequestTransformerFactoryBean
    implements FactoryBean<AuthorizationManagerWebInvocationPrivilegeEvaluator.HttpServletRequestTransformer>,
    ApplicationContextAware {
        private ApplicationContext applicationContext;

        HandlerMappingIntrospectorRequestTransformerFactoryBean() {
        }

        public AuthorizationManagerWebInvocationPrivilegeEvaluator.HttpServletRequestTransformer getObject() throws Exception {
            HandlerMappingIntrospector hmi = (HandlerMappingIntrospector)this.applicationContext.getBeanProvider(HandlerMappingIntrospector.class).getIfAvailable();
            return hmi != null ? new HandlerMappingIntrospectorRequestTransformer(hmi) : AuthorizationManagerWebInvocationPrivilegeEvaluator.HttpServletRequestTransformer.IDENTITY;
        }

        public Class<?> getObjectType() {
            return AuthorizationManagerWebInvocationPrivilegeEvaluator.HttpServletRequestTransformer.class;
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }
    }

    static class RoleVoterBeanFactory
    extends GrantedAuthorityDefaultsParserUtils.AbstractGrantedAuthorityDefaultsBeanFactory {
        private RoleVoter voter = new RoleVoter();

        RoleVoterBeanFactory() {
        }

        public RoleVoter getBean() {
            this.voter.setRolePrefix(this.rolePrefix);
            return this.voter;
        }
    }

    static class ObservationRegistryFactory
    implements FactoryBean<ObservationRegistry> {
        ObservationRegistryFactory() {
        }

        public ObservationRegistry getObject() throws Exception {
            return ObservationRegistry.NOOP;
        }

        public Class<?> getObjectType() {
            return ObservationRegistry.class;
        }
    }
}

