/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.annotation.web.configurers;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.core.authority.mapping.MappableAttributesRetriever;
import org.springframework.security.core.authority.mapping.SimpleMappableAttributesRetriever;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.Http403ForbiddenEntryPoint;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationProvider;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedGrantedAuthoritiesUserDetailsService;
import org.springframework.security.web.authentication.preauth.j2ee.J2eeBasedPreAuthenticatedWebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.preauth.j2ee.J2eePreAuthenticatedProcessingFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JeeConfigurer<H extends HttpSecurityBuilder<H>>
extends AbstractHttpConfigurer<JeeConfigurer<H>, H> {
    private J2eePreAuthenticatedProcessingFilter j2eePreAuthenticatedProcessingFilter;
    private AuthenticationUserDetailsService<PreAuthenticatedAuthenticationToken> authenticationUserDetailsService;
    private Set<String> mappableRoles = new HashSet<String>();

    public JeeConfigurer<H> mappableAuthorities(String ... mappableRoles) {
        this.mappableRoles.clear();
        for (String role : mappableRoles) {
            this.mappableRoles.add(role);
        }
        return this;
    }

    public JeeConfigurer<H> mappableRoles(String ... mappableRoles) {
        this.mappableRoles.clear();
        for (String role : mappableRoles) {
            this.mappableRoles.add("ROLE_" + role);
        }
        return this;
    }

    public JeeConfigurer<H> mappableAuthorities(Set<String> mappableRoles) {
        this.mappableRoles = mappableRoles;
        return this;
    }

    public JeeConfigurer<H> authenticatedUserDetailsService(AuthenticationUserDetailsService<PreAuthenticatedAuthenticationToken> authenticatedUserDetailsService) {
        this.authenticationUserDetailsService = authenticatedUserDetailsService;
        return this;
    }

    public JeeConfigurer<H> j2eePreAuthenticatedProcessingFilter(J2eePreAuthenticatedProcessingFilter j2eePreAuthenticatedProcessingFilter) {
        this.j2eePreAuthenticatedProcessingFilter = j2eePreAuthenticatedProcessingFilter;
        return this;
    }

    @Override
    public void init(H http) throws Exception {
        PreAuthenticatedAuthenticationProvider authenticationProvider = new PreAuthenticatedAuthenticationProvider();
        authenticationProvider.setPreAuthenticatedUserDetailsService(this.getUserDetailsService());
        authenticationProvider = this.postProcess(authenticationProvider);
        http.authenticationProvider((AuthenticationProvider)authenticationProvider).setSharedObject(AuthenticationEntryPoint.class, (Http403ForbiddenEntryPoint)new Http403ForbiddenEntryPoint());
    }

    @Override
    public void configure(H http) throws Exception {
        J2eePreAuthenticatedProcessingFilter filter = this.getFilter(http.getSharedObject(AuthenticationManager.class));
        http.addFilter((Filter)filter);
    }

    private J2eePreAuthenticatedProcessingFilter getFilter(AuthenticationManager authenticationManager) {
        if (this.j2eePreAuthenticatedProcessingFilter == null) {
            this.j2eePreAuthenticatedProcessingFilter = new J2eePreAuthenticatedProcessingFilter();
            this.j2eePreAuthenticatedProcessingFilter.setAuthenticationManager(authenticationManager);
            this.j2eePreAuthenticatedProcessingFilter.setAuthenticationDetailsSource((AuthenticationDetailsSource)this.createWebAuthenticationDetailsSource());
            this.j2eePreAuthenticatedProcessingFilter = this.postProcess(this.j2eePreAuthenticatedProcessingFilter);
        }
        return this.j2eePreAuthenticatedProcessingFilter;
    }

    private AuthenticationUserDetailsService<PreAuthenticatedAuthenticationToken> getUserDetailsService() {
        return this.authenticationUserDetailsService == null ? new PreAuthenticatedGrantedAuthoritiesUserDetailsService() : this.authenticationUserDetailsService;
    }

    private J2eeBasedPreAuthenticatedWebAuthenticationDetailsSource createWebAuthenticationDetailsSource() {
        J2eeBasedPreAuthenticatedWebAuthenticationDetailsSource detailsSource = new J2eeBasedPreAuthenticatedWebAuthenticationDetailsSource();
        SimpleMappableAttributesRetriever rolesRetriever = new SimpleMappableAttributesRetriever();
        rolesRetriever.setMappableAttributes(this.mappableRoles);
        detailsSource.setMappableRolesRetriever((MappableAttributesRetriever)rolesRetriever);
        detailsSource = this.postProcess(detailsSource);
        return detailsSource;
    }
}

