/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection;

import java.nio.ByteBuffer;
import org.reactivestreams.Publisher;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface ReactiveNumberCommands {
    default public Mono<Long> incr(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.incr((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> incr(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public <T extends Number> Mono<T> incrBy(ByteBuffer key, T value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(value, (String)"Value must not be null!");
        return this.incrBy((Publisher<IncrByCommand<T>>)Mono.just(IncrByCommand.incr(key).by(value))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public <T extends Number> Flux<ReactiveRedisConnection.NumericResponse<IncrByCommand<T>, T>> incrBy(Publisher<IncrByCommand<T>> var1);

    default public Mono<Long> decr(ByteBuffer key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        return this.decr((Publisher<ReactiveRedisConnection.KeyCommand>)Mono.just((Object)new ReactiveRedisConnection.KeyCommand(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> decr(Publisher<ReactiveRedisConnection.KeyCommand> var1);

    default public <T extends Number> Mono<T> decrBy(ByteBuffer key, T value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull(value, (String)"Value must not be null!");
        return this.decrBy((Publisher<DecrByCommand<T>>)Mono.just(DecrByCommand.decr(key).by(value))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public <T extends Number> Flux<ReactiveRedisConnection.NumericResponse<DecrByCommand<T>, T>> decrBy(Publisher<DecrByCommand<T>> var1);

    default public <T extends Number> Mono<T> hIncrBy(ByteBuffer key, ByteBuffer field, T value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)field, (String)"Field must not be null!");
        Assert.notNull(value, (String)"Value must not be null!");
        return this.hIncrBy((Publisher<HIncrByCommand<T>>)Mono.just(HIncrByCommand.incr(field).by(value).forKey(key))).next().map(ReactiveRedisConnection.CommandResponse::getOutput);
    }

    public <T extends Number> Flux<ReactiveRedisConnection.NumericResponse<HIncrByCommand<T>, T>> hIncrBy(Publisher<HIncrByCommand<T>> var1);

    public static class HIncrByCommand<T extends Number>
    extends ReactiveRedisConnection.KeyCommand {
        private final ByteBuffer field;
        @Nullable
        private final T value;

        private HIncrByCommand(@Nullable ByteBuffer key, ByteBuffer field, @Nullable T value) {
            super(key);
            this.field = field;
            this.value = value;
        }

        public static <T extends Number> HIncrByCommand<T> incr(ByteBuffer field) {
            Assert.notNull((Object)field, (String)"Field must not be null!");
            return new HIncrByCommand<Object>(null, field, null);
        }

        public HIncrByCommand<T> by(T value) {
            Assert.notNull(value, (String)"Value must not be null!");
            return new HIncrByCommand<T>(this.getKey(), this.field, value);
        }

        public HIncrByCommand<T> forKey(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new HIncrByCommand<T>(key, this.field, this.value);
        }

        @Nullable
        public T getValue() {
            return this.value;
        }

        public ByteBuffer getField() {
            return this.field;
        }
    }

    public static class DecrByCommand<T extends Number>
    extends ReactiveRedisConnection.KeyCommand {
        @Nullable
        private T value;

        private DecrByCommand(ByteBuffer key, @Nullable T value) {
            super(key);
            this.value = value;
        }

        public static <T extends Number> DecrByCommand<T> decr(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new DecrByCommand<Object>(key, null);
        }

        public DecrByCommand<T> by(T value) {
            Assert.notNull(value, (String)"Value must not be null!");
            return new DecrByCommand<T>(this.getKey(), value);
        }

        @Nullable
        public T getValue() {
            return this.value;
        }
    }

    public static class IncrByCommand<T extends Number>
    extends ReactiveRedisConnection.KeyCommand {
        @Nullable
        private T value;

        private IncrByCommand(ByteBuffer key, @Nullable T value) {
            super(key);
            this.value = value;
        }

        public static <T extends Number> IncrByCommand<T> incr(ByteBuffer key) {
            Assert.notNull((Object)key, (String)"Key must not be null!");
            return new IncrByCommand<Object>(key, null);
        }

        public IncrByCommand<T> by(T value) {
            Assert.notNull(value, (String)"Value must not be null!");
            return new IncrByCommand<T>(this.getKey(), value);
        }

        @Nullable
        public T getValue() {
            return this.value;
        }
    }
}

