/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.support.path;

import org.neo4j.graphdb.Path;
import org.springframework.data.neo4j.core.EntityPath;
import org.springframework.data.neo4j.support.Neo4jTemplate;
import org.springframework.data.neo4j.support.path.ConvertingEntityPath;
import org.springframework.data.neo4j.support.path.PathMapper;

public abstract class EntityMapper<S, E, T>
implements PathMapper<T> {
    private Neo4jTemplate template;

    protected EntityMapper(Neo4jTemplate template) {
        this.template = template;
    }

    public abstract T mapPath(EntityPath<S, E> var1);

    @Override
    public T mapPath(Path path) {
        return this.mapPath(new ConvertingEntityPath(path, this.template));
    }

    public static abstract class WithoutResult<S, E>
    extends EntityMapper<S, E, Void> {
        protected WithoutResult(Neo4jTemplate template) {
            super(template);
        }

        @Override
        public Void mapPath(EntityPath<S, E> entityPath) {
            this.doWithPath(entityPath);
            return null;
        }

        public abstract void doWithPath(EntityPath<S, E> var1);
    }
}

