/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.encryption;

import org.bson.BsonBinary;
import org.springframework.data.mongodb.core.encryption.KeyAltName;
import org.springframework.data.mongodb.core.encryption.KeyId;
import org.springframework.util.Assert;

public interface EncryptionKey {
    public static EncryptionKey keyId(BsonBinary key) {
        Assert.notNull((Object)key, (String)"KeyId must not be null");
        return new KeyId(key);
    }

    public static EncryptionKey keyAltName(String keyAltName) {
        Assert.hasText((String)keyAltName, (String)"Key Alternative Name must not be empty");
        return new KeyAltName(keyAltName);
    }

    public Object value();

    public Type type();

    public static enum Type {
        ID,
        ALT;

    }
}

