/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.monitor;

import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.authentication.UserCredentials;
import org.springframework.data.mongodb.core.MongoDbUtils;

public abstract class AbstractMonitor {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Mongo mongo;
    private String username;
    private String password;

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public CommandResult getServerStatus() {
        CommandResult result = this.getDb("admin").command("serverStatus");
        if (!result.ok()) {
            this.logger.error("Could not query for server status.  Command Result = " + result);
            throw new MongoException("could not query for server status.  Command Result = " + result);
        }
        return result;
    }

    public DB getDb(String databaseName) {
        return MongoDbUtils.getDB(this.mongo, databaseName, new UserCredentials(this.username, this.password));
    }
}

