/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.generate.GenerationContext;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.aot.BeanRegistrationAotContribution;
import org.springframework.beans.factory.aot.BeanRegistrationAotProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.env.Environment;
import org.springframework.core.env.EnvironmentCapable;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.data.aot.AotContext;
import org.springframework.data.aot.AotTypeConfiguration;
import org.springframework.data.projection.EntityProjectionIntrospector;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.aot.generate.RepositoryContributor;
import org.springframework.data.repository.config.AotRepositoryContext;
import org.springframework.data.repository.config.DefaultAotRepositoryContext;
import org.springframework.data.repository.config.RepositoryBeanDefinitionReader;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryRegistrationAotContribution;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.util.TypeContributor;
import org.springframework.data.util.TypeUtils;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class RepositoryRegistrationAotProcessor
implements BeanRegistrationAotProcessor,
BeanFactoryAware,
EnvironmentAware,
EnvironmentCapable {
    private static final String KOTLIN_COROUTINE_REPOSITORY_TYPE_NAME = "org.springframework.data.repository.kotlin.CoroutineCrudRepository";
    private static final List<TypeReference> KOTLIN_REFLECTION_TYPE_REFERENCES = List.of(TypeReference.of((String)"org.springframework.data.repository.kotlin.CoroutineCrudRepository"), TypeReference.of(Repository.class), TypeReference.of(Iterable.class), TypeReference.of((String)"kotlinx.coroutines.flow.Flow"), TypeReference.of((String)"kotlin.collections.Iterable"), TypeReference.of((String)"kotlin.Unit"), TypeReference.of((String)"kotlin.Long"), TypeReference.of((String)"kotlin.Boolean"));
    private final Log logger = LogFactory.getLog(this.getClass());
    private @Nullable ConfigurableListableBeanFactory beanFactory;
    private Environment environment = new StandardEnvironment();
    private Map<String, RepositoryConfiguration<?>> configMap = Collections.emptyMap();

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory, () -> "AutowiredAnnotationBeanPostProcessor requires a ConfigurableListableBeanFactory: " + String.valueOf(beanFactory));
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void setConfigMap(Map<String, RepositoryConfiguration<?>> configMap) {
        this.configMap = configMap;
    }

    public Map<String, RepositoryConfiguration<?>> getConfigMap() {
        return this.configMap;
    }

    protected ConfigurableListableBeanFactory getBeanFactory() {
        if (this.beanFactory == null) {
            throw new IllegalStateException("No BeanFactory available. Make sure to set the BeanFactory before using this processor.");
        }
        return this.beanFactory;
    }

    public @Nullable BeanRegistrationAotContribution processAheadOfTime(RegisteredBean bean) {
        if (!this.isRepositoryBean(bean)) {
            return null;
        }
        RepositoryConfiguration<?> repositoryMetadata = this.getRepositoryMetadata(bean);
        AotRepositoryContext repositoryContext = this.potentiallyCreateContext(this.environment, bean);
        if (repositoryMetadata == null || repositoryContext == null) {
            return null;
        }
        BeanRegistrationAotContribution contribution = (generationContext, beanRegistrationCode) -> {
            this.registerRepositoryCompositionHints(repositoryContext, generationContext);
            this.configureTypeContributions(repositoryContext, generationContext);
            repositoryContext.contributeTypeConfigurations(generationContext);
        };
        return new RepositoryRegistrationAotContribution(repositoryContext, contribution, this.contributeAotRepository(repositoryContext));
    }

    protected void registerRepositoryCompositionHints(AotRepositoryContext repositoryContext, GenerationContext generationContext) {
        RepositoryInformation repositoryInformation = repositoryContext.getRepositoryInformation();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)"Contributing repository information for [%s]".formatted(repositoryInformation.getRepositoryInterface()));
        }
        repositoryContext.typeConfiguration(repositoryInformation.getRepositoryInterface(), config -> config.forReflectiveAccess(MemberCategory.INVOKE_PUBLIC_METHODS).repositoryProxy());
        repositoryContext.typeConfiguration(repositoryInformation.getRepositoryBaseClass(), config -> config.forReflectiveAccess(MemberCategory.INVOKE_DECLARED_CONSTRUCTORS, MemberCategory.INVOKE_PUBLIC_METHODS));
        this.registerFragmentsHints(repositoryInformation.getFragments(), generationContext);
        if (RepositoryRegistrationAotProcessor.isKotlinCoroutineRepository(repositoryInformation)) {
            generationContext.getRuntimeHints().reflection().registerTypes(KOTLIN_REFLECTION_TYPE_REFERENCES, hint -> {});
        }
    }

    protected void configureTypeContributions(AotRepositoryContext repositoryContext, GenerationContext generationContext) {
        RepositoryInformation information = repositoryContext.getRepositoryInformation();
        this.configureDomainTypeContributions(repositoryContext, generationContext);
        information.getQueryMethods().stream().map(information::getReturnedDomainClass).filter(Class::isInterface).forEach(type -> {
            if (EntityProjectionIntrospector.ProjectionPredicate.typeHierarchy().test((Class<?>)type, information.getDomainType())) {
                repositoryContext.typeConfiguration((Class<?>)type, AotTypeConfiguration::usedAsProjectionInterface);
            }
        });
        repositoryContext.getResolvedAnnotations().stream().filter(RepositoryRegistrationAotProcessor::isSpringDataManagedAnnotation).map(MergedAnnotation::getType).forEach(it -> this.contributeType((Class<?>)it, generationContext));
    }

    private void configureDomainTypeContributions(AotRepositoryContext repositoryContext, GenerationContext generationContext) {
        RepositoryInformation information = repositoryContext.getRepositoryInformation();
        Stream.concat(Stream.of(information.getDomainType()), information.getAlternativeDomainTypes().stream()).forEach(it -> this.configureTypeContribution((Class<?>)it, repositoryContext));
        repositoryContext.getResolvedTypes().stream().filter(it -> TypeContributor.isPartOf(it, Set.of(information.getDomainType().getPackageName()))).forEach(it -> this.configureTypeContribution((Class<?>)it, repositoryContext));
        repositoryContext.getResolvedTypes().stream().filter(it -> !RepositoryRegistrationAotProcessor.isJavaOrPrimitiveType(it)).forEach(it -> this.contributeType((Class<?>)it, generationContext));
    }

    protected void configureTypeContribution(Class<?> type, AotContext aotContext) {
        aotContext.typeConfiguration(type, config -> config.forDataBinding().contributeAccessors().forQuerydsl());
    }

    protected @Nullable RepositoryContributor contributeAotRepository(AotRepositoryContext repositoryContext) {
        return null;
    }

    private boolean isRepositoryBean(RegisteredBean bean) {
        return this.getConfigMap().containsKey(bean.getBeanName());
    }

    private RepositoryConfiguration<?> getRepositoryMetadata(RegisteredBean bean) {
        RepositoryConfiguration<?> configuration = this.getConfigMap().get(bean.getBeanName());
        if (configuration == null) {
            throw new IllegalArgumentException("No configuration for bean [%s]".formatted(bean.getBeanName()));
        }
        return configuration;
    }

    private void contributeType(Class<?> type, GenerationContext context) {
        TypeContributor.contribute(type, it -> true, context);
    }

    private void registerFragmentsHints(Iterable<RepositoryFragment<?>> fragments, GenerationContext contribution) {
        fragments.forEach(it -> RepositoryRegistrationAotProcessor.registerFragmentHints(it, contribution));
    }

    private static void registerFragmentHints(RepositoryFragment<?> fragment, GenerationContext context) {
        Class<?> repositoryFragmentType = fragment.getSignatureContributor();
        Optional<Class<?>> implementation = fragment.getImplementationClass();
        RepositoryRegistrationAotProcessor.registerReflectiveHints(repositoryFragmentType, context);
        implementation.ifPresent(typeToRegister -> RepositoryRegistrationAotProcessor.registerReflectiveHints(typeToRegister, context));
    }

    private static void registerReflectiveHints(Class<?> typeToRegister, GenerationContext context) {
        context.getRuntimeHints().reflection().registerType(typeToRegister, hint -> {
            hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_PUBLIC_METHODS});
            if (!typeToRegister.isInterface()) {
                hint.withMembers(new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
            }
        });
    }

    private @Nullable AotRepositoryContext potentiallyCreateContext(Environment environment, RegisteredBean bean) {
        RepositoryBeanDefinitionReader reader = new RepositoryBeanDefinitionReader(bean);
        RepositoryConfiguration<?> configuration = reader.getConfiguration();
        RepositoryConfigurationExtensionSupport extension = reader.getConfigurationExtension();
        if (configuration == null || extension == null) {
            this.logger.warn((Object)"Cannot create AotRepositoryContext for bean [%s]. No RepositoryConfiguration/RepositoryConfigurationExtension. Please make sure to register the repository bean through @Enable\u2026Repositories.".formatted(bean.getBeanName()));
            return null;
        }
        RepositoryInformation repositoryInformation = reader.getRepositoryInformation();
        DefaultAotRepositoryContext repositoryContext = new DefaultAotRepositoryContext(bean, repositoryInformation, extension.getModuleName(), AotContext.from((BeanFactory)bean.getBeanFactory(), environment), (RepositoryConfigurationSource)configuration.getConfigurationSource());
        repositoryContext.setIdentifyingAnnotations(extension.getIdentifyingAnnotations());
        return repositoryContext;
    }

    private static boolean isKotlinCoroutineRepository(RepositoryInformation repositoryInformation) {
        Class<?> coroutineRepository = org.springframework.data.util.ClassUtils.loadIfPresent(KOTLIN_COROUTINE_REPOSITORY_TYPE_NAME, repositoryInformation.getRepositoryInterface().getClassLoader());
        return coroutineRepository != null && ClassUtils.isAssignable(coroutineRepository, repositoryInformation.getRepositoryInterface());
    }

    private static boolean isSpringDataManagedAnnotation(MergedAnnotation<?> annotation) {
        return RepositoryRegistrationAotProcessor.isSpringDataType(annotation.getType()) || annotation.getMetaTypes().stream().anyMatch(RepositoryRegistrationAotProcessor::isSpringDataType);
    }

    private static boolean isSpringDataType(Class<?> type) {
        return type.getPackageName().startsWith("org.springframework.data");
    }

    private static boolean isJavaOrPrimitiveType(Class<?> type) {
        return ClassUtils.isPrimitiveOrWrapper(type) || ClassUtils.isPrimitiveArray(type) || TypeUtils.type(type).isPartOf("java");
    }
}

