/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.convert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.convert.PropertyValueConversions;
import org.springframework.data.convert.PropertyValueConverter;
import org.springframework.data.convert.PropertyValueConverterFactory;
import org.springframework.data.convert.ValueConversionContext;
import org.springframework.data.convert.ValueConverterRegistry;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.util.Assert;

public class SimplePropertyValueConversions
implements PropertyValueConversions,
InitializingBean {
    private static final String NO_CONVERTER_FACTORY_ERROR_MESSAGE = "PropertyValueConverterFactory is not set; Make sure to either set the converter factory or call afterPropertiesSet() to initialize the object";
    private boolean converterCacheEnabled = true;
    private @Nullable PropertyValueConverterFactory converterFactory;
    private @Nullable ValueConverterRegistry<?> valueConverterRegistry;
    private volatile Map<PersistentProperty<?>, PropertyValueConverter<?, ?, ?>> converterCache = new HashMap();

    public void setConverterFactory(@Nullable PropertyValueConverterFactory converterFactory) {
        this.converterFactory = converterFactory;
    }

    public @Nullable PropertyValueConverterFactory getConverterFactory() {
        return this.converterFactory;
    }

    private PropertyValueConverterFactory requireConverterFactory() {
        PropertyValueConverterFactory factory = this.getConverterFactory();
        Assert.state((factory != null ? 1 : 0) != 0, (String)NO_CONVERTER_FACTORY_ERROR_MESSAGE);
        return factory;
    }

    public void setValueConverterRegistry(@Nullable ValueConverterRegistry<?> valueConverterRegistry) {
        this.valueConverterRegistry = valueConverterRegistry;
    }

    public @Nullable ValueConverterRegistry<?> getValueConverterRegistry() {
        return this.valueConverterRegistry;
    }

    public void setConverterCacheEnabled(boolean converterCacheEnabled) {
        this.converterCacheEnabled = converterCacheEnabled;
    }

    @Override
    public boolean hasValueConverter(PersistentProperty<?> property) {
        return this.doGetConverter(property) != null;
    }

    public <DV, SV, P extends PersistentProperty<P>, D extends ValueConversionContext<P>> PropertyValueConverter<DV, SV, D> getValueConverter(P property) {
        PropertyValueConverter<DV, SV, D> converter = this.doGetConverter(property);
        Assert.notNull(converter, (String)String.format("No PropertyValueConverter registered for %s", property));
        return converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <DV, SV, P extends PersistentProperty<P>, D extends ValueConversionContext<P>> @Nullable PropertyValueConverter<DV, SV, D> doGetConverter(PersistentProperty<?> property) {
        PropertyValueConverter<Object, Object, Object> converter = this.converterCache.get(property);
        if (converter == null) {
            SimplePropertyValueConversions simplePropertyValueConversions = this;
            synchronized (simplePropertyValueConversions) {
                PropertyValueConverter<?, ?, ?> fromCache = this.converterCache.get(property);
                if (fromCache != null) {
                    converter = fromCache;
                } else {
                    converter = this.requireConverterFactory().getConverter(property);
                    HashMap converterCache = new HashMap(this.converterCache);
                    converterCache.put(property, converter != null ? converter : NoOpConverter.INSTANCE);
                    this.converterCache = converterCache;
                }
            }
        }
        if (converter == NoOpConverter.INSTANCE) {
            return null;
        }
        return converter;
    }

    public void init() {
        ArrayList<PropertyValueConverterFactory> factoryList = new ArrayList<PropertyValueConverterFactory>(3);
        factoryList.add(this.resolveConverterFactory());
        this.resolveConverterRegistryAsConverterFactory().ifPresent(factoryList::add);
        PropertyValueConverterFactory targetFactory = factoryList.size() > 1 ? PropertyValueConverterFactory.chained(factoryList) : (PropertyValueConverterFactory)factoryList.iterator().next();
        this.converterFactory = this.converterCacheEnabled ? PropertyValueConverterFactory.caching(targetFactory) : targetFactory;
    }

    private PropertyValueConverterFactory resolveConverterFactory() {
        PropertyValueConverterFactory converterFactory = this.getConverterFactory();
        return converterFactory != null ? converterFactory : PropertyValueConverterFactory.simple();
    }

    private Optional<PropertyValueConverterFactory> resolveConverterRegistryAsConverterFactory() {
        return Optional.ofNullable(this.getValueConverterRegistry()).filter(it -> !it.isEmpty()).map(PropertyValueConverterFactory::configuredInstance);
    }

    public void afterPropertiesSet() {
        this.init();
    }

    static enum NoOpConverter implements PropertyValueConverter
    {
        INSTANCE;


        public @Nullable Object read(Object value, ValueConversionContext context) {
            return null;
        }

        public @Nullable Object write(Object value, ValueConversionContext context) {
            return null;
        }
    }
}

