/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.http.HttpClientHandler;
import org.springframework.cloud.sleuth.http.HttpClientRequest;
import org.springframework.cloud.sleuth.http.HttpRequest;
import org.springframework.cloud.sleuth.instrument.web.client.AbstractHttpHeadersFilter;
import org.springframework.cloud.sleuth.propagation.Propagator;
import org.springframework.http.HttpHeaders;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;

public class TraceRequestHttpHeadersFilter
extends AbstractHttpHeadersFilter {
    private static final Log log = LogFactory.getLog(TraceRequestHttpHeadersFilter.class);
    static final String TRACE_REQUEST_ATTR = TraceContext.class.getName();
    static final String TRACE_REQUEST_ATTR_FROM_TRACE_WEB_FILTER = Span.class.getName();

    public TraceRequestHttpHeadersFilter(Tracer tracer, HttpClientHandler handler, Propagator propagator) {
        super(tracer, handler, propagator);
    }

    public HttpHeaders filter(HttpHeaders input, ServerWebExchange exchange) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will instrument the HTTP request headers [" + exchange.getRequest().getHeaders() + "]"));
        }
        AbstractHttpHeadersFilter.ServerHttpClientRequest request = new AbstractHttpHeadersFilter.ServerHttpClientRequest(exchange.getRequest(), input);
        Span currentSpan = this.currentSpan(exchange, request);
        Span span = this.injectedSpan(request, currentSpan);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Client span  " + span + " created for the request. New headers are " + request.filteredHeaders.toSingleValueMap()));
        }
        exchange.getAttributes().put(SPAN_ATTRIBUTE, span);
        HttpHeaders headersWithInput = new HttpHeaders();
        headersWithInput.addAll((MultiValueMap)input);
        this.addHeadersWithInput(request.filteredHeaders, headersWithInput);
        if (headersWithInput.containsKey((Object)"b3") || headersWithInput.containsKey((Object)"B3")) {
            headersWithInput.keySet().remove("b3");
            headersWithInput.keySet().remove("B3");
        }
        return headersWithInput;
    }

    private Span currentSpan(ServerWebExchange exchange, AbstractHttpHeadersFilter.ServerHttpClientRequest request) {
        Span currentSpan = this.currentSpan(exchange);
        if (currentSpan != null) {
            return currentSpan;
        }
        return this.propagator.extract((Object)request, HttpRequest::header).start();
    }

    private Span currentSpan(ServerWebExchange exchange) {
        Object attribute = exchange.getAttribute(TRACE_REQUEST_ATTR);
        Object span = exchange.getAttribute(TRACE_REQUEST_ATTR_FROM_TRACE_WEB_FILTER);
        if (attribute instanceof Span) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found trace request attribute in the server web exchange [" + attribute + "]"));
            }
            return (Span)attribute;
        }
        if (span instanceof Span) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found trace request attribute in the server web exchange set by TraceWebFilter [" + span + "]"));
            }
            return (Span)span;
        }
        return this.tracer.currentSpan();
    }

    private Span injectedSpan(AbstractHttpHeadersFilter.ServerHttpClientRequest request, Span currentSpan) {
        if (currentSpan == null) {
            return this.handler.handleSend((HttpClientRequest)request);
        }
        return this.handler.handleSend((HttpClientRequest)request, currentSpan.context());
    }

    private void addHeadersWithInput(HttpHeaders filteredHeaders, HttpHeaders headersWithInput) {
        for (Map.Entry entry : filteredHeaders.entrySet()) {
            String key = (String)entry.getKey();
            List value = (List)entry.getValue();
            headersWithInput.put(key, value);
        }
    }

    public boolean supports(HttpHeadersFilter.Type type) {
        return type.equals((Object)HttpHeadersFilter.Type.REQUEST);
    }
}

