/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.tx;

import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanAndScope;
import org.springframework.cloud.sleuth.ThreadLocalSpan;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.docs.EventValue;
import org.springframework.cloud.sleuth.instrument.tx.SleuthTxSpan;
import org.springframework.cloud.sleuth.instrument.tx.TracePlatformTransactionManagerTags;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;

public class TracePlatformTransactionManager
implements PlatformTransactionManager {
    private static final Log log = LogFactory.getLog(TracePlatformTransactionManager.class);
    protected final PlatformTransactionManager delegate;
    private final BeanFactory beanFactory;
    private Tracer tracer;
    volatile ThreadLocalSpan threadLocalSpan;

    public TracePlatformTransactionManager(PlatformTransactionManager delegate, BeanFactory beanFactory) {
        this.delegate = delegate;
        this.beanFactory = beanFactory;
    }

    @PostConstruct
    void initialize() {
        if (this.threadLocalSpan == null) {
            this.threadLocalSpan = new ThreadLocalSpan(this.tracer());
        }
    }

    public TransactionStatus getTransaction(TransactionDefinition definition) throws TransactionException {
        this.initialize();
        SpanAndScope spanAndScope = this.threadLocalSpan.get();
        Span currentSpan = spanAndScope != null ? spanAndScope.getSpan() : this.tracer().currentSpan();
        Span span = this.fallbackSpan();
        try {
            TransactionDefinition def = definition != null ? definition : TransactionDefinition.withDefaults();
            TransactionStatus status = this.delegate.getTransaction(definition);
            this.taggedSpan(currentSpan, span, def, status);
            return status;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Exception occurred while trying to get a transaction, will mark the span with error and report it");
            }
            span.error((Throwable)e);
            span.end();
            throw e;
        }
    }

    Span fallbackSpan() {
        return SleuthTxSpan.TX_SPAN.wrap(this.tracer().nextSpan()).name(SleuthTxSpan.TX_SPAN.getName()).start();
    }

    private Span taggedSpan(Span currentSpan, Span span, TransactionDefinition def, TransactionStatus status) {
        if (status.isNewTransaction() || currentSpan == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Creating new span cause a new transaction is started");
            }
            TracePlatformTransactionManagerTags.tag(span, def, this.delegate.getClass());
        } else {
            span = currentSpan;
        }
        this.threadLocalSpan.set(span);
        return span;
    }

    public void commit(TransactionStatus status) throws TransactionException {
        SpanAndScope spanAndScope = this.threadLocalSpan.get();
        if (spanAndScope == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No span and scope found - this shouldn't happen, sth is wrong");
            }
            this.delegate.commit(status);
            return;
        }
        Exception ex = null;
        Span span = spanAndScope.getSpan();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Wrapping commit");
            }
            this.delegate.commit(status);
        }
        catch (Exception e) {
            ex = e;
            span.error((Throwable)e);
            throw e;
        }
        finally {
            SleuthTxSpan.TX_SPAN.wrap(span).event((EventValue)SleuthTxSpan.Events.COMMIT);
            spanAndScope.close();
            if (ex == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"No exception was found - will clear thread local span");
                }
                this.threadLocalSpan.remove();
            }
        }
    }

    public void rollback(TransactionStatus status) throws TransactionException {
        SpanAndScope spanAndScope = this.threadLocalSpan.get();
        if (spanAndScope == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No span and scope found - this shouldn't happen, sth is wrong");
            }
            this.delegate.rollback(status);
            return;
        }
        Span span = spanAndScope.getSpan();
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Wrapping rollback");
            }
            this.delegate.rollback(status);
        }
        catch (Exception e) {
            span.error((Throwable)e);
            throw e;
        }
        finally {
            SleuthTxSpan.TX_SPAN.wrap(span).event((EventValue)SleuthTxSpan.Events.ROLLBACK);
            spanAndScope.close();
            this.threadLocalSpan.remove();
        }
    }

    private Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }
}

