/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.async;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.TraceCallable;
import org.springframework.cloud.sleuth.instrument.async.TraceRunnable;
import org.springframework.cloud.sleuth.internal.ContextUtil;

public class TraceableExecutorService
implements ExecutorService {
    static final Map<ExecutorService, TraceableExecutorService> CACHE = new ConcurrentHashMap<ExecutorService, TraceableExecutorService>();
    final ExecutorService delegate;
    final String spanName;
    Tracer tracer;
    SpanNamer spanNamer;
    BeanFactory beanFactory;

    public TraceableExecutorService(BeanFactory beanFactory, ExecutorService delegate) {
        this(beanFactory, delegate, null);
    }

    public TraceableExecutorService(BeanFactory beanFactory, ExecutorService delegate, String spanName) {
        this.delegate = delegate;
        this.beanFactory = beanFactory;
        this.spanName = spanName;
    }

    public static TraceableExecutorService wrap(BeanFactory beanFactory, ExecutorService delegate, String beanName) {
        return CACHE.computeIfAbsent(delegate, e -> new TraceableExecutorService(beanFactory, delegate, beanName));
    }

    public static TraceableExecutorService wrap(BeanFactory beanFactory, ExecutorService delegate) {
        return CACHE.computeIfAbsent(delegate, e -> new TraceableExecutorService(beanFactory, delegate, null));
    }

    @Override
    public void execute(Runnable command) {
        this.delegate.execute(ContextUtil.isContextUnusable(this.beanFactory) ? command : new TraceRunnable(this.tracer(), this.spanNamer(), command, this.spanName));
    }

    @Override
    public void shutdown() {
        try {
            this.delegate.shutdown();
        }
        finally {
            CACHE.remove(this.delegate);
        }
    }

    @Override
    public List<Runnable> shutdownNow() {
        try {
            List<Runnable> list = this.delegate.shutdownNow();
            return list;
        }
        finally {
            CACHE.remove(this.delegate);
        }
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.awaitTermination(timeout, unit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return this.delegate.submit(ContextUtil.isContextUnusable(this.beanFactory) ? task : new TraceCallable(this.tracer(), this.spanNamer(), task, this.spanName));
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return this.delegate.submit(ContextUtil.isContextUnusable(this.beanFactory) ? task : new TraceRunnable(this.tracer(), this.spanNamer(), task, this.spanName), result);
    }

    @Override
    public Future<?> submit(Runnable task) {
        return this.delegate.submit(ContextUtil.isContextUnusable(this.beanFactory) ? task : new TraceRunnable(this.tracer(), this.spanNamer(), task, this.spanName));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.delegate.invokeAll(ContextUtil.isContextUnusable(this.beanFactory) ? tasks : this.wrapCallableCollection(tasks));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.invokeAll(ContextUtil.isContextUnusable(this.beanFactory) ? tasks : this.wrapCallableCollection(tasks), timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(ContextUtil.isContextUnusable(this.beanFactory) ? tasks : this.wrapCallableCollection(tasks));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(ContextUtil.isContextUnusable(this.beanFactory) ? tasks : this.wrapCallableCollection(tasks), timeout, unit);
    }

    private <T> Collection<? extends Callable<T>> wrapCallableCollection(Collection<? extends Callable<T>> tasks) {
        ArrayList<TraceCallable<T>> ts = new ArrayList<TraceCallable<T>>();
        for (Callable<T> task : tasks) {
            if (task instanceof TraceCallable) continue;
            ts.add(new TraceCallable<T>(this.tracer(), this.spanNamer(), task, this.spanName));
        }
        return ts;
    }

    Tracer tracer() {
        if (this.tracer == null && this.beanFactory != null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }

    SpanNamer spanNamer() {
        if (this.spanNamer == null && this.beanFactory != null) {
            this.spanNamer = (SpanNamer)this.beanFactory.getBean(SpanNamer.class);
        }
        return this.spanNamer;
    }
}

