/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.kafka;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.docs.AssertingSpanBuilder;
import org.springframework.cloud.sleuth.docs.DocumentedSpan;
import org.springframework.cloud.sleuth.docs.TagKey;
import org.springframework.cloud.sleuth.instrument.kafka.SleuthKafkaSpan;
import org.springframework.cloud.sleuth.propagation.Propagator;

final class KafkaTracingUtils {
    private static final Log log = LogFactory.getLog(KafkaTracingUtils.class);

    private KafkaTracingUtils() {
    }

    static <K, V> void buildAndFinishSpan(SleuthKafkaSpan sleuthKafkaSpan, ConsumerRecord<K, V> consumerRecord, Propagator propagator, Propagator.Getter<ConsumerRecord<?, ?>> extractor) {
        Span span = KafkaTracingUtils.buildSpan(sleuthKafkaSpan, consumerRecord, propagator, extractor);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Extracted span from event headers " + span));
        }
        span.end();
    }

    static <K, V> Span buildSpan(SleuthKafkaSpan sleuthKafkaSpan, ConsumerRecord<K, V> consumerRecord, Propagator propagator, Propagator.Getter<ConsumerRecord<?, ?>> extractor) {
        AssertingSpanBuilder spanBuilder = AssertingSpanBuilder.of((DocumentedSpan)sleuthKafkaSpan, (Span.Builder)propagator.extract(consumerRecord, extractor).kind(Span.Kind.CONSUMER)).name(sleuthKafkaSpan.getName()).tag((TagKey)SleuthKafkaSpan.ConsumerTags.TOPIC, consumerRecord.topic()).tag((TagKey)SleuthKafkaSpan.ConsumerTags.OFFSET, Long.toString(consumerRecord.offset())).tag((TagKey)SleuthKafkaSpan.ConsumerTags.PARTITION, Integer.toString(consumerRecord.partition()));
        return spanBuilder.start();
    }
}

