/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.brave.instrument.messaging;

import brave.kafka.streams.KafkaStreamsTracing;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.kafka.config.StreamsBuilderFactoryBean;

class KafkaStreamsBuilderFactoryBeanPostProcessor
implements BeanPostProcessor {
    private static final Log log = LogFactory.getLog(KafkaStreamsBuilderFactoryBeanPostProcessor.class);
    private final ObjectProvider<KafkaStreamsTracing> objectProvider;

    KafkaStreamsBuilderFactoryBeanPostProcessor(ObjectProvider<KafkaStreamsTracing> objectProvider) {
        this.objectProvider = objectProvider;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof StreamsBuilderFactoryBean) {
            KafkaStreamsTracing kafkaStreamsTracing = (KafkaStreamsTracing)this.objectProvider.getIfAvailable();
            ((StreamsBuilderFactoryBean)bean).setClientSupplier(kafkaStreamsTracing.kafkaClientSupplier());
            if (log.isDebugEnabled()) {
                log.debug((Object)"StreamsBuilderFactoryBean bean is auto-configured to enable tracing.");
            }
        }
        return bean;
    }
}

