/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gcp.autoconfigure.sql;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.cloud.sql.CredentialFactory;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.Collections;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.gcp.core.GcpScope;

public class SqlCredentialFactory
implements CredentialFactory {
    public static final String CREDENTIAL_LOCATION_PROPERTY_NAME = "GOOGLE_CLOUD_SQL_CREDS_LOCATION";
    public static final String CREDENTIAL_ENCODED_KEY_PROPERTY_NAME = "GOOGLE_CLOUD_SQL_ENCODED_KEY";
    private static final Log LOGGER = LogFactory.getLog(SqlCredentialFactory.class);

    public Credential create() {
        String credentialResourceLocation = System.getProperty(CREDENTIAL_LOCATION_PROPERTY_NAME);
        String encodedCredential = System.getProperty(CREDENTIAL_ENCODED_KEY_PROPERTY_NAME);
        if (credentialResourceLocation == null && encodedCredential == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"GOOGLE_CLOUD_SQL_CREDS_LOCATION and GOOGLE_CLOUD_SQL_ENCODED_KEY properties do not exist. Socket factory will use application default credentials.");
            }
            return null;
        }
        try {
            InputStream credentialsInputStream = encodedCredential != null ? new ByteArrayInputStream(Base64.getDecoder().decode(encodedCredential.getBytes())) : new FileInputStream(credentialResourceLocation);
            return GoogleCredential.fromStream((InputStream)credentialsInputStream).createScoped(Collections.singleton(GcpScope.SQLADMIN.getUrl()));
        }
        catch (IOException ioe) {
            LOGGER.warn((Object)"There was an error loading Cloud SQL credential.", (Throwable)ioe);
            return null;
        }
    }
}

