/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.info;

import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.boot.info.InfoProperties;
import org.springframework.context.annotation.ImportRuntimeHints;

@ImportRuntimeHints(value={GitPropertiesRuntimeHints.class})
public class GitProperties
extends InfoProperties {
    static final Set<Coercer> coercers = Set.of(Coercer.milliseconds(), Coercer.dateTimePattern("yyyy-MM-dd'T'HH:mm:ssXXX"), Coercer.dateTimePattern("yyyy-MM-dd'T'HH:mm:ssZ"));

    public GitProperties(Properties entries) {
        super(GitProperties.processEntries(entries));
    }

    public @Nullable String getBranch() {
        return this.get("branch");
    }

    public @Nullable String getCommitId() {
        return this.get("commit.id");
    }

    public @Nullable String getShortCommitId() {
        String shortId = this.get("commit.id.abbrev");
        if (shortId != null) {
            return shortId;
        }
        String id = this.getCommitId();
        if (id == null) {
            return null;
        }
        return id.length() > 7 ? id.substring(0, 7) : id;
    }

    public @Nullable Instant getCommitTime() {
        return this.getInstant("commit.time");
    }

    private static Properties processEntries(Properties properties) {
        GitProperties.coercePropertyToEpoch(properties, "commit.time");
        GitProperties.coercePropertyToEpoch(properties, "build.time");
        Object commitId = properties.get("commit.id");
        if (commitId != null) {
            properties.put("commit.id.full", commitId);
        }
        return properties;
    }

    private static void coercePropertyToEpoch(Properties properties, String key) {
        String value = properties.getProperty(key);
        if (value != null) {
            properties.setProperty(key, coercers.stream().map(coercer -> coercer.apply(value)).filter(Objects::nonNull).findFirst().orElse(value));
        }
    }

    private record Coercer(Function<String, @Nullable Long> action, Predicate<RuntimeException> ignoredExceptions) {
        @Nullable String apply(String value) {
            try {
                Long result = this.action.apply(value);
                return result != null ? String.valueOf(result) : null;
            }
            catch (RuntimeException ex) {
                if (this.ignoredExceptions.test(ex)) {
                    return null;
                }
                throw ex;
            }
        }

        static Coercer milliseconds() {
            return new Coercer(value -> Long.parseLong(value) * 1000L, NumberFormatException.class::isInstance);
        }

        static Coercer dateTimePattern(String pattern) {
            return new Coercer(value -> DateTimeFormatter.ofPattern(pattern).parse((CharSequence)value, Instant::from).toEpochMilli(), DateTimeParseException.class::isInstance);
        }
    }

    static class GitPropertiesRuntimeHints
    implements RuntimeHintsRegistrar {
        GitPropertiesRuntimeHints() {
        }

        public void registerHints(RuntimeHints hints, @Nullable ClassLoader classLoader) {
            hints.resources().registerPattern("git.properties");
        }
    }
}

