/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.health.autoconfigure.contributor;

import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.health.autoconfigure.contributor.ConditionalOnEnabledHealthIndicator;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

class OnEnabledHealthIndicatorCondition
extends SpringBootCondition {
    private static final String DEFAULTS_PROPERTY_NAME = "management.health.defaults.enabled";

    OnEnabledHealthIndicatorCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        MergedAnnotation annotation = metadata.getAnnotations().get(ConditionalOnEnabledHealthIndicator.class);
        String name = annotation.getString("value");
        Environment environment = context.getEnvironment();
        ConditionMessage.Builder message = ConditionMessage.forCondition(ConditionalOnEnabledHealthIndicator.class, (Object[])new Object[0]);
        String propertyName = "management.health." + name + ".enabled";
        if (environment.containsProperty(propertyName)) {
            boolean match = (Boolean)environment.getProperty(propertyName, Boolean.class, (Object)true);
            return new ConditionOutcome(match, message.because(propertyName + " is " + match));
        }
        boolean match = Boolean.parseBoolean(context.getEnvironment().getProperty(DEFAULTS_PROPERTY_NAME, "true"));
        return new ConditionOutcome(match, message.because("management.health.defaults.enabled is considered " + match));
    }
}

