/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.runner.api;

import java.nio.charset.Charset;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.runner.api.Dirs;
import org.sonar.runner.api.IssueListener;
import org.sonar.runner.api.IssueListenerAdapter;
import org.sonar.runner.api.LogOutput;
import org.sonar.runner.api.LoggerAdapter;
import org.sonar.runner.api.RunnerVersion;
import org.sonar.runner.api.Utils;
import org.sonar.runner.batch.IsolatedLauncher;
import org.sonar.runner.batch.LogOutput;
import org.sonar.runner.cache.Logger;
import org.sonar.runner.impl.ClassloadRules;
import org.sonar.runner.impl.IsolatedLauncherFactory;
import org.sonar.runner.impl.VersionUtils;

public class EmbeddedRunner {
    private final IsolatedLauncherFactory launcherFactory;
    private IsolatedLauncher launcher;
    private final LogOutput logOutput;
    private final Properties globalProperties = new Properties();
    private final List<Object> extensions = new ArrayList<Object>();
    private final Logger logger;
    private final Set<String> classloaderMask = new HashSet<String>();
    private final Set<String> classloaderUnmask = new HashSet<String>();

    EmbeddedRunner(IsolatedLauncherFactory bl, Logger logger, LogOutput logOutput) {
        this.logger = logger;
        this.launcherFactory = bl;
        this.logOutput = logOutput;
        this.classloaderUnmask.add("org.sonar.runner.batch.");
    }

    public static EmbeddedRunner create(LogOutput logOutput) {
        LoggerAdapter logger = new LoggerAdapter(logOutput);
        return new EmbeddedRunner(new IsolatedLauncherFactory(logger), logger, logOutput);
    }

    public Properties globalProperties() {
        Properties clone = new Properties();
        clone.putAll((Map<?, ?>)this.globalProperties);
        return clone;
    }

    public EmbeddedRunner unmask(String fqcnPrefix) {
        this.checkLauncherDoesntExist();
        this.classloaderUnmask.add(fqcnPrefix);
        return this;
    }

    public EmbeddedRunner mask(String fqcnPrefix) {
        this.checkLauncherDoesntExist();
        this.classloaderMask.add(fqcnPrefix);
        return this;
    }

    public EmbeddedRunner addGlobalProperties(Properties p) {
        this.globalProperties.putAll((Map<?, ?>)p);
        return this;
    }

    public EmbeddedRunner setGlobalProperty(String key, String value) {
        this.globalProperties.setProperty(key, value);
        return this;
    }

    public String globalProperty(String key, @Nullable String defaultValue) {
        return this.globalProperties.getProperty(key, defaultValue);
    }

    public EmbeddedRunner setApp(String app, String version) {
        this.setGlobalProperty("sonarRunner.app", app);
        this.setGlobalProperty("sonarRunner.appVersion", version);
        return this;
    }

    public String app() {
        return this.globalProperty("sonarRunner.app", null);
    }

    public EmbeddedRunner addExtensions(Object ... objs) {
        this.checkLauncherExists();
        if (VersionUtils.isAtLeast52(this.launcher.getVersion())) {
            throw new IllegalStateException("not supported in current SonarQube version: " + this.launcher.getVersion());
        }
        this.extensions.addAll(Arrays.asList(objs));
        return this;
    }

    public String appVersion() {
        return this.globalProperty("sonarRunner.appVersion", null);
    }

    public void runAnalysis(Properties analysisProperties) {
        this.runAnalysis(analysisProperties, null);
    }

    public void runAnalysis(Properties analysisProperties, @Nullable IssueListener issueListener) {
        this.checkLauncherExists();
        Properties copy = new Properties();
        copy.putAll((Map<?, ?>)analysisProperties);
        this.initAnalysisProperties(copy);
        this.doExecute(copy, issueListener);
    }

    public void syncProject(String projectKey) {
        this.checkLauncherExists();
        if (!VersionUtils.isAtLeast52(this.launcher.getVersion())) {
            throw new IllegalStateException("not supported in current SonarQube version: " + this.launcher.getVersion());
        }
        this.launcher.syncProject(projectKey);
    }

    public void start() {
        this.start(false);
    }

    public void start(boolean preferCache) {
        this.initGlobalDefaultValues();
        this.doStart(preferCache);
    }

    public void stop() {
        this.checkLauncherExists();
        this.doStop();
    }

    public String serverVersion() {
        this.checkLauncherExists();
        return this.launcher.getVersion();
    }

    @Deprecated
    public final void execute() {
        this.start();
        this.runAnalysis(new Properties());
        this.stop();
    }

    private void initGlobalDefaultValues() {
        this.setGlobalDefaultValue("sonar.host.url", "http://localhost:9000");
        this.setGlobalDefaultValue("sonarRunner.app", "SonarQubeRunner");
        this.setGlobalDefaultValue("sonarRunner.appVersion", RunnerVersion.version());
    }

    private void initAnalysisProperties(Properties p) {
        this.initSourceEncoding(p);
        new Dirs(this.logger).init(p);
    }

    void initSourceEncoding(Properties p) {
        boolean onProject = Utils.taskRequiresProject(p);
        if (onProject) {
            String sourceEncoding = p.getProperty("sonar.sourceEncoding", "");
            boolean platformDependent = false;
            if ("".equals(sourceEncoding)) {
                sourceEncoding = Charset.defaultCharset().name();
                platformDependent = true;
                p.setProperty("sonar.sourceEncoding", sourceEncoding);
            }
            this.logger.info("Default locale: \"" + Locale.getDefault() + "\", source code encoding: \"" + sourceEncoding + "\"" + (platformDependent ? " (analysis is platform dependent)" : ""));
        }
    }

    private void setGlobalDefaultValue(String key, String value) {
        if (!this.globalProperties.containsKey(key)) {
            this.setGlobalProperty(key, value);
        }
    }

    protected void doStart(boolean preferCache) {
        this.checkLauncherDoesntExist();
        ClassloadRules rules = new ClassloadRules(this.classloaderMask, this.classloaderUnmask);
        this.launcher = this.launcherFactory.createLauncher(this.globalProperties(), rules, preferCache);
        if (VersionUtils.isAtLeast52(this.launcher.getVersion())) {
            this.launcher.start(this.globalProperties(), new org.sonar.runner.batch.LogOutput(){

                @Override
                public void log(String formattedMessage, LogOutput.Level level) {
                    EmbeddedRunner.this.logOutput.log(formattedMessage, LogOutput.Level.valueOf(level.name()));
                }
            }, preferCache);
        }
    }

    protected void doStop() {
        if (VersionUtils.isAtLeast52(this.launcher.getVersion())) {
            this.launcher.stop();
            this.launcher = null;
        }
    }

    protected void doExecute(Properties analysisProperties, @Nullable IssueListener issueListener) {
        if (VersionUtils.isAtLeast52(this.launcher.getVersion())) {
            if (issueListener != null) {
                this.launcher.execute(analysisProperties, new IssueListenerAdapter(issueListener));
            } else {
                this.launcher.execute(analysisProperties);
            }
        } else {
            if (issueListener != null) {
                throw new InvalidParameterException("Issue listeners not supported in current version: " + this.launcher.getVersion());
            }
            Properties prop = new Properties();
            prop.putAll((Map<?, ?>)this.globalProperties());
            prop.putAll((Map<?, ?>)analysisProperties);
            this.launcher.executeOldVersion(prop, this.extensions);
        }
    }

    private void checkLauncherExists() {
        if (this.launcher == null) {
            throw new IllegalStateException("not started");
        }
    }

    private void checkLauncherDoesntExist() {
        if (this.launcher != null) {
            throw new IllegalStateException("already started");
        }
    }
}

