/*
 * Decompiled with CFR 0.152.
 */
package org.simpleflatmapper.map.impl;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.simpleflatmapper.map.MapperConfig;
import org.simpleflatmapper.reflect.ClassMetaWithDiscriminatorId;
import org.simpleflatmapper.reflect.Getter;
import org.simpleflatmapper.reflect.InstantiatorDefinition;
import org.simpleflatmapper.reflect.ReflectionService;
import org.simpleflatmapper.reflect.Setter;
import org.simpleflatmapper.reflect.meta.PropertyFinder;
import org.simpleflatmapper.reflect.meta.PropertyMatchingScore;
import org.simpleflatmapper.reflect.meta.PropertyMeta;
import org.simpleflatmapper.reflect.meta.PropertyNameMatcher;
import org.simpleflatmapper.reflect.meta.ShortCircuiter;
import org.simpleflatmapper.reflect.meta.SubPropertyMeta;
import org.simpleflatmapper.util.Consumer;
import org.simpleflatmapper.util.TypeHelper;

public class DiscriminatorPropertyFinder<T>
extends PropertyFinder<T> {
    private final Map<PropertyMeta<?, ?>, PropertyFinder<?>> subPropertyFinders = new HashMap();
    private final Type ownerType;
    private final List<PropertyFinderWithDiscriminatorId<T>> implementationPropertyFinders;
    private final ReflectionService reflectionService;

    protected DiscriminatorPropertyFinder(Type ownerType, List<ClassMetaWithDiscriminatorId<?>> implementations, ReflectionService reflectionService) {
        this.ownerType = ownerType;
        this.reflectionService = reflectionService;
        this.implementationPropertyFinders = new ArrayList<PropertyFinderWithDiscriminatorId<T>>();
        for (ClassMetaWithDiscriminatorId<?> cm : implementations) {
            this.implementationPropertyFinders.add(new PropertyFinderWithDiscriminatorId(cm.classMeta.newPropertyFinder(), cm.discriminatorId));
        }
    }

    public void lookForProperties(PropertyNameMatcher propertyNameMatcher, Object[] properties, PropertyFinder.FoundProperty<T> matchingProperties, PropertyMatchingScore score, boolean allowSelfReference, PropertyFinder.PropertyFinderTransformer propertyFinderTransformer, PropertyFinder.TypeAffinityScorer typeAffinityScorer, PropertyFinder.PropertyFilter propertyFilter, ShortCircuiter shortCircuiter) {
        final ArrayList<DiscriminatorMatch> matches = new ArrayList<DiscriminatorMatch>();
        PropertyMatchingScore bestScore = null;
        for (PropertyFinderWithDiscriminatorId<T> pfwd : this.implementationPropertyFinders) {
            final ArrayList matchedProperties = new ArrayList();
            pfwd.propertyFinder.lookForProperties(propertyNameMatcher, properties, new PropertyFinder.FoundProperty(){

                public void found(PropertyMeta propertyMeta, Runnable selectionCallback, PropertyMatchingScore score, PropertyFinder.TypeAffinityScorer typeAffinityScorer) {
                    matchedProperties.add(new PropertyFinder.MatchedProperty(propertyMeta, selectionCallback, score, typeAffinityScorer.score(propertyMeta.getPropertyType())));
                }
            }, score, false, propertyFinderTransformer, typeAffinityScorer, propertyFilter, shortCircuiter);
            if (matchedProperties.isEmpty()) continue;
            Collections.sort(matchedProperties);
            PropertyFinder.MatchedProperty selectedMatchedProperty = (PropertyFinder.MatchedProperty)matchedProperties.get(0);
            matches.add(new DiscriminatorMatch(pfwd.propertyFinder.getOwnerType(), selectedMatchedProperty, pfwd.discriminatorId));
            if (bestScore != null && bestScore.compareTo(selectedMatchedProperty.getScore()) <= 0) continue;
            bestScore = selectedMatchedProperty.getScore();
        }
        if (!matches.isEmpty()) {
            DiscriminatorPropertyMeta discriminatorPropertyMeta = new DiscriminatorPropertyMeta("unknown", this.ownerType, this.reflectionService, matches);
            Runnable selectionCallback = new Runnable(){

                @Override
                public void run() {
                    for (DiscriminatorMatch dm : matches) {
                        dm.matchedProperty.select();
                    }
                }
            };
            matchingProperties.found(discriminatorPropertyMeta, selectionCallback, bestScore, typeAffinityScorer);
        }
    }

    public PropertyFinder<? extends T> getImplementationPropertyFinder(Type implementationType, Object discriminatorId) {
        for (PropertyFinderWithDiscriminatorId<T> pf : this.implementationPropertyFinders) {
            if (!TypeHelper.areEquals((Type)pf.propertyFinder.getOwnerType(), (Type)implementationType) || !MapperConfig.sameDiscriminatorId(discriminatorId, pf.discriminatorId)) continue;
            return pf.propertyFinder;
        }
        throw new IllegalArgumentException("Could not find implementation propertyfinder for " + String.valueOf(implementationType));
    }

    public List<InstantiatorDefinition> getEligibleInstantiatorDefinitions() {
        return null;
    }

    public PropertyFinder<?> getSubPropertyFinder(PropertyMeta<?, ?> owner) {
        return this.subPropertyFinders.get(owner);
    }

    public PropertyFinder<?> getOrCreateSubPropertyFinder(SubPropertyMeta<?, ?, ?> subPropertyMeta) {
        PropertyFinder propertyFinder = this.subPropertyFinders.get(subPropertyMeta.getOwnerProperty());
        if (propertyFinder == null) {
            propertyFinder = subPropertyMeta.getSubProperty().getPropertyClassMeta().newPropertyFinder();
            this.subPropertyFinders.put(subPropertyMeta.getOwnerProperty(), propertyFinder);
        }
        return propertyFinder;
    }

    public void manualMatch(PropertyMeta<?, ?> prop) {
        if (!(prop instanceof DiscriminatorPropertyMeta)) {
            super.manualMatch(prop);
        }
        DiscriminatorPropertyMeta dpm = (DiscriminatorPropertyMeta)prop;
        dpm.forEachProperty(new Consumer<DiscriminatorMatch>(){

            public void accept(DiscriminatorMatch dm) {
                Type type = dm.type;
                PropertyMeta propertyMeta = dm.matchedProperty.getPropertyMeta();
                PropertyFinder pf = DiscriminatorPropertyFinder.this.getImplementationPropertyFinder(type, dm.discriminatorId);
                pf.manualMatch(propertyMeta);
            }
        });
    }

    public Type getOwnerType() {
        return this.ownerType;
    }

    private static class PropertyFinderWithDiscriminatorId<T> {
        private final PropertyFinder<? extends T> propertyFinder;
        private final Object discriminatorId;

        private PropertyFinderWithDiscriminatorId(PropertyFinder<? extends T> propertyFinder, Object discriminatorId) {
            this.propertyFinder = propertyFinder;
            this.discriminatorId = discriminatorId;
        }
    }

    public static class DiscriminatorMatch {
        public final Type type;
        public final PropertyFinder.MatchedProperty<?, ?> matchedProperty;
        public final Object discriminatorId;

        private DiscriminatorMatch(Type type, PropertyFinder.MatchedProperty<?, ?> matchedProperty, Object discriminatorId) {
            this.type = type;
            this.matchedProperty = matchedProperty;
            this.discriminatorId = discriminatorId;
        }
    }

    public static class DiscriminatorPropertyMeta<O, P>
    extends PropertyMeta<O, P> {
        private final List<DiscriminatorMatch> matches;

        public DiscriminatorPropertyMeta(String name, Type ownerType, ReflectionService reflectService, List<DiscriminatorMatch> matches) {
            super(name, ownerType, reflectService);
            this.matches = matches;
        }

        public <C extends Consumer<DiscriminatorMatch>> C forEachProperty(C consumer) {
            for (DiscriminatorMatch dm : this.matches) {
                consumer.accept((Object)dm);
            }
            return consumer;
        }

        public Setter<? super O, ? super P> getSetter() {
            throw new UnsupportedOperationException();
        }

        public Getter<? super O, ? extends P> getGetter() {
            throw new UnsupportedOperationException();
        }

        public boolean isConstructorProperty() {
            throw new UnsupportedOperationException();
        }

        public boolean isSubProperty() {
            throw new UnsupportedOperationException();
        }

        public Type getPropertyType() {
            Type t = null;
            for (int i = 0; i < this.matches.size(); ++i) {
                Type te = this.matches.get((int)0).matchedProperty.getPropertyMeta().getPropertyType();
                if (t == null) {
                    t = te;
                    continue;
                }
                if (t.equals(te)) continue;
                throw new UnsupportedOperationException();
            }
            return t;
        }

        public String getPath() {
            return this.matches.get((int)0).matchedProperty.getPropertyMeta().getPath();
        }

        public PropertyMeta<O, P> withReflectionService(ReflectionService reflectionService) {
            throw new UnsupportedOperationException();
        }

        public int typeAffinityScore(PropertyFinder.TypeAffinityScorer typeAffinityScorer) {
            int bestScore = -1;
            for (DiscriminatorMatch dm : this.matches) {
                bestScore = Math.max(bestScore, dm.matchedProperty.getPropertyMeta().typeAffinityScore(typeAffinityScorer));
            }
            return bestScore;
        }

        public PropertyMeta<O, P> toNonMapped() {
            throw new UnsupportedOperationException();
        }
    }
}

