/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.grid.sessionmap;

import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.grid.data.Session;
import org.openqa.selenium.grid.sessionmap.SessionMap;
import org.openqa.selenium.internal.Require;
import org.openqa.selenium.json.Json;
import org.openqa.selenium.remote.RemoteTags;
import org.openqa.selenium.remote.http.Contents;
import org.openqa.selenium.remote.http.HttpHandler;
import org.openqa.selenium.remote.http.HttpMessage;
import org.openqa.selenium.remote.http.HttpRequest;
import org.openqa.selenium.remote.http.HttpResponse;
import org.openqa.selenium.remote.tracing.HttpTracing;
import org.openqa.selenium.remote.tracing.Span;
import org.openqa.selenium.remote.tracing.Tags;
import org.openqa.selenium.remote.tracing.Tracer;

class AddToSessionMap
implements HttpHandler {
    private final Tracer tracer;
    private final Json json;
    private final SessionMap sessions;

    AddToSessionMap(Tracer tracer, Json json, SessionMap sessions) {
        this.tracer = (Tracer)Require.nonNull((String)"Tracer", (Object)tracer);
        this.json = (Json)Require.nonNull((String)"Json converter", (Object)json);
        this.sessions = (SessionMap)Require.nonNull((String)"Session map", (Object)sessions);
    }

    public HttpResponse execute(HttpRequest req) {
        try (Span span = HttpTracing.newSpanAsChildOf((Tracer)this.tracer, (HttpRequest)req, (String)"sessions.add_session");){
            Tags.HTTP_REQUEST.accept(span, req);
            Session session = (Session)this.json.toType(Contents.string((HttpMessage)req), Session.class);
            Objects.requireNonNull(session, "Session to add must be set");
            RemoteTags.SESSION_ID.accept(span, session.getId());
            RemoteTags.CAPABILITIES.accept(span, session.getCapabilities());
            span.setAttribute("session.uri", session.getUri().toString());
            this.sessions.add(session);
            HttpResponse httpResponse = (HttpResponse)new HttpResponse().setContent(Contents.asJson(Map.of("value", true)));
            return httpResponse;
        }
    }
}

