/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v85.network.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.v85.network.model.CookiePriority;
import org.openqa.selenium.devtools.v85.network.model.CookieSameSite;
import org.openqa.selenium.devtools.v85.network.model.TimeSinceEpoch;
import org.openqa.selenium.json.JsonInput;

public class CookieParam {
    private final String name;
    private final String value;
    private final Optional<String> url;
    private final Optional<String> domain;
    private final Optional<String> path;
    private final Optional<Boolean> secure;
    private final Optional<Boolean> httpOnly;
    private final Optional<CookieSameSite> sameSite;
    private final Optional<TimeSinceEpoch> expires;
    private final Optional<CookiePriority> priority;

    public CookieParam(String name, String value, Optional<String> url, Optional<String> domain, Optional<String> path, Optional<Boolean> secure, Optional<Boolean> httpOnly, Optional<CookieSameSite> sameSite, Optional<TimeSinceEpoch> expires, Optional<CookiePriority> priority) {
        this.name = Objects.requireNonNull(name, "name is required");
        this.value = Objects.requireNonNull(value, "value is required");
        this.url = url;
        this.domain = domain;
        this.path = path;
        this.secure = secure;
        this.httpOnly = httpOnly;
        this.sameSite = sameSite;
        this.expires = expires;
        this.priority = priority;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Optional<String> getUrl() {
        return this.url;
    }

    public Optional<String> getDomain() {
        return this.domain;
    }

    public Optional<String> getPath() {
        return this.path;
    }

    public Optional<Boolean> getSecure() {
        return this.secure;
    }

    public Optional<Boolean> getHttpOnly() {
        return this.httpOnly;
    }

    public Optional<CookieSameSite> getSameSite() {
        return this.sameSite;
    }

    public Optional<TimeSinceEpoch> getExpires() {
        return this.expires;
    }

    @Beta
    public Optional<CookiePriority> getPriority() {
        return this.priority;
    }

    private static CookieParam fromJson(JsonInput input) {
        String name = null;
        String value = null;
        Optional<String> url = Optional.empty();
        Optional<String> domain = Optional.empty();
        Optional<String> path = Optional.empty();
        Optional<Boolean> secure = Optional.empty();
        Optional<Boolean> httpOnly = Optional.empty();
        Optional<CookieSameSite> sameSite = Optional.empty();
        Optional<TimeSinceEpoch> expires = Optional.empty();
        Optional<CookiePriority> priority = Optional.empty();
        input.beginObject();
        block24: while (input.hasNext()) {
            switch (input.nextName()) {
                case "name": {
                    name = input.nextString();
                    continue block24;
                }
                case "value": {
                    value = input.nextString();
                    continue block24;
                }
                case "url": {
                    url = Optional.ofNullable(input.nextString());
                    continue block24;
                }
                case "domain": {
                    domain = Optional.ofNullable(input.nextString());
                    continue block24;
                }
                case "path": {
                    path = Optional.ofNullable(input.nextString());
                    continue block24;
                }
                case "secure": {
                    secure = Optional.ofNullable(input.nextBoolean());
                    continue block24;
                }
                case "httpOnly": {
                    httpOnly = Optional.ofNullable(input.nextBoolean());
                    continue block24;
                }
                case "sameSite": {
                    sameSite = Optional.ofNullable((CookieSameSite)((Object)input.read(CookieSameSite.class)));
                    continue block24;
                }
                case "expires": {
                    expires = Optional.ofNullable((TimeSinceEpoch)input.read(TimeSinceEpoch.class));
                    continue block24;
                }
                case "priority": {
                    priority = Optional.ofNullable((CookiePriority)((Object)input.read(CookiePriority.class)));
                    continue block24;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new CookieParam(name, value, url, domain, path, secure, httpOnly, sameSite, expires, priority);
    }
}

