/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v141.animation.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v141.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v141.dom.model.ScrollOrientation;
import org.openqa.selenium.json.JsonInput;

public class ViewOrScrollTimeline {
    private final Optional<BackendNodeId> sourceNodeId;
    private final Optional<Number> startOffset;
    private final Optional<Number> endOffset;
    private final Optional<BackendNodeId> subjectNodeId;
    private final ScrollOrientation axis;

    public ViewOrScrollTimeline(Optional<BackendNodeId> sourceNodeId, Optional<Number> startOffset, Optional<Number> endOffset, Optional<BackendNodeId> subjectNodeId, ScrollOrientation axis) {
        this.sourceNodeId = sourceNodeId;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.subjectNodeId = subjectNodeId;
        this.axis = Objects.requireNonNull(axis, "axis is required");
    }

    public Optional<BackendNodeId> getSourceNodeId() {
        return this.sourceNodeId;
    }

    public Optional<Number> getStartOffset() {
        return this.startOffset;
    }

    public Optional<Number> getEndOffset() {
        return this.endOffset;
    }

    public Optional<BackendNodeId> getSubjectNodeId() {
        return this.subjectNodeId;
    }

    public ScrollOrientation getAxis() {
        return this.axis;
    }

    private static ViewOrScrollTimeline fromJson(JsonInput input) {
        Optional<BackendNodeId> sourceNodeId = Optional.empty();
        Optional<Number> startOffset = Optional.empty();
        Optional<Number> endOffset = Optional.empty();
        Optional<BackendNodeId> subjectNodeId = Optional.empty();
        ScrollOrientation axis = null;
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "sourceNodeId": {
                    sourceNodeId = Optional.ofNullable((BackendNodeId)input.read(BackendNodeId.class));
                    continue block14;
                }
                case "startOffset": {
                    startOffset = Optional.ofNullable(input.nextNumber());
                    continue block14;
                }
                case "endOffset": {
                    endOffset = Optional.ofNullable(input.nextNumber());
                    continue block14;
                }
                case "subjectNodeId": {
                    subjectNodeId = Optional.ofNullable((BackendNodeId)input.read(BackendNodeId.class));
                    continue block14;
                }
                case "axis": {
                    axis = (ScrollOrientation)((Object)input.read(ScrollOrientation.class));
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new ViewOrScrollTimeline(sourceNodeId, startOffset, endOffset, subjectNodeId, axis);
    }
}

