/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v121.accessibility.model;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v121.accessibility.model.AXNodeId;
import org.openqa.selenium.devtools.v121.accessibility.model.AXProperty;
import org.openqa.selenium.devtools.v121.accessibility.model.AXValue;
import org.openqa.selenium.devtools.v121.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v121.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class AXNode {
    private final AXNodeId nodeId;
    private final Boolean ignored;
    private final Optional<List<AXProperty>> ignoredReasons;
    private final Optional<AXValue> role;
    private final Optional<AXValue> chromeRole;
    private final Optional<AXValue> name;
    private final Optional<AXValue> description;
    private final Optional<AXValue> value;
    private final Optional<List<AXProperty>> properties;
    private final Optional<AXNodeId> parentId;
    private final Optional<List<AXNodeId>> childIds;
    private final Optional<BackendNodeId> backendDOMNodeId;
    private final Optional<FrameId> frameId;

    public AXNode(AXNodeId nodeId, Boolean ignored, Optional<List<AXProperty>> ignoredReasons, Optional<AXValue> role, Optional<AXValue> chromeRole, Optional<AXValue> name, Optional<AXValue> description, Optional<AXValue> value, Optional<List<AXProperty>> properties, Optional<AXNodeId> parentId, Optional<List<AXNodeId>> childIds, Optional<BackendNodeId> backendDOMNodeId, Optional<FrameId> frameId) {
        this.nodeId = Objects.requireNonNull(nodeId, "nodeId is required");
        this.ignored = Objects.requireNonNull(ignored, "ignored is required");
        this.ignoredReasons = ignoredReasons;
        this.role = role;
        this.chromeRole = chromeRole;
        this.name = name;
        this.description = description;
        this.value = value;
        this.properties = properties;
        this.parentId = parentId;
        this.childIds = childIds;
        this.backendDOMNodeId = backendDOMNodeId;
        this.frameId = frameId;
    }

    public AXNodeId getNodeId() {
        return this.nodeId;
    }

    public Boolean getIgnored() {
        return this.ignored;
    }

    public Optional<List<AXProperty>> getIgnoredReasons() {
        return this.ignoredReasons;
    }

    public Optional<AXValue> getRole() {
        return this.role;
    }

    public Optional<AXValue> getChromeRole() {
        return this.chromeRole;
    }

    public Optional<AXValue> getName() {
        return this.name;
    }

    public Optional<AXValue> getDescription() {
        return this.description;
    }

    public Optional<AXValue> getValue() {
        return this.value;
    }

    public Optional<List<AXProperty>> getProperties() {
        return this.properties;
    }

    public Optional<AXNodeId> getParentId() {
        return this.parentId;
    }

    public Optional<List<AXNodeId>> getChildIds() {
        return this.childIds;
    }

    public Optional<BackendNodeId> getBackendDOMNodeId() {
        return this.backendDOMNodeId;
    }

    public Optional<FrameId> getFrameId() {
        return this.frameId;
    }

    private static AXNode fromJson(JsonInput input) {
        AXNodeId nodeId = null;
        Boolean ignored = false;
        Optional<List<AXProperty>> ignoredReasons = Optional.empty();
        Optional<AXValue> role = Optional.empty();
        Optional<AXValue> chromeRole = Optional.empty();
        Optional<AXValue> name = Optional.empty();
        Optional<AXValue> description = Optional.empty();
        Optional<AXValue> value = Optional.empty();
        Optional<List<AXProperty>> properties = Optional.empty();
        Optional<AXNodeId> parentId = Optional.empty();
        Optional<List<AXNodeId>> childIds = Optional.empty();
        Optional<BackendNodeId> backendDOMNodeId = Optional.empty();
        Optional<FrameId> frameId = Optional.empty();
        input.beginObject();
        block30: while (input.hasNext()) {
            switch (input.nextName()) {
                case "nodeId": {
                    nodeId = (AXNodeId)input.read(AXNodeId.class);
                    continue block30;
                }
                case "ignored": {
                    ignored = input.nextBoolean();
                    continue block30;
                }
                case "ignoredReasons": {
                    ignoredReasons = Optional.ofNullable(input.readArray(AXProperty.class));
                    continue block30;
                }
                case "role": {
                    role = Optional.ofNullable((AXValue)input.read(AXValue.class));
                    continue block30;
                }
                case "chromeRole": {
                    chromeRole = Optional.ofNullable((AXValue)input.read(AXValue.class));
                    continue block30;
                }
                case "name": {
                    name = Optional.ofNullable((AXValue)input.read(AXValue.class));
                    continue block30;
                }
                case "description": {
                    description = Optional.ofNullable((AXValue)input.read(AXValue.class));
                    continue block30;
                }
                case "value": {
                    value = Optional.ofNullable((AXValue)input.read(AXValue.class));
                    continue block30;
                }
                case "properties": {
                    properties = Optional.ofNullable(input.readArray(AXProperty.class));
                    continue block30;
                }
                case "parentId": {
                    parentId = Optional.ofNullable((AXNodeId)input.read(AXNodeId.class));
                    continue block30;
                }
                case "childIds": {
                    childIds = Optional.ofNullable(input.readArray(AXNodeId.class));
                    continue block30;
                }
                case "backendDOMNodeId": {
                    backendDOMNodeId = Optional.ofNullable((BackendNodeId)input.read(BackendNodeId.class));
                    continue block30;
                }
                case "frameId": {
                    frameId = Optional.ofNullable((FrameId)input.read(FrameId.class));
                    continue block30;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new AXNode(nodeId, ignored, ignoredReasons, role, chromeRole, name, description, value, properties, parentId, childIds, backendDOMNodeId, frameId);
    }
}

