/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.resteasy.util.PathHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SegmentInfo
implements Comparable<SegmentInfo> {
    private Pattern pattern;
    private int literalCharacters;
    private int groups;
    private String expression;

    public SegmentInfo(String segment) {
        Matcher matcher = PathHelper.URI_TEMPLATE_PATTERN.matcher(segment);
        StringBuffer regex = new StringBuffer();
        while (matcher.find()) {
            ++this.groups;
            matcher.appendReplacement(regex, Matcher.quoteReplacement("(.*?)"));
        }
        matcher.appendTail(regex);
        this.expression = regex.append("$").toString();
        this.pattern = Pattern.compile(this.expression);
        matcher = PathHelper.URI_TEMPLATE_PATTERN.matcher(this.expression);
        regex = new StringBuffer();
        while (matcher.find()) {
            ++this.groups;
            matcher.appendReplacement(regex, "");
        }
        matcher.appendTail(regex);
        this.literalCharacters = regex.toString().length();
    }

    @Override
    public int compareTo(SegmentInfo segmentInfo) {
        if (this.literalCharacters > segmentInfo.literalCharacters) {
            return -1;
        }
        if (this.literalCharacters < segmentInfo.literalCharacters) {
            return 1;
        }
        if (this.groups > segmentInfo.groups) {
            return -1;
        }
        if (this.groups < segmentInfo.groups) {
            return 1;
        }
        return 0;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public String getExpression() {
        return this.expression;
    }

    public int getLiteralCharacters() {
        return this.literalCharacters;
    }

    public int getGroups() {
        return this.groups;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentInfo that = (SegmentInfo)o;
        if (this.groups != that.groups) {
            return false;
        }
        if (this.literalCharacters != that.literalCharacters) {
            return false;
        }
        return this.expression.equals(that.expression);
    }

    public int hashCode() {
        int result = this.literalCharacters;
        result = 31 * result + this.groups;
        result = 31 * result + this.expression.hashCode();
        return result;
    }
}

