/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.core.ApplicationConfig;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.Variant;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.RuntimeDelegate;
import org.resteasy.MediaTypeMap;
import org.resteasy.PropertyInjectorImpl;
import org.resteasy.plugins.delegates.CacheControlDelegate;
import org.resteasy.plugins.delegates.CookieHeaderDelegate;
import org.resteasy.plugins.delegates.EntityTagDelegate;
import org.resteasy.plugins.delegates.MediaTypeHeaderDelegate;
import org.resteasy.plugins.delegates.NewCookieHeaderDelegate;
import org.resteasy.plugins.delegates.UriHeaderDelegate;
import org.resteasy.specimpl.ResponseBuilderImpl;
import org.resteasy.specimpl.UriBuilderImpl;
import org.resteasy.specimpl.VariantListBuilderImpl;
import org.resteasy.util.Types;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResteasyProviderFactory
extends RuntimeDelegate {
    private MediaTypeMap<MessageBodyKey<MessageBodyReader>> messageBodyReaders = new MediaTypeMap();
    private MediaTypeMap<MessageBodyKey<MessageBodyWriter>> messageBodyWriters = new MediaTypeMap();
    private Map<Class<?>, ExceptionMapper> exceptionMappers = new HashMap();
    private Map<Class<?>, Object> providers = new HashMap();
    private Map<Class<?>, RuntimeDelegate.HeaderDelegate> headerDelegates = new HashMap();
    private static AtomicReference<ResteasyProviderFactory> pfr = new AtomicReference();
    private static ThreadLocal<Map<Class<?>, Object>> contextualData = new ThreadLocal();

    public static void pushContext(Class<?> type, Object data) {
        Map<Class<?>, Object> map = contextualData.get();
        if (map == null) {
            map = new HashMap();
            contextualData.set(map);
        }
        map.put(type, data);
    }

    public static <T> T getContextData(Class<T> type) {
        return (T)contextualData.get().get(type);
    }

    public static <T> T popContextData(Class<T> type) {
        return (T)contextualData.get().remove(type);
    }

    public static void clearContextData() {
        contextualData.set(null);
    }

    public static void setInstance(ResteasyProviderFactory factory) {
        pfr.set(factory);
        RuntimeDelegate.setInstance((RuntimeDelegate)factory);
    }

    public static ResteasyProviderFactory getInstance() {
        return pfr.get();
    }

    public static ResteasyProviderFactory initializeInstance() {
        ResteasyProviderFactory.setInstance(new ResteasyProviderFactory());
        return ResteasyProviderFactory.getInstance();
    }

    public ResteasyProviderFactory() {
        this.addHeaderDelegate(MediaType.class, new MediaTypeHeaderDelegate());
        this.addHeaderDelegate(NewCookie.class, new NewCookieHeaderDelegate());
        this.addHeaderDelegate(Cookie.class, new CookieHeaderDelegate());
        this.addHeaderDelegate(URI.class, new UriHeaderDelegate());
        this.addHeaderDelegate(EntityTag.class, new EntityTagDelegate());
        this.addHeaderDelegate(CacheControl.class, new CacheControlDelegate());
    }

    public UriBuilder createUriBuilder() {
        return new UriBuilderImpl();
    }

    public Response.ResponseBuilder createResponseBuilder() {
        return new ResponseBuilderImpl();
    }

    public Variant.VariantListBuilder createVariantListBuilder() {
        return new VariantListBuilderImpl();
    }

    public <T> RuntimeDelegate.HeaderDelegate<T> createHeaderDelegate(Class<T> tClass) {
        return this.headerDelegates.get(tClass);
    }

    public void addHeaderDelegate(Class clazz, RuntimeDelegate.HeaderDelegate header) {
        this.headerDelegates.put(clazz, header);
    }

    public void addMessageBodyReader(Class<? extends MessageBodyReader> provider) {
        MessageBodyReader reader = null;
        try {
            reader = provider.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        this.addMessageBodyReader(reader);
    }

    public void addMessageBodyReader(MessageBodyReader provider) {
        PropertyInjectorImpl injector = new PropertyInjectorImpl(provider.getClass(), null, this);
        injector.inject(provider);
        this.providers.put(provider.getClass(), provider);
        ConsumeMime consumeMime = provider.getClass().getAnnotation(ConsumeMime.class);
        MessageBodyKey key = new MessageBodyKey(provider.getClass(), provider);
        if (consumeMime != null) {
            for (String consume : consumeMime.value()) {
                MediaType mime = MediaType.valueOf((String)consume);
                this.messageBodyReaders.add(mime, key);
            }
        } else {
            this.messageBodyReaders.add(new MediaType("*", "*"), key);
        }
    }

    public void addMessageBodyWriter(Class<? extends MessageBodyWriter> provider) {
        MessageBodyWriter writer = null;
        try {
            writer = provider.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        this.addMessageBodyWriter(writer);
    }

    public void addMessageBodyWriter(MessageBodyWriter provider) {
        PropertyInjectorImpl injector = new PropertyInjectorImpl(provider.getClass(), null, this);
        this.providers.put(provider.getClass(), provider);
        injector.inject(provider);
        ProduceMime consumeMime = provider.getClass().getAnnotation(ProduceMime.class);
        MessageBodyKey key = new MessageBodyKey(provider.getClass(), provider);
        if (consumeMime != null) {
            for (String consume : consumeMime.value()) {
                MediaType mime = MediaType.valueOf((String)consume);
                this.messageBodyWriters.add(mime, key);
            }
        } else {
            this.messageBodyWriters.add(new MediaType("*", "*"), key);
        }
    }

    public <T> MessageBodyReader<T> createMessageBodyReader(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        List<MessageBodyKey<MessageBodyReader>> readers = this.messageBodyReaders.getPossible(mediaType);
        if (mediaType.isWildcardType()) {
            Collections.sort(readers);
        }
        for (MessageBodyKey<MessageBodyReader> reader : readers) {
            if (!((MessageBodyReader)reader.obj).isReadable(type, genericType, annotations)) continue;
            return (MessageBodyReader)reader.obj;
        }
        return null;
    }

    public void addExceptionMapper(Class<? extends ExceptionMapper> provider) {
        ExceptionMapper writer = null;
        try {
            writer = provider.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        this.addExceptionMapper(writer);
    }

    public void addExceptionMapper(ExceptionMapper provider) {
        Type[] intfs;
        this.providers.put(provider.getClass(), provider);
        PropertyInjectorImpl injector = new PropertyInjectorImpl(provider.getClass(), null, this);
        injector.inject(provider);
        for (Type type : intfs = provider.getClass().getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(type instanceof ParameterizedType) || !(pt = (ParameterizedType)type).getRawType().equals(ExceptionMapper.class)) continue;
            this.exceptionMappers.put(Types.getRawType(pt.getActualTypeArguments()[0]), provider);
        }
    }

    public void registerProvider(Class provider) {
        if (MessageBodyReader.class.isAssignableFrom(provider)) {
            try {
                this.addMessageBodyReader(provider);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate MessageBodyReader", e);
            }
        }
        if (MessageBodyWriter.class.isAssignableFrom(provider)) {
            try {
                this.addMessageBodyWriter(provider);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate MessageBodyWriter", e);
            }
        }
        if (ExceptionMapper.class.isAssignableFrom(provider)) {
            try {
                this.addExceptionMapper(provider);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate ExceptionMapper", e);
            }
        }
    }

    public void registerProviderInstance(Object provider) {
        if (provider instanceof MessageBodyReader) {
            try {
                this.addMessageBodyReader((MessageBodyReader)provider);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate MessageBodyReader", e);
            }
        }
        if (provider instanceof MessageBodyWriter) {
            try {
                this.addMessageBodyWriter((MessageBodyWriter)provider);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate MessageBodyWriter", e);
            }
        }
        if (provider instanceof ExceptionMapper) {
            try {
                this.addExceptionMapper((ExceptionMapper)provider);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to instantiate ExceptionMapper", e);
            }
        }
    }

    public <T> T getProvider(Class<T> providerClass) {
        return (T)this.providers.get(providerClass);
    }

    public <T> ExceptionMapper<T> createExceptionMapper(Class<T> type) {
        return this.exceptionMappers.get(type);
    }

    public <T> MessageBodyWriter<T> createMessageBodyWriter(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        List<MessageBodyKey<MessageBodyWriter>> writers = this.messageBodyWriters.getPossible(mediaType);
        if (mediaType.isWildcardType()) {
            Collections.sort(writers);
        }
        for (MessageBodyKey<MessageBodyWriter> writer : writers) {
            if (!((MessageBodyWriter)writer.obj).isWriteable(type, genericType, annotations)) continue;
            return (MessageBodyWriter)writer.obj;
        }
        return null;
    }

    public <T> T createEndpoint(ApplicationConfig applicationConfig, Class<T> endpointType) throws IllegalArgumentException, UnsupportedOperationException {
        throw new RuntimeException("NOT USABLE IN RESTEASY");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MessageBodyKey<T>
    implements Comparable<MessageBodyKey<T>> {
        public Class<? extends T> readerClass;
        public T obj;
        boolean isGeneric = false;

        private MessageBodyKey(Class<? extends T> readerClass, T reader) {
            this.readerClass = readerClass;
            this.obj = reader;
            Type impls = readerClass.getGenericInterfaces()[0];
            if (impls instanceof ParameterizedType) {
                ParameterizedType param = (ParameterizedType)impls;
                if (param.getActualTypeArguments()[0].equals(Object.class)) {
                    this.isGeneric = true;
                }
            } else {
                this.isGeneric = true;
            }
        }

        @Override
        public int compareTo(MessageBodyKey<T> tMessageBodyKey) {
            if (this == tMessageBodyKey) {
                return 0;
            }
            if (this.isGeneric == tMessageBodyKey.isGeneric) {
                return 0;
            }
            if (this.isGeneric) {
                return 1;
            }
            return -1;
        }
    }
}

