/*
 * Decompiled with CFR 0.152.
 */
package org.resteasy;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.MessageBodyWriter;
import org.resteasy.Failure;
import org.resteasy.PathParamIndex;
import org.resteasy.ResourceInvoker;
import org.resteasy.spi.HttpRequest;
import org.resteasy.spi.HttpResponse;
import org.resteasy.spi.InjectorFactory;
import org.resteasy.spi.MethodInjector;
import org.resteasy.spi.ResourceFactory;
import org.resteasy.spi.ResteasyProviderFactory;
import org.resteasy.util.WeightedMediaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceMethod
implements ResourceInvoker {
    protected MediaType[] produces;
    protected MediaType[] consumes;
    protected List<WeightedMediaType> preferredProduces = new ArrayList<WeightedMediaType>();
    protected List<WeightedMediaType> preferredConsumes = new ArrayList<WeightedMediaType>();
    protected Set<String> httpMethods;
    protected MethodInjector methodInjector;
    protected InjectorFactory injector;
    protected ResourceFactory resource;
    protected ResteasyProviderFactory providerFactory;
    protected PathParamIndex index;
    protected Method method;
    protected String[] rolesAllowed;
    protected boolean denyAll;

    public ResourceMethod(Class<?> clazz, Method method, InjectorFactory injector, ResourceFactory resource, ResteasyProviderFactory providerFactory, Set<String> httpMethods, PathParamIndex index) {
        int i;
        ConsumeMime c;
        this.injector = injector;
        this.resource = resource;
        this.providerFactory = providerFactory;
        this.httpMethods = httpMethods;
        this.index = index;
        this.method = method;
        this.methodInjector = injector.createMethodInjector(method);
        ProduceMime p = method.getAnnotation(ProduceMime.class);
        if (p == null) {
            p = clazz.getAnnotation(ProduceMime.class);
        }
        if ((c = method.getAnnotation(ConsumeMime.class)) == null) {
            c = clazz.getAnnotation(ConsumeMime.class);
        }
        if (p != null) {
            this.produces = new MediaType[p.value().length];
            i = 0;
            for (String mediaType : p.value()) {
                this.produces[i++] = MediaType.valueOf((String)mediaType);
                this.preferredProduces.add(WeightedMediaType.valueOf(mediaType));
            }
        }
        if (c != null) {
            this.consumes = new MediaType[c.value().length];
            i = 0;
            for (String mediaType : c.value()) {
                this.consumes[i++] = MediaType.valueOf((String)mediaType);
                this.preferredConsumes.add(WeightedMediaType.valueOf(mediaType));
            }
        }
        Collections.sort(this.preferredProduces);
        Collections.sort(this.preferredConsumes);
        RolesAllowed allowed = clazz.getAnnotation(RolesAllowed.class);
        RolesAllowed methodAllowed = method.getAnnotation(RolesAllowed.class);
        if (methodAllowed != null) {
            allowed = methodAllowed;
        }
        if (allowed != null) {
            this.rolesAllowed = allowed.value();
        }
        this.denyAll = clazz.isAnnotationPresent(DenyAll.class) && !method.isAnnotationPresent(RolesAllowed.class) && !method.isAnnotationPresent(PermitAll.class) || method.isAnnotationPresent(DenyAll.class);
    }

    public List<WeightedMediaType> getPreferredProduces() {
        return this.preferredProduces;
    }

    public List<WeightedMediaType> getPreferredConsumes() {
        return this.preferredConsumes;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    public void invoke(HttpRequest request, HttpResponse response) throws IOException {
        Object target = this.resource.createResource(request, response, this.injector);
        this.invoke(request, response, target);
    }

    public void checkAuthorized() {
        if (this.denyAll) {
            throw new Failure(401);
        }
        if (this.rolesAllowed == null) {
            return;
        }
        SecurityContext context = ResteasyProviderFactory.getContextData(SecurityContext.class);
        if (context != null) {
            for (String role : this.rolesAllowed) {
                if (!context.isUserInRole(role)) continue;
                return;
            }
            throw new Failure(401);
        }
    }

    public void invoke(HttpRequest request, HttpResponse response, Object target) throws IOException {
        List cookies;
        this.checkAuthorized();
        Response jaxrsResponse = null;
        try {
            this.index.populateUriInfoTemplateParams(request);
            jaxrsResponse = this.methodInjector.invoke(request, response, target);
        }
        catch (Failure e) {
            response.sendError(400);
            e.printStackTrace();
            return;
        }
        response.setStatus(jaxrsResponse.getStatus());
        if (jaxrsResponse.getMetadata() != null && (cookies = (List)jaxrsResponse.getMetadata().get((Object)"Set-Cookie")) != null) {
            Iterator it = cookies.iterator();
            while (it.hasNext()) {
                Object next = it.next();
                if (!(next instanceof NewCookie)) continue;
                NewCookie cookie = (NewCookie)next;
                response.addNewCookie(cookie);
                it.remove();
            }
            if (cookies.size() < 1) {
                jaxrsResponse.getMetadata().remove((Object)"Set-Cookie");
            }
        }
        if (jaxrsResponse.getMetadata() != null && jaxrsResponse.getMetadata().size() > 0) {
            response.getOutputHeaders().putAll((Map)jaxrsResponse.getMetadata());
        }
        if (jaxrsResponse.getEntity() != null) {
            MediaType responseContentType = this.resolveContentType(request, jaxrsResponse);
            this.writeResponse(response, jaxrsResponse.getEntity(), responseContentType);
        }
    }

    protected void writeResponse(HttpResponse response, Object entity, MediaType responseContentType) {
        Annotation[] annotations;
        MessageBodyWriter<?> writer;
        Class<?> type = entity.getClass();
        Type genericType = null;
        if (!Response.class.equals(this.getMethod().getReturnType())) {
            genericType = this.getMethod().getGenericReturnType();
        }
        if ((writer = this.providerFactory.createMessageBodyWriter(type, genericType, annotations = this.getMethod().getAnnotations(), responseContentType)) == null) {
            throw new RuntimeException("Could not find MessageBodyWriter for response object of type: " + entity.getClass() + " of media type: " + responseContentType);
        }
        try {
            long size = writer.getSize(entity);
            response.getOutputHeaders().putSingle((Object)"Content-Length", (Object)Integer.toString((int)size));
            response.getOutputHeaders().putSingle((Object)"Content-Type", (Object)responseContentType.toString());
            writer.writeTo(entity, type, genericType, this.getMethod().getAnnotations(), responseContentType, response.getOutputHeaders(), response.getOutputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected MediaType resolveContentType(HttpRequest in, Response responseImpl) {
        Object contentType = responseImpl.getMetadata().getFirst((Object)"Content-Type");
        MediaType responseContentType = null;
        responseContentType = contentType != null ? MediaType.valueOf((String)contentType.toString()) : this.matchByType(in.getHttpHeaders().getAcceptableMediaTypes());
        if (responseContentType == null) {
            responseContentType = MediaType.valueOf((String)"*/*");
        }
        return responseContentType;
    }

    public boolean doesProduce(List<? extends MediaType> accepts) {
        if (accepts == null || accepts.size() == 0) {
            return true;
        }
        if (this.produces == null || this.produces.length == 0) {
            return true;
        }
        for (MediaType mediaType : accepts) {
            for (WeightedMediaType type : this.preferredProduces) {
                if (!type.isCompatible(mediaType)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean doesConsume(MediaType contentType) {
        boolean matches = false;
        if (contentType == null) {
            matches = true;
        } else if (this.consumes == null || this.consumes.length == 0) {
            matches = true;
        } else {
            for (WeightedMediaType type : this.preferredConsumes) {
                if (!type.isCompatible(contentType)) continue;
                matches = true;
                break;
            }
        }
        return matches;
    }

    public MediaType matchByType(List<MediaType> accepts) {
        if (accepts == null || accepts.size() == 0) {
            if (this.produces == null) {
                return MediaType.valueOf((String)"*/*");
            }
            return this.produces[0];
        }
        if (this.produces == null || this.produces.length == 0) {
            return accepts.get(0);
        }
        for (MediaType accept : accepts) {
            for (MediaType type : this.produces) {
                if (!type.isCompatible(accept)) continue;
                return type;
            }
        }
        return null;
    }

    public Set<String> getHttpMethods() {
        return this.httpMethods;
    }

    public MediaType[] getProduces() {
        return this.produces;
    }

    public MediaType[] getConsumes() {
        return this.consumes;
    }
}

