/*
 * Decompiled with CFR 0.152.
 */
package org.piwik.java.tracking;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.json.JsonValue;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.TypeConstraintException;
import org.piwik.java.tracking.CustomVariable;
import org.piwik.java.tracking.CustomVariableList;
import org.piwik.java.tracking.EcommerceItem;
import org.piwik.java.tracking.PiwikDate;
import org.piwik.java.tracking.PiwikJsonArray;
import org.piwik.java.tracking.PiwikLocale;

public class PiwikRequest {
    public static final int ID_LENGTH = 16;
    public static final int AUTH_TOKEN_LENGTH = 32;
    private static final String ACTION_NAME = "action_name";
    private static final String ACTION_TIME = "gt_ms";
    private static final String ACTION_URL = "url";
    private static final String API_VERSION = "apiv";
    private static final String AUTH_TOKEN = "token_auth";
    private static final String CAMPAIGN_KEYWORD = "_rck";
    private static final String CAMPAIGN_NAME = "_rcn";
    private static final String CHARACTER_SET = "cs";
    private static final String CONTENT_INTERACTION = "c_i";
    private static final String CONTENT_NAME = "c_n";
    private static final String CONTENT_PIECE = "c_p";
    private static final String CONTENT_TARGET = "c_t";
    private static final String CURRENT_HOUR = "h";
    private static final String CURRENT_MINUTE = "m";
    private static final String CURRENT_SECOND = "s";
    private static final String DEVICE_RESOLUTION = "res";
    private static final String DOWNLOAD_URL = "download";
    private static final String ECOMMERCE_DISCOUNT = "ec_dt";
    private static final String ECOMMERCE_ID = "ec_id";
    private static final String ECOMMERCE_ITEMS = "ec_items";
    private static final String ECOMMERCE_LAST_ORDER_TIMESTAMP = "_ects";
    private static final String ECOMMERCE_REVENUE = "revenue";
    private static final String ECOMMERCE_SHIPPING_COST = "ec_sh";
    private static final String ECOMMERCE_SUBTOTAL = "ec_st";
    private static final String ECOMMERCE_TAX = "ec_tx";
    private static final String EVENT_ACTION = "e_a";
    private static final String EVENT_CATEGORY = "e_c";
    private static final String EVENT_NAME = "e_n";
    private static final String EVENT_VALUE = "e_v";
    private static final String HEADER_ACCEPT_LANGUAGE = "lang";
    private static final String GOAL_ID = "idgoal";
    private static final String GOAL_REVENUE = "revenue";
    private static final String HEADER_USER_AGENT = "ua";
    private static final String NEW_VISIT = "new_visit";
    private static final String OUTLINK_URL = "link";
    private static final String PAGE_CUSTOM_VARIABLE = "cvar";
    private static final String PLUGIN_DIRECTOR = "dir";
    private static final String PLUGIN_FLASH = "fla";
    private static final String PLUGIN_GEARS = "gears";
    private static final String PLUGIN_JAVA = "java";
    private static final String PLUGIN_PDF = "pdf";
    private static final String PLUGIN_QUICKTIME = "qt";
    private static final String PLUGIN_REAL_PLAYER = "realp";
    private static final String PLUGIN_SILVERLIGHT = "ag";
    private static final String PLUGIN_WINDOWS_MEDIA = "wma";
    private static final String RANDOM_VALUE = "rand";
    private static final String REFERRER_URL = "urlref";
    private static final String REQUEST_DATETIME = "cdt";
    private static final String REQUIRED = "rec";
    private static final String RESPONSE_AS_IMAGE = "send_image";
    private static final String SEARCH_CATEGORY = "search_cat";
    private static final String SEARCH_QUERY = "search";
    private static final String SEARCH_RESULTS_COUNT = "search_count";
    private static final String SITE_ID = "idsite";
    private static final String TRACK_BOT_REQUESTS = "bots";
    private static final String VISIT_CUSTOM_VARIABLE = "_cvar";
    private static final String USER_ID = "uid";
    private static final String VISITOR_CITY = "city";
    private static final String VISITOR_COUNTRY = "country";
    private static final String VISITOR_CUSTOM_ID = "cid";
    private static final String VISITOR_FIRST_VISIT_TIMESTAMP = "_idts";
    private static final String VISITOR_ID = "_id";
    private static final String VISITOR_IP = "cip";
    private static final String VISITOR_LATITUDE = "lat";
    private static final String VISITOR_LONGITUDE = "long";
    private static final String VISITOR_PREVIOUS_VISIT_TIMESTAMP = "_viewts";
    private static final String VISITOR_REGION = "region";
    private static final String VISITOR_VISIT_COUNT = "_idvc";
    private static final int RANDOM_VALUE_LENGTH = 20;
    private static final long REQUEST_DATETIME_AUTH_LIMIT = 14400000L;
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private final Map<String, List> customTrackingParameters = new HashMap<String, List>();

    public PiwikRequest(Integer siteId, URL actionUrl) {
        this.setParameter(SITE_ID, siteId);
        this.setBooleanParameter(REQUIRED, true);
        this.setParameter(ACTION_URL, actionUrl);
        this.setParameter(VISITOR_ID, PiwikRequest.getRandomHexString(16));
        this.setParameter(RANDOM_VALUE, PiwikRequest.getRandomHexString(20));
        this.setParameter(API_VERSION, "1");
        this.setBooleanParameter(RESPONSE_AS_IMAGE, false);
    }

    public String getActionName() {
        return (String)this.getParameter(ACTION_NAME);
    }

    public void setActionName(String actionName) {
        this.setParameter(ACTION_NAME, actionName);
    }

    public Long getActionTime() {
        return (Long)this.getParameter(ACTION_TIME);
    }

    public void setActionTime(Long actionTime) {
        this.setParameter(ACTION_TIME, actionTime);
    }

    public URL getActionUrl() {
        return this.returnAsUrl(ACTION_URL, "Action URL", "getActionUrlAsString");
    }

    public String getActionUrlAsString() {
        return this.returnAsString(ACTION_URL, "Action URL", "getActionUrl");
    }

    public void setActionUrl(URL actionUrl) {
        this.setParameter(ACTION_URL, actionUrl);
    }

    public void setActionUrlWithString(String actionUrl) {
        this.setParameter(ACTION_URL, actionUrl);
    }

    public String getApiVersion() {
        return (String)this.getParameter(API_VERSION);
    }

    public void setApiVersion(String apiVersion) {
        this.setParameter(API_VERSION, apiVersion);
    }

    public String getAuthToken() {
        return (String)this.getParameter(AUTH_TOKEN);
    }

    public void setAuthToken(String authToken) {
        if (authToken != null && authToken.length() != 32) {
            throw new IllegalArgumentException(authToken + " is not " + 32 + " characters long.");
        }
        this.setParameter(AUTH_TOKEN, authToken);
    }

    public void verifyAuthTokenSet() {
        if (this.getAuthToken() == null) {
            throw new IllegalStateException("AuthToken must be set before this value can be set.");
        }
    }

    public String getCampaignKeyword() {
        return (String)this.getParameter(CAMPAIGN_KEYWORD);
    }

    public void setCampaignKeyword(String campaignKeyword) {
        this.setParameter(CAMPAIGN_KEYWORD, campaignKeyword);
    }

    public String getCampaignName() {
        return (String)this.getParameter(CAMPAIGN_NAME);
    }

    public void setCampaignName(String campaignName) {
        this.setParameter(CAMPAIGN_NAME, campaignName);
    }

    public Charset getCharacterSet() {
        return (Charset)this.getParameter(CHARACTER_SET);
    }

    public void setCharacterSet(Charset characterSet) {
        this.setParameter(CHARACTER_SET, characterSet);
    }

    public String getContentInteraction() {
        return (String)this.getParameter(CONTENT_INTERACTION);
    }

    public void setContentInteraction(String contentInteraction) {
        this.setParameter(CONTENT_INTERACTION, contentInteraction);
    }

    public String getContentName() {
        return (String)this.getParameter(CONTENT_NAME);
    }

    public void setContentName(String contentName) {
        this.setParameter(CONTENT_NAME, contentName);
    }

    public String getContentPiece() {
        return (String)this.getParameter(CONTENT_PIECE);
    }

    public void setContentPiece(String contentPiece) {
        this.setParameter(CONTENT_PIECE, contentPiece);
    }

    public URL getContentTarget() {
        return this.returnAsUrl(CONTENT_TARGET, "Content Target", "getContentTargetAsString");
    }

    public String getContentTargetAsString() {
        return this.returnAsString(CONTENT_TARGET, "Content Target", "getContentTarget");
    }

    public void setContentTarget(URL contentTarget) {
        this.setParameter(CONTENT_TARGET, contentTarget);
    }

    public void setContentTargetWithString(String contentTarget) {
        this.setParameter(CONTENT_TARGET, contentTarget);
    }

    public Integer getCurrentHour() {
        return (Integer)this.getParameter(CURRENT_HOUR);
    }

    public void setCurrentHour(Integer currentHour) {
        this.setParameter(CURRENT_HOUR, currentHour);
    }

    public Integer getCurrentMinute() {
        return (Integer)this.getParameter(CURRENT_MINUTE);
    }

    public void setCurrentMinute(Integer currentMinute) {
        this.setParameter(CURRENT_MINUTE, currentMinute);
    }

    public Integer getCurrentSecond() {
        return (Integer)this.getParameter(CURRENT_SECOND);
    }

    public void setCurrentSecond(Integer currentSecond) {
        this.setParameter(CURRENT_SECOND, currentSecond);
    }

    public List getCustomTrackingParameter(String key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null.");
        }
        List l = this.customTrackingParameters.get(key);
        if (l == null) {
            return new ArrayList(0);
        }
        return new ArrayList(l);
    }

    public void setCustomTrackingParameter(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null.");
        }
        if (value == null) {
            this.customTrackingParameters.remove(key);
        } else {
            ArrayList<Object> l = new ArrayList<Object>();
            l.add(value);
            this.customTrackingParameters.put(key, l);
        }
    }

    public void addCustomTrackingParameter(String key, Object value) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null.");
        }
        if (value == null) {
            throw new NullPointerException("Cannot add a null custom tracking parameter.");
        }
        ArrayList<Object> l = this.customTrackingParameters.get(key);
        if (l == null) {
            l = new ArrayList<Object>();
            this.customTrackingParameters.put(key, l);
        }
        l.add(value);
    }

    public void clearCustomTrackingParameter() {
        this.customTrackingParameters.clear();
    }

    public String getDeviceResolution() {
        return (String)this.getParameter(DEVICE_RESOLUTION);
    }

    public void setDeviceResolution(String deviceResolution) {
        this.setParameter(DEVICE_RESOLUTION, deviceResolution);
    }

    public URL getDownloadUrl() {
        return this.returnAsUrl(DOWNLOAD_URL, "Download URL", "getDownloadUrlAsString");
    }

    public String getDownloadUrlAsString() {
        return this.returnAsString(DOWNLOAD_URL, "Download URL", "getDownloadUrl");
    }

    public void setDownloadUrl(URL downloadUrl) {
        this.setParameter(DOWNLOAD_URL, downloadUrl);
    }

    public void setDownloadUrlWithString(String downloadUrl) {
        this.setParameter(DOWNLOAD_URL, downloadUrl);
    }

    public void enableEcommerce() {
        this.setGoalId(0);
    }

    public void verifyEcommerceEnabled() {
        if (this.getGoalId() == null || this.getGoalId() != 0) {
            throw new IllegalStateException("GoalId must be \"0\".  Try calling enableEcommerce first before calling this method.");
        }
    }

    public void verifyEcommerceState() {
        this.verifyEcommerceEnabled();
        if (this.getEcommerceId() == null) {
            throw new IllegalStateException("EcommerceId must be set before this value can be set.");
        }
        if (this.getEcommerceRevenue() == null) {
            throw new IllegalStateException("EcommerceRevenue must be set before this value can be set.");
        }
    }

    public Double getEcommerceDiscount() {
        return (Double)this.getParameter(ECOMMERCE_DISCOUNT);
    }

    public void setEcommerceDiscount(Double discount) {
        if (discount != null) {
            this.verifyEcommerceState();
        }
        this.setParameter(ECOMMERCE_DISCOUNT, discount);
    }

    public String getEcommerceId() {
        return (String)this.getParameter(ECOMMERCE_ID);
    }

    public void setEcommerceId(String id) {
        if (id != null) {
            this.verifyEcommerceEnabled();
        }
        this.setParameter(ECOMMERCE_ID, id);
    }

    public EcommerceItem getEcommerceItem(int index) {
        return (EcommerceItem)this.getFromJsonArray(ECOMMERCE_ITEMS, index);
    }

    public void addEcommerceItem(EcommerceItem item) {
        if (item != null) {
            this.verifyEcommerceState();
        }
        this.addToJsonArray(ECOMMERCE_ITEMS, item);
    }

    public void clearEcommerceItems() {
        this.removeJsonArray(ECOMMERCE_ITEMS);
    }

    public Long getEcommerceLastOrderTimestamp() {
        return (Long)this.getParameter(ECOMMERCE_LAST_ORDER_TIMESTAMP);
    }

    public void setEcommerceLastOrderTimestamp(Long timestamp) {
        if (timestamp != null) {
            this.verifyEcommerceState();
        }
        this.setParameter(ECOMMERCE_LAST_ORDER_TIMESTAMP, timestamp);
    }

    public Double getEcommerceRevenue() {
        return (Double)this.getParameter("revenue");
    }

    public void setEcommerceRevenue(Double revenue) {
        if (revenue != null) {
            this.verifyEcommerceEnabled();
        }
        this.setParameter("revenue", revenue);
    }

    public Double getEcommerceShippingCost() {
        return (Double)this.getParameter(ECOMMERCE_SHIPPING_COST);
    }

    public void setEcommerceShippingCost(Double shippingCost) {
        if (shippingCost != null) {
            this.verifyEcommerceState();
        }
        this.setParameter(ECOMMERCE_SHIPPING_COST, shippingCost);
    }

    public Double getEcommerceSubtotal() {
        return (Double)this.getParameter(ECOMMERCE_SUBTOTAL);
    }

    public void setEcommerceSubtotal(Double subtotal) {
        if (subtotal != null) {
            this.verifyEcommerceState();
        }
        this.setParameter(ECOMMERCE_SUBTOTAL, subtotal);
    }

    public Double getEcommerceTax() {
        return (Double)this.getParameter(ECOMMERCE_TAX);
    }

    public void setEcommerceTax(Double tax) {
        if (tax != null) {
            this.verifyEcommerceState();
        }
        this.setParameter(ECOMMERCE_TAX, tax);
    }

    public String getEventAction() {
        return this.getNonEmptyStringParameter(EVENT_ACTION);
    }

    public void setEventAction(String eventAction) {
        this.setNonEmptyStringParameter(EVENT_ACTION, eventAction);
    }

    public String getEventCategory() {
        return this.getNonEmptyStringParameter(EVENT_CATEGORY);
    }

    public void setEventCategory(String eventCategory) {
        this.setNonEmptyStringParameter(EVENT_CATEGORY, eventCategory);
    }

    public String getEventName() {
        return (String)this.getParameter(EVENT_NAME);
    }

    public void setEventName(String eventName) {
        this.setParameter(EVENT_NAME, eventName);
    }

    public Number getEventValue() {
        return (Number)this.getParameter(EVENT_VALUE);
    }

    public void setEventValue(Number eventValue) {
        this.setParameter(EVENT_VALUE, eventValue);
    }

    public Integer getGoalId() {
        return (Integer)this.getParameter(GOAL_ID);
    }

    public void setGoalId(Integer goalId) {
        this.setParameter(GOAL_ID, goalId);
    }

    public Double getGoalRevenue() {
        return (Double)this.getParameter("revenue");
    }

    public void setGoalRevenue(Double goalRevenue) {
        if (goalRevenue != null && this.getGoalId() == null) {
            throw new IllegalStateException("GoalId must be set before GoalRevenue can be set.");
        }
        this.setParameter("revenue", goalRevenue);
    }

    public String getHeaderAcceptLanguage() {
        return (String)this.getParameter(HEADER_ACCEPT_LANGUAGE);
    }

    public void setHeaderAcceptLanguage(String acceptLangage) {
        this.setParameter(HEADER_ACCEPT_LANGUAGE, acceptLangage);
    }

    public String getHeaderUserAgent() {
        return (String)this.getParameter(HEADER_USER_AGENT);
    }

    public void setHeaderUserAgent(String userAgent) {
        this.setParameter(HEADER_USER_AGENT, userAgent);
    }

    public Boolean getNewVisit() {
        return this.getBooleanParameter(NEW_VISIT);
    }

    public void setNewVisit(Boolean newVisit) {
        this.setBooleanParameter(NEW_VISIT, newVisit);
    }

    public URL getOutlinkUrl() {
        return this.returnAsUrl(OUTLINK_URL, "Outlink URL", "getOutlinkUrlAsString");
    }

    public String getOutlinkUrlAsString() {
        return this.returnAsString(OUTLINK_URL, "Outlink URL", "getOutlinkUrl");
    }

    public void setOutlinkUrl(URL outlinkUrl) {
        this.setParameter(OUTLINK_URL, outlinkUrl);
    }

    public void setOutlinkUrlWithString(String outlinkUrl) {
        this.setParameter(OUTLINK_URL, outlinkUrl);
    }

    @Deprecated
    public String getPageCustomVariable(String key) {
        return this.getCustomVariable(PAGE_CUSTOM_VARIABLE, key);
    }

    public CustomVariable getPageCustomVariable(int index) {
        return this.getCustomVariable(PAGE_CUSTOM_VARIABLE, index);
    }

    @Deprecated
    public void setPageCustomVariable(String key, String value) {
        if (value == null) {
            this.removeCustomVariable(PAGE_CUSTOM_VARIABLE, key);
        } else {
            this.setCustomVariable(PAGE_CUSTOM_VARIABLE, new CustomVariable(key, value), null);
        }
    }

    public void setPageCustomVariable(CustomVariable customVariable, int index) {
        this.setCustomVariable(PAGE_CUSTOM_VARIABLE, customVariable, index);
    }

    public Boolean getPluginDirector() {
        return this.getBooleanParameter(PLUGIN_DIRECTOR);
    }

    public void setPluginDirector(Boolean director) {
        this.setBooleanParameter(PLUGIN_DIRECTOR, director);
    }

    public Boolean getPluginFlash() {
        return this.getBooleanParameter(PLUGIN_FLASH);
    }

    public void setPluginFlash(Boolean flash) {
        this.setBooleanParameter(PLUGIN_FLASH, flash);
    }

    public Boolean getPluginGears() {
        return this.getBooleanParameter(PLUGIN_GEARS);
    }

    public void setPluginGears(Boolean gears) {
        this.setBooleanParameter(PLUGIN_GEARS, gears);
    }

    public Boolean getPluginJava() {
        return this.getBooleanParameter(PLUGIN_JAVA);
    }

    public void setPluginJava(Boolean java) {
        this.setBooleanParameter(PLUGIN_JAVA, java);
    }

    public Boolean getPluginPDF() {
        return this.getBooleanParameter(PLUGIN_PDF);
    }

    public void setPluginPDF(Boolean pdf) {
        this.setBooleanParameter(PLUGIN_PDF, pdf);
    }

    public Boolean getPluginQuicktime() {
        return this.getBooleanParameter(PLUGIN_QUICKTIME);
    }

    public void setPluginQuicktime(Boolean quicktime) {
        this.setBooleanParameter(PLUGIN_QUICKTIME, quicktime);
    }

    public Boolean getPluginRealPlayer() {
        return this.getBooleanParameter(PLUGIN_REAL_PLAYER);
    }

    public void setPluginRealPlayer(Boolean realPlayer) {
        this.setBooleanParameter(PLUGIN_REAL_PLAYER, realPlayer);
    }

    public Boolean getPluginSilverlight() {
        return this.getBooleanParameter(PLUGIN_SILVERLIGHT);
    }

    public void setPluginSilverlight(Boolean silverlight) {
        this.setBooleanParameter(PLUGIN_SILVERLIGHT, silverlight);
    }

    public Boolean getPluginWindowsMedia() {
        return this.getBooleanParameter(PLUGIN_WINDOWS_MEDIA);
    }

    public void setPluginWindowsMedia(Boolean windowsMedia) {
        this.setBooleanParameter(PLUGIN_WINDOWS_MEDIA, windowsMedia);
    }

    public String getRandomValue() {
        return (String)this.getParameter(RANDOM_VALUE);
    }

    public void setRandomValue(String randomValue) {
        this.setParameter(RANDOM_VALUE, randomValue);
    }

    public URL getReferrerUrl() {
        return this.returnAsUrl(REFERRER_URL, "Referrer URL", "getReferrerUrlAsString");
    }

    public String getReferrerUrlAsString() {
        return this.returnAsString(REFERRER_URL, "Referrer URL", "getReferrerUrl");
    }

    public void setReferrerUrl(URL referrerUrl) {
        this.setParameter(REFERRER_URL, referrerUrl);
    }

    public void setReferrerUrlWithString(String referrerUrl) {
        this.setParameter(REFERRER_URL, referrerUrl);
    }

    public PiwikDate getRequestDatetime() {
        return (PiwikDate)this.getParameter(REQUEST_DATETIME);
    }

    public void setRequestDatetime(PiwikDate datetime) {
        if (datetime != null && new Date().getTime() - datetime.getTime() > 14400000L && this.getAuthToken() == null) {
            throw new IllegalStateException("Because you are trying to set RequestDatetime for a time greater than 4 hours ago, AuthToken must be set first.");
        }
        this.setParameter(REQUEST_DATETIME, datetime);
    }

    public Boolean getRequired() {
        return this.getBooleanParameter(REQUIRED);
    }

    public void setRequired(Boolean required) {
        this.setBooleanParameter(REQUIRED, required);
    }

    public Boolean getResponseAsImage() {
        return this.getBooleanParameter(RESPONSE_AS_IMAGE);
    }

    public void setResponseAsImage(Boolean responseAsImage) {
        this.setBooleanParameter(RESPONSE_AS_IMAGE, responseAsImage);
    }

    public String getSearchCategory() {
        return (String)this.getParameter(SEARCH_CATEGORY);
    }

    public void setSearchCategory(String searchCategory) {
        if (searchCategory != null && this.getSearchQuery() == null) {
            throw new IllegalStateException("SearchQuery must be set before SearchCategory can be set.");
        }
        this.setParameter(SEARCH_CATEGORY, searchCategory);
    }

    public String getSearchQuery() {
        return (String)this.getParameter(SEARCH_QUERY);
    }

    public void setSearchQuery(String searchQuery) {
        this.setParameter(SEARCH_QUERY, searchQuery);
    }

    public Long getSearchResultsCount() {
        return (Long)this.getParameter(SEARCH_RESULTS_COUNT);
    }

    public void setSearchResultsCount(Long searchResultsCount) {
        if (searchResultsCount != null && this.getSearchQuery() == null) {
            throw new IllegalStateException("SearchQuery must be set before SearchResultsCount can be set.");
        }
        this.setParameter(SEARCH_RESULTS_COUNT, searchResultsCount);
    }

    public Integer getSiteId() {
        return (Integer)this.getParameter(SITE_ID);
    }

    public void setSiteId(Integer siteId) {
        this.setParameter(SITE_ID, siteId);
    }

    public Boolean getTrackBotRequests() {
        return this.getBooleanParameter(TRACK_BOT_REQUESTS);
    }

    public void setTrackBotRequests(Boolean trackBotRequests) {
        this.setBooleanParameter(TRACK_BOT_REQUESTS, trackBotRequests);
    }

    @Deprecated
    public String getUserCustomVariable(String key) {
        return this.getCustomVariable(VISIT_CUSTOM_VARIABLE, key);
    }

    public CustomVariable getVisitCustomVariable(int index) {
        return this.getCustomVariable(VISIT_CUSTOM_VARIABLE, index);
    }

    @Deprecated
    public void setUserCustomVariable(String key, String value) {
        if (value == null) {
            this.removeCustomVariable(VISIT_CUSTOM_VARIABLE, key);
        } else {
            this.setCustomVariable(VISIT_CUSTOM_VARIABLE, new CustomVariable(key, value), null);
        }
    }

    public void setVisitCustomVariable(CustomVariable customVariable, int index) {
        this.setCustomVariable(VISIT_CUSTOM_VARIABLE, customVariable, index);
    }

    public String getUserId() {
        return (String)this.getParameter(USER_ID);
    }

    public void setUserId(String userId) {
        this.setNonEmptyStringParameter(USER_ID, userId);
    }

    public String getVisitorCity() {
        return (String)this.getParameter(VISITOR_CITY);
    }

    public void setVisitorCity(String city) {
        if (city != null) {
            this.verifyAuthTokenSet();
        }
        this.setParameter(VISITOR_CITY, city);
    }

    public PiwikLocale getVisitorCountry() {
        return (PiwikLocale)this.getParameter(VISITOR_COUNTRY);
    }

    public void setVisitorCountry(PiwikLocale country) {
        if (country != null) {
            this.verifyAuthTokenSet();
        }
        this.setParameter(VISITOR_COUNTRY, country);
    }

    public String getVisitorCustomId() {
        return (String)this.getParameter(VISITOR_CUSTOM_ID);
    }

    public void setVisitorCustomId(String visitorCustomId) {
        if (visitorCustomId != null) {
            if (visitorCustomId.length() != 16) {
                throw new IllegalArgumentException(visitorCustomId + " is not " + 16 + " characters long.");
            }
            if (!visitorCustomId.matches("[0-9A-Fa-f]+")) {
                throw new IllegalArgumentException(visitorCustomId + " is not a hexadecimal string.");
            }
        }
        this.setParameter(VISITOR_CUSTOM_ID, visitorCustomId);
    }

    public Long getVisitorFirstVisitTimestamp() {
        return (Long)this.getParameter(VISITOR_FIRST_VISIT_TIMESTAMP);
    }

    public void setVisitorFirstVisitTimestamp(Long timestamp) {
        this.setParameter(VISITOR_FIRST_VISIT_TIMESTAMP, timestamp);
    }

    public String getVisitorId() {
        return (String)this.getParameter(VISITOR_ID);
    }

    public void setVisitorId(String visitorId) {
        if (visitorId != null) {
            if (visitorId.length() != 16) {
                throw new IllegalArgumentException(visitorId + " is not " + 16 + " characters long.");
            }
            if (!visitorId.matches("[0-9A-Fa-f]+")) {
                throw new IllegalArgumentException(visitorId + " is not a hexadecimal string.");
            }
        }
        this.setParameter(VISITOR_ID, visitorId);
    }

    public String getVisitorIp() {
        return (String)this.getParameter(VISITOR_IP);
    }

    public void setVisitorIp(String visitorIp) {
        if (visitorIp != null) {
            this.verifyAuthTokenSet();
        }
        this.setParameter(VISITOR_IP, visitorIp);
    }

    public Double getVisitorLatitude() {
        return (Double)this.getParameter(VISITOR_LATITUDE);
    }

    public void setVisitorLatitude(Double latitude) {
        if (latitude != null) {
            this.verifyAuthTokenSet();
        }
        this.setParameter(VISITOR_LATITUDE, latitude);
    }

    public Double getVisitorLongitude() {
        return (Double)this.getParameter(VISITOR_LONGITUDE);
    }

    public void setVisitorLongitude(Double longitude) {
        if (longitude != null) {
            this.verifyAuthTokenSet();
        }
        this.setParameter(VISITOR_LONGITUDE, longitude);
    }

    public Long getVisitorPreviousVisitTimestamp() {
        return (Long)this.getParameter(VISITOR_PREVIOUS_VISIT_TIMESTAMP);
    }

    public void setVisitorPreviousVisitTimestamp(Long timestamp) {
        this.setParameter(VISITOR_PREVIOUS_VISIT_TIMESTAMP, timestamp);
    }

    public String getVisitorRegion() {
        return (String)this.getParameter(VISITOR_REGION);
    }

    public void setVisitorRegion(String region) {
        if (region != null) {
            this.verifyAuthTokenSet();
        }
        this.setParameter(VISITOR_REGION, region);
    }

    public Integer getVisitorVisitCount() {
        return (Integer)this.getParameter(VISITOR_VISIT_COUNT);
    }

    public void setVisitorVisitCount(Integer visitorVisitCount) {
        this.setParameter(VISITOR_VISIT_COUNT, visitorVisitCount);
    }

    public String getQueryString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue().toString());
        }
        for (Map.Entry<String, Object> entry : this.customTrackingParameters.entrySet()) {
            for (Object o : (List)entry.getValue()) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(entry.getKey());
                sb.append("=");
                sb.append(o.toString());
            }
        }
        return sb.toString();
    }

    public String getUrlEncodedQueryString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.parameters.entrySet()) {
            if (sb.length() > 0) {
                sb.append("&");
            }
            try {
                StringBuilder sb2 = new StringBuilder();
                sb2.append(entry.getKey());
                sb2.append("=");
                sb2.append(URLEncoder.encode(entry.getValue().toString(), "UTF-8"));
                sb.append((CharSequence)sb2);
            }
            catch (UnsupportedEncodingException e) {
                System.err.println(e.getMessage());
            }
        }
        for (Map.Entry<String, Object> entry : this.customTrackingParameters.entrySet()) {
            for (Object o : (List)entry.getValue()) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                try {
                    StringBuilder sb2 = new StringBuilder();
                    sb2.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                    sb2.append("=");
                    sb2.append(URLEncoder.encode(o.toString(), "UTF-8"));
                    sb.append((CharSequence)sb2);
                }
                catch (UnsupportedEncodingException e) {
                    System.err.println(e.getMessage());
                }
            }
        }
        return sb.toString();
    }

    public static String getRandomHexString(int length) {
        byte[] bytes = new byte[length / 2];
        new Random().nextBytes(bytes);
        return DatatypeConverter.printHexBinary((byte[])bytes);
    }

    private Object getParameter(String key) {
        return this.parameters.get(key);
    }

    private void setParameter(String key, Object value) {
        if (value == null) {
            this.parameters.remove(key);
        } else {
            this.parameters.put(key, value);
        }
    }

    private String getNonEmptyStringParameter(String key) {
        return (String)this.parameters.get(key);
    }

    private void setNonEmptyStringParameter(String key, String value) {
        if (value == null) {
            this.parameters.remove(key);
        } else {
            if (value.length() == 0) {
                throw new IllegalArgumentException("Value cannot be empty.");
            }
            this.parameters.put(key, value);
        }
    }

    private Boolean getBooleanParameter(String key) {
        Integer i = (Integer)this.parameters.get(key);
        if (i == null) {
            return null;
        }
        return i.equals(1);
    }

    private void setBooleanParameter(String key, Boolean value) {
        if (value == null) {
            this.parameters.remove(key);
        } else if (value.booleanValue()) {
            this.parameters.put(key, 1);
        } else {
            this.parameters.put(key, 0);
        }
    }

    private CustomVariable getCustomVariable(String parameter, int index) {
        CustomVariableList cvl = (CustomVariableList)this.parameters.get(parameter);
        if (cvl == null) {
            return null;
        }
        return cvl.get(index);
    }

    private String getCustomVariable(String parameter, String key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null.");
        }
        CustomVariableList cvl = (CustomVariableList)this.parameters.get(parameter);
        if (cvl == null) {
            return null;
        }
        return cvl.get(key);
    }

    private void setCustomVariable(String parameter, CustomVariable customVariable, Integer index) {
        CustomVariableList cvl = (CustomVariableList)this.parameters.get(parameter);
        if (cvl == null) {
            cvl = new CustomVariableList();
            this.parameters.put(parameter, cvl);
        }
        if (customVariable == null) {
            cvl.remove(index);
            if (cvl.isEmpty()) {
                this.parameters.remove(parameter);
            }
        } else if (index == null) {
            cvl.add(customVariable);
        } else {
            cvl.add(customVariable, index);
        }
    }

    private void removeCustomVariable(String parameter, String key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null.");
        }
        CustomVariableList cvl = (CustomVariableList)this.parameters.get(parameter);
        if (cvl != null) {
            cvl.remove(key);
            if (cvl.isEmpty()) {
                this.parameters.remove(parameter);
            }
        }
    }

    private JsonValue getFromJsonArray(String key, int index) {
        PiwikJsonArray a = (PiwikJsonArray)this.parameters.get(key);
        if (a == null) {
            return null;
        }
        return a.get(index);
    }

    private void addToJsonArray(String key, JsonValue value) {
        if (value == null) {
            throw new NullPointerException("Value cannot be null.");
        }
        PiwikJsonArray a = (PiwikJsonArray)this.parameters.get(key);
        if (a == null) {
            a = new PiwikJsonArray();
            this.parameters.put(key, a);
        }
        a.add(value);
    }

    private void removeJsonArray(String key) {
        this.parameters.remove(key);
    }

    private URL returnAsUrl(String parameter, String name, String altMethod) {
        Object obj = this.getParameter(parameter);
        if (obj == null) {
            return null;
        }
        if (obj instanceof URL) {
            return (URL)obj;
        }
        throw new TypeConstraintException("The stored " + name + " is a String, not a URL.  Use \"" + altMethod + "\" instead.");
    }

    private String returnAsString(String parameter, String name, String altMethod) {
        Object obj = this.getParameter(parameter);
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        throw new TypeConstraintException("The stored " + name + " is a URL, not a String.  Use \"" + altMethod + "\" instead.");
    }
}

