/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.url.war.internal;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.lang.PreConditionException;
import org.ops4j.net.URLUtils;
import org.ops4j.pax.swissbox.bnd.BndUtils;
import org.ops4j.pax.url.war.internal.Configuration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractConnection
extends URLConnection {
    private final Configuration m_configuration;

    protected AbstractConnection(URL url, Configuration configuration) throws MalformedURLException {
        super(url);
        NullArgumentException.validateNotNull(url, "URL");
        NullArgumentException.validateNotNull(configuration, "Configuration");
        String path = url.getPath();
        if (path == null || path.trim().length() == 0) {
            throw new MalformedURLException("Path cannot empty");
        }
        this.m_configuration = configuration;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        Properties instructions = this.getInstructions();
        PreConditionException.validateNotNull(instructions, "Instructions");
        String warUri = instructions.getProperty("WAR-URL");
        if (warUri == null || warUri.trim().length() == 0) {
            throw new IOException("Instructions file must contain a property named WAR-URL");
        }
        AbstractConnection.generateClassPathInstruction(instructions);
        return BndUtils.createBundle(URLUtils.prepareInputStream(new URL(warUri), this.m_configuration.getCertificateCheck()), instructions, warUri);
    }

    protected abstract Properties getInstructions() throws IOException;

    protected Configuration getConfiguration() {
        return this.m_configuration;
    }

    private static void generateClassPathInstruction(Properties instructions) throws IOException {
        ArrayList<String> bundleClassPath = new ArrayList<String>();
        bundleClassPath.addAll(AbstractConnection.toList(instructions.getProperty("Bundle-ClassPath"), ","));
        bundleClassPath.addAll(AbstractConnection.extractJarListFromWar(instructions.getProperty("WAR-URL")));
        if (!bundleClassPath.contains("WEB-INF/classes")) {
            bundleClassPath.add(0, "WEB-INF/classes");
        }
        if (!bundleClassPath.contains(".")) {
            bundleClassPath.add(0, ".");
        }
        instructions.setProperty("Bundle-ClassPath", AbstractConnection.join(bundleClassPath, ","));
    }

    @Override
    public void connect() {
    }

    private static List<String> extractJarListFromWar(String warUri) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        ZipFile jarFile = null;
        try {
            JarURLConnection conn = (JarURLConnection)new URL("jar:" + warUri + "!/").openConnection();
            conn.setUseCaches(false);
            jarFile = conn.getJarFile();
            Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.startsWith("WEB-INF/lib/") || !name.endsWith(".jar")) continue;
                list.add(name);
            }
        }
        catch (ClassCastException e) {
            throw new IOException("Provided url [" + warUri + "] does not refer a valid war file");
        }
        finally {
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ignore) {}
            }
        }
        return list;
    }

    protected static List<String> toList(String separatedString, String delimiter) {
        ArrayList<String> list = new ArrayList<String>();
        if (separatedString != null) {
            list.addAll(Arrays.asList(separatedString.split(delimiter)));
        }
        return list;
    }

    protected static String join(Collection<String> strings, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        Iterator<String> iter = strings.iterator();
        while (iter.hasNext()) {
            buffer.append(iter.next());
            if (!iter.hasNext()) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }
}

