/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.scanner.common;

import java.util.Dictionary;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.scanner.Scanner;
import org.ops4j.pax.swissbox.property.BundleContextPropertyResolver;
import org.ops4j.util.property.DictionaryPropertyResolver;
import org.ops4j.util.property.PropertyResolver;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScannerActivator<T extends Scanner>
implements BundleActivator {
    private static final Log LOG = LogFactory.getLog(AbstractScannerActivator.class);
    private BundleContext m_bundleContext;
    private T m_scanner;
    private ServiceRegistration m_scannerReg;
    private ServiceRegistration m_managedServiceReg;

    @Override
    public void start(BundleContext bundleContext) throws Exception {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        this.m_bundleContext = bundleContext;
        this.registerScanner();
        this.registerManagedService();
        LOG.debug((Object)("Scanner for schema [" + this.getSchema() + "] started"));
    }

    @Override
    public void stop(BundleContext bundleContext) {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        if (this.m_scannerReg != null) {
            this.m_scannerReg.unregister();
        }
        if (this.m_managedServiceReg != null) {
            this.m_managedServiceReg.unregister();
        }
        this.m_bundleContext = null;
        LOG.debug((Object)("Scanner for schema [" + this.getSchema() + "] stopped"));
    }

    private void registerScanner() {
        this.m_scanner = this.createScanner(this.m_bundleContext);
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("provision.schema", this.getSchema());
        this.m_scannerReg = this.m_bundleContext.registerService(Scanner.class.getName(), this.m_scanner, props);
    }

    private void registerManagedService() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.pid", this.getPID());
        this.m_managedServiceReg = this.m_bundleContext.registerService(ManagedService.class.getName(), (Object)new ManagedService(){

            public void updated(Dictionary config) throws ConfigurationException {
                if (config == null) {
                    AbstractScannerActivator.this.setResolver(new BundleContextPropertyResolver(AbstractScannerActivator.this.m_bundleContext));
                } else {
                    AbstractScannerActivator.this.setResolver(new DictionaryPropertyResolver(config, new BundleContextPropertyResolver(AbstractScannerActivator.this.m_bundleContext)));
                }
            }
        }, props);
    }

    protected T getScanner() {
        return this.m_scanner;
    }

    protected abstract T createScanner(BundleContext var1);

    protected abstract String getPID();

    protected abstract String getSchema();

    protected abstract void setResolver(PropertyResolver var1);
}

