/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.runner.platform;

import java.net.URL;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.runner.platform.SystemFileReference;

public class SystemFileReferenceBean
implements SystemFileReference {
    private String m_name;
    private URL m_url;
    private Boolean m_prepend;

    public SystemFileReferenceBean(URL url) {
        this(null, url, false);
    }

    public SystemFileReferenceBean(String name, URL url) {
        this(name, url, false);
    }

    public SystemFileReferenceBean(String name, URL url, Boolean prepend) {
        this.setURL(url);
        this.setName(name);
        this.m_prepend = prepend;
    }

    public String getName() {
        return this.m_name;
    }

    public URL getURL() {
        return this.m_url;
    }

    public Boolean shouldPrepend() {
        return this.m_prepend;
    }

    public void setName(String name) {
        this.m_name = name;
        if (this.m_name == null) {
            this.m_name = this.m_url.toString();
        }
    }

    public void setURL(URL url) {
        NullArgumentException.validateNotNull(url, "URL");
        this.m_url = url;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof SystemFileReference)) {
            return false;
        }
        SystemFileReference another = (SystemFileReference)object;
        return this.m_name.equals(another.getName()) && this.m_url.equals(another.getURL());
    }

    public String toString() {
        return "{" + "name=" + this.getName() + ",url=" + this.getURL() + ",shouldPrepend=" + this.shouldPrepend() + "}";
    }
}

