/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.obr;

import java.net.URI;
import java.util.List;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.obr.ObrCommandSupport;
import org.apache.karaf.shell.obr.util.FileUtil;

@Command(scope="obr", name="source", description="Downloads the sources for an OBR bundle.")
public class SourceCommand
extends ObrCommandSupport {
    @Option(name="-x", aliases={}, description="Extract the archive", required=false, multiValued=false)
    boolean extract;
    @Argument(index=0, name="folder", description="Local folder for storing sources", required=true, multiValued=false)
    String localDir;
    @Argument(index=1, name="bundles", description="List of bundles to download the sources for", required=true, multiValued=true)
    List<String> bundles;

    protected void doExecute(RepositoryAdmin admin) throws Exception {
        for (String bundle : this.bundles) {
            String[] target = this.getTarget(bundle);
            Resource resource = this.selectNewestVersion(this.searchRepository(admin, target[0], target[1]));
            if (resource == null) {
                System.err.println("Unknown bundle and/or version: " + target[0]);
                continue;
            }
            URI srcURL = (URI)resource.getProperties().get("source");
            if (srcURL != null) {
                FileUtil.downloadSource(System.out, System.err, srcURL.toURL(), this.localDir, this.extract);
                continue;
            }
            System.err.println("Missing source URL: " + target[0]);
        }
    }
}

