/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import org.apache.felix.framework.Felix;
import org.apache.felix.framework.FelixBundle;
import org.apache.felix.framework.URLHandlers;
import org.apache.felix.framework.util.Util;
import org.apache.felix.moduleloader.IModule;

class URLHandlersBundleURLConnection
extends URLConnection {
    private Felix m_framework;
    private int m_contentLength;
    private long m_contentTime;
    private String m_contentType;
    private InputStream m_is;

    public URLHandlersBundleURLConnection(URL url, Felix framework) throws IOException {
        super(url);
        this.m_framework = framework;
        if (this.m_framework == null) {
            this.m_framework = URLHandlers.getFrameworkFromContext();
        }
        if (this.m_framework == null) {
            throw new IOException("Unable to find framework for URL: " + url);
        }
        long bundleId = Util.getBundleIdFromModuleId(url.getHost());
        FelixBundle bundle = (FelixBundle)this.m_framework.getBundle(bundleId);
        if (bundle == null) {
            throw new IOException("No bundle associated with resource: " + url);
        }
        int revision = Util.getModuleRevisionFromModuleId(url.getHost());
        IModule[] modules = bundle.getInfo().getModules();
        if (modules == null || revision < 0 || revision >= modules.length || !modules[revision].getContentLoader().hasInputStream(url.getPort(), url.getPath())) {
            throw new IOException("Resource does not exist: " + url);
        }
    }

    public void connect() throws IOException {
        if (!this.connected) {
            long bundleId = Util.getBundleIdFromModuleId(this.url.getHost());
            FelixBundle bundle = (FelixBundle)this.m_framework.getBundle(bundleId);
            if (bundle == null) {
                throw new IOException("No bundle associated with resource: " + this.url);
            }
            int revision = Util.getModuleRevisionFromModuleId(this.url.getHost());
            IModule[] modules = bundle.getInfo().getModules();
            if (modules == null || revision < 0 || revision >= modules.length) {
                throw new IOException("Resource does not exist: " + this.url);
            }
            this.m_is = bundle.getInfo().getModules()[revision].getContentLoader().getInputStream(this.url.getPort(), this.url.getPath());
            this.m_contentLength = this.m_is == null ? 0 : this.m_is.available();
            this.m_contentTime = 0L;
            this.m_contentType = URLConnection.guessContentTypeFromName(this.url.getFile());
            this.connected = true;
        }
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        return this.m_is;
    }

    public int getContentLength() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException ex) {
                return -1;
            }
        }
        return this.m_contentLength;
    }

    public long getLastModified() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException ex) {
                return 0L;
            }
        }
        if (this.m_contentTime != -1L) {
            return this.m_contentTime;
        }
        return 0L;
    }

    public String getContentType() {
        if (!this.connected) {
            try {
                this.connect();
            }
            catch (IOException ex) {
                return null;
            }
        }
        return this.m_contentType;
    }

    public Permission getPermission() {
        return null;
    }
}

