/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.io.CharArrayReader;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Enumeration;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.util.StringMap;
import org.apache.felix.framework.util.ldap.AttributeNotFoundException;
import org.apache.felix.framework.util.ldap.EvaluationException;
import org.apache.felix.framework.util.ldap.Evaluator;
import org.apache.felix.framework.util.ldap.LdapLexer;
import org.apache.felix.framework.util.ldap.Mapper;
import org.apache.felix.framework.util.ldap.ParseException;
import org.apache.felix.framework.util.ldap.Parser;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class FilterImpl
implements Filter {
    private Logger m_logger = null;
    private String m_toString = null;
    private Evaluator m_evaluator = null;
    private SimpleMapper m_mapper = null;

    public FilterImpl(String expr) throws InvalidSyntaxException {
        this(null, expr);
    }

    public FilterImpl(Logger logger, String expr) throws InvalidSyntaxException {
        this.m_logger = logger;
        if (expr == null) {
            throw new InvalidSyntaxException("Filter cannot be null", null);
        }
        if (expr != null) {
            CharArrayReader car = new CharArrayReader(expr.toCharArray());
            LdapLexer lexer = new LdapLexer(car);
            Parser parser = new Parser(lexer);
            try {
                if (!parser.start()) {
                    throw new InvalidSyntaxException("Failed to parse LDAP query.", expr);
                }
            }
            catch (ParseException ex) {
                throw new InvalidSyntaxException(ex.getMessage(), expr);
            }
            catch (IOException ex) {
                throw new InvalidSyntaxException(ex.getMessage(), expr);
            }
            this.m_evaluator = new Evaluator(parser.getProgram());
            this.m_mapper = new SimpleMapper();
        }
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Filter) {
            return this.toString().equals(o.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean match(Dictionary dict) throws IllegalArgumentException {
        try {
            this.m_mapper.setSource(dict, false);
            boolean result = this.m_evaluator.evaluate(this.m_mapper);
            this.m_mapper.setSource(null, false);
            return result;
        }
        catch (AttributeNotFoundException ex) {
            this.log(4, "FilterImpl: Attribute not found.", ex);
        }
        catch (EvaluationException ex) {
            this.log(1, "FilterImpl: " + this.toString(), ex);
        }
        return false;
    }

    public boolean match(ServiceReference ref) {
        try {
            this.m_mapper.setSource(ref);
            boolean result = this.m_evaluator.evaluate(this.m_mapper);
            this.m_mapper.setSource(null);
            return result;
        }
        catch (AttributeNotFoundException ex) {
            this.log(4, "FilterImpl: Attribute not found.", ex);
        }
        catch (EvaluationException ex) {
            this.log(1, "FilterImpl: " + this.toString(), ex);
        }
        return false;
    }

    public boolean matchCase(Dictionary dict) {
        try {
            this.m_mapper.setSource(dict, true);
            boolean result = this.m_evaluator.evaluate(this.m_mapper);
            this.m_mapper.setSource(null, true);
            return result;
        }
        catch (AttributeNotFoundException ex) {
            this.log(4, "FilterImpl: Attribute not found.", ex);
        }
        catch (EvaluationException ex) {
            this.log(1, "FilterImpl: " + this.toString(), ex);
        }
        return false;
    }

    public String toString() {
        if (this.m_toString == null) {
            this.m_toString = this.m_evaluator.toStringInfix();
        }
        return this.m_toString;
    }

    private void log(int flag, String msg, Throwable th) {
        if (this.m_logger == null) {
            System.out.println(msg + ": " + th);
        } else {
            this.m_logger.log(flag, msg, th);
        }
    }

    static class SimpleMapper
    implements Mapper {
        private ServiceReference m_ref = null;
        private StringMap m_map = null;

        SimpleMapper() {
        }

        public void setSource(ServiceReference ref) {
            this.m_ref = ref;
            this.m_map = null;
        }

        public void setSource(Dictionary dict, boolean caseSensitive) {
            if (this.m_map == null) {
                this.m_map = new StringMap();
            } else {
                this.m_map.clear();
            }
            this.m_map.setCaseSensitive(caseSensitive);
            if (dict != null) {
                Enumeration keys = dict.keys();
                while (keys.hasMoreElements()) {
                    Object key = keys.nextElement();
                    if (this.m_map.get(key) == null) {
                        this.m_map.put(key, dict.get(key));
                        continue;
                    }
                    throw new IllegalArgumentException("Duplicate attribute: " + key.toString());
                }
            }
            this.m_ref = null;
        }

        public Object lookup(String name) {
            if (this.m_map == null) {
                return this.m_ref.getProperty(name);
            }
            return this.m_map.get(name);
        }
    }
}

