/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.make;

import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Verifier;
import aQute.libg.version.Version;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ComponentDef
extends Processor {
    String name;
    String implementation;
    String[] provides;
    String activate;
    String deactivate;
    String modified;
    String factory;
    Boolean enabled;
    Boolean immediate;
    String configurationPolicy;
    List<Reference> references = new ArrayList<Reference>();
    Version version;
    Boolean serviceFactory;
    Map<String, Object> properties;

    public Reference newReference(String name) {
        Reference ref2;
        for (Reference ref2 : this.references) {
            if (!ref2.name.equals(name)) continue;
            return ref2;
        }
        ref2 = new Reference();
        ref2.name = name;
        this.references.add(ref2);
        return ref2;
    }

    public void append(Appendable a) throws IOException {
        String namespace = this.getNamespace();
        a.append("<?xml version='1.0' encoding='utf-8'?>\n");
        a.append("<component name='" + this.name + "'");
        this.doAttribute(a, "\n   xmlns", namespace, new String[0]);
        this.doAttribute(a, "factory", this.factory, new String[0]);
        this.doAttribute(a, "immediate", this.immediate, "false", "true");
        this.doAttribute(a, "enabled", this.enabled, "true", "false");
        if (this.configurationPolicy != null && !"optional".equals(this.configurationPolicy)) {
            this.doAttribute(a, "configuration-policy", this.configurationPolicy, "optional", "require", "ignore");
        }
        this.doAttribute(a, "activate", this.activate, "<<identifier>>");
        this.doAttribute(a, "deactivate", this.deactivate, "<<identifier>>");
        this.doAttribute(a, "modified", this.modified, "<<identifier>>");
        a.append(">\n");
        if (this.implementation == null) {
            this.error("No Implementation specified in component " + this.name, new Object[0]);
        } else {
            a.append("  <implementation");
            this.doAttribute(a, "class", this.implementation, new String[0]);
            a.append("/>\n");
        }
        if (this.provides != null) {
            a.append("  <service");
            this.doAttribute(a, "servicefactory", this.serviceFactory, "true", "false");
            a.append(">\n");
            String[] stringArray = this.provides;
            int n = this.provides.length;
            int n2 = 0;
            while (n2 < n) {
                String provide = stringArray[n2];
                a.append("    <provide");
                this.doAttribute(a, "interface", provide, new String[0]);
                a.append(">\n");
                ++n2;
            }
            a.append("  </service>\n");
        }
        if (this.properties != null) {
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                this.property(a, entry.getKey(), entry.getValue());
            }
        }
        for (Reference ref : this.references) {
            a.append("  <reference");
            this.doAttribute(a, "name", ref.name, new String[0]);
            this.doAttribute(a, "interface", ref.service, new String[0]);
            if (ref.optional == null) {
                ref.optional = false;
            }
            if (ref.multiple == null) {
                ref.multiple = false;
            }
            String cardinality = ref.optional != false ? "0" : "1";
            cardinality = String.valueOf(cardinality) + "..";
            if (!(cardinality = String.valueOf(cardinality) + (ref.multiple != false ? "n" : "1")).equals("1..1")) {
                this.doAttribute(a, "cardinality", cardinality, new String[0]);
            }
            this.doAttribute(a, "bind", ref.bind, "<<identifier>>");
            this.doAttribute(a, "unbind", ref.unbind, "<<identifier>>");
            if (ref.dynamic != null && ref.dynamic.booleanValue()) {
                this.doAttribute(a, "policy", "dynamic", new String[0]);
            }
            if (ref.target != null) {
                this.doAttribute(a, "target", ref.target.trim(), new String[0]);
            }
            a.append("/>\n");
        }
        a.append("</component>\n");
    }

    private void property(Appendable a, String key, Object value) throws IOException {
        a.append("<property");
        this.doAttribute(a, "name", key, new String[0]);
        boolean array = false;
        Class<?> type = value.getClass();
        if (type.isArray()) {
            type = type.getComponentType();
            array = true;
        }
        if (type != String.class) {
            this.doAttribute(a, "type", type.getName(), new String[0]);
        }
        if (array) {
            Object[] parts;
            a.append(">\n");
            Object[] objectArray = parts = (Object[])value;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                Object part = objectArray[n2];
                a.append(part.toString());
                a.append("\n");
                ++n2;
            }
            a.append("</property>");
        } else {
            this.doAttribute(a, "value", value, new String[0]);
            a.append("/>\n");
        }
    }

    private void doAttribute(Appendable pw, String name, Object value, String ... matches) throws IOException {
        if (value != null) {
            String v = value.toString();
            if (matches.length != 0) {
                if (matches.length == 1 && matches[0].equals("<<identifier>>")) {
                    if (!Verifier.isIdentifier(v)) {
                        this.error("Component attribute %s has value %s but is not a Java identifier", name, v);
                    }
                } else if (!Verifier.isMember(v, matches)) {
                    this.error("Component attribute %s has value %s but is not a member of %s", name, value, Arrays.toString(matches));
                }
            }
            pw.append(" ");
            pw.append(name);
            pw.append("='");
            pw.append(v);
            pw.append("'");
        }
    }

    private String getNamespace() {
        if (this.version != null) {
            try {
                return "http://www.osgi.org/xmlns/scr/v" + this.version;
            }
            catch (Exception e) {
                this.error("version: specified on component header but not a valid version: " + this.version, new Object[0]);
                return null;
            }
        }
        if (this.modified != null || this.configurationPolicy != null) {
            this.version = new Version("1.1.0");
            return "http://www.osgi.org/xmlns/scr/v1.1.0";
        }
        return null;
    }

    class Reference {
        Boolean multiple;
        Boolean optional;
        Boolean dynamic;
        String target;
        String name;
        String bind;
        String unbind;
        String service;

        Reference() {
        }
    }
}

