/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.scanner.internal;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.scanner.InstallableBundle;
import org.ops4j.pax.scanner.ScannedBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.service.startlevel.StartLevel;

public class InstallableBundleImpl
implements InstallableBundle {
    private final ScannedBundle m_scannedBundle;
    private Bundle m_bundle;
    private final BundleContext m_bundleContext;
    private final StartLevel m_startLevelService;
    private State m_state;

    public InstallableBundleImpl(BundleContext bundleContext, ScannedBundle scannedBundle) {
        this(bundleContext, scannedBundle, null);
    }

    public InstallableBundleImpl(BundleContext bundleContext, ScannedBundle scannedBundle, StartLevel startLevelService) {
        NullArgumentException.validateNotNull(bundleContext, "Bundle context");
        NullArgumentException.validateNotNull(scannedBundle, "Scanned bundle");
        this.m_bundleContext = bundleContext;
        this.m_scannedBundle = scannedBundle;
        this.m_startLevelService = startLevelService;
        this.m_state = new NotInstalledState();
    }

    public Bundle getBundle() {
        return this.m_bundle;
    }

    public InstallableBundle install() throws BundleException {
        this.m_state.install();
        return this;
    }

    public InstallableBundle startIfNecessary() throws BundleException {
        if (this.m_scannedBundle.shouldStart().booleanValue()) {
            this.start();
        }
        return this;
    }

    public InstallableBundle start() throws BundleException {
        this.m_state.start();
        return this;
    }

    private void doInstall() throws BundleException {
        Integer startLevel;
        String location = this.m_scannedBundle.getLocation();
        if (location == null) {
            throw new BundleException("The scanned bundle has no location");
        }
        long currentTime = System.currentTimeMillis();
        this.m_bundle = this.m_bundleContext.installBundle(location);
        Boolean shouldUpdate = this.m_scannedBundle.shouldUpdate();
        if (shouldUpdate != null && shouldUpdate.booleanValue() && this.m_bundle.getLastModified() < currentTime) {
            this.m_bundle.update();
        }
        if (this.m_bundle == null) {
            throw new BundleException("The bundle could not be installed due to unknown reason");
        }
        this.m_state = new InstalledState();
        if (this.m_startLevelService != null && (startLevel = this.m_scannedBundle.getStartLevel()) != null) {
            this.m_startLevelService.setBundleStartLevel(this.m_bundle, startLevel);
        }
        this.startIfNecessary();
    }

    private void doStart() throws BundleException {
        if (this.m_bundle != null) {
            this.m_bundle.start();
        }
        this.m_state = new StartedState();
    }

    private class StartedState
    extends State {
        private StartedState() {
        }
    }

    private class InstalledState
    extends State {
        private InstalledState() {
        }

        void start() throws BundleException {
            InstallableBundleImpl.this.doStart();
        }
    }

    private class NotInstalledState
    extends State {
        private NotInstalledState() {
        }

        void install() throws BundleException {
            InstallableBundleImpl.this.doInstall();
        }

        void start() throws BundleException {
            this.install();
            InstallableBundleImpl.this.doStart();
        }
    }

    private class State {
        private State() {
        }

        void install() throws BundleException {
        }

        void start() throws BundleException {
        }
    }
}

