/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.scanner.composite.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.net.URLUtils;
import org.ops4j.pax.scanner.MalformedSpecificationException;
import org.ops4j.pax.scanner.ProvisionService;
import org.ops4j.pax.scanner.ProvisionSpec;
import org.ops4j.pax.scanner.ScannedBundle;
import org.ops4j.pax.scanner.ScannedBundleBean;
import org.ops4j.pax.scanner.Scanner;
import org.ops4j.pax.scanner.ScannerException;
import org.ops4j.pax.scanner.common.ScannerConfiguration;
import org.ops4j.pax.scanner.common.ScannerConfigurationImpl;
import org.ops4j.pax.scanner.common.SystemPropertyUtils;
import org.ops4j.util.property.PropertyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeScanner
implements Scanner {
    private static final Log LOGGER = LogFactory.getLog(CompositeScanner.class);
    private static final String COMMENT_SIGN = "#";
    private static final String PROPERTY_PREFIX = "-D";
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("-D(.*)=(.*)");
    private PropertyResolver m_propertyResolver;
    private final ProvisionService m_provisionService;

    public CompositeScanner(PropertyResolver propertyResolver, ProvisionService provisionService) {
        NullArgumentException.validateNotNull(propertyResolver, "PropertyResolver");
        NullArgumentException.validateNotNull(provisionService, "Provision Service");
        this.m_propertyResolver = propertyResolver;
        this.m_provisionService = provisionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ScannedBundle> scan(ProvisionSpec provisionSpec) throws MalformedSpecificationException, ScannerException {
        NullArgumentException.validateNotNull(provisionSpec, "Provision spec");
        LOGGER.debug((Object)("Scanning [" + provisionSpec.getPath() + "]"));
        ArrayList<ScannedBundle> scannedBundles = new ArrayList<ScannedBundle>();
        ScannerConfiguration config = this.createConfiguration();
        BufferedReader bufferedReader = null;
        try {
            try {
                String line;
                bufferedReader = new BufferedReader(new InputStreamReader(URLUtils.prepareInputStream(provisionSpec.getPathAsCachedUrl(), config.getCertificateCheck() == false)));
                Integer defaultStartLevel = provisionSpec.getStartLevel();
                Boolean defaultStart = provisionSpec.shouldStart();
                Boolean defaultUpdate = provisionSpec.shouldUpdate();
                Properties localPlaceholders = new Properties();
                String relativeUrlProp = new URL(provisionSpec.getPathAsUrl(), ".").toExternalForm();
                if (relativeUrlProp.endsWith("/")) {
                    relativeUrlProp = relativeUrlProp.substring(0, relativeUrlProp.length() - 1);
                }
                localPlaceholders.setProperty("this.relative", relativeUrlProp);
                String absoluteUrlProp = new URL(provisionSpec.getPathAsUrl(), "/").toExternalForm();
                if (absoluteUrlProp.endsWith("/")) {
                    absoluteUrlProp = absoluteUrlProp.substring(0, absoluteUrlProp.length() - 1);
                }
                localPlaceholders.setProperty("this.absolute", absoluteUrlProp);
                while ((line = bufferedReader.readLine()) != null) {
                    List<ScannedBundle> scanned;
                    if ("".equals(line.trim()) || line.trim().startsWith(COMMENT_SIGN)) continue;
                    if (line.trim().startsWith(PROPERTY_PREFIX)) {
                        Matcher matcher = PROPERTY_PATTERN.matcher(line.trim());
                        if (!matcher.matches() || matcher.groupCount() != 2) {
                            throw new ScannerException("Invalid property: " + line);
                        }
                        String value = matcher.group(2);
                        value = SystemPropertyUtils.resolvePlaceholders(value, localPlaceholders);
                        System.setProperty(matcher.group(1), value);
                        continue;
                    }
                    ProvisionSpec spec = new ProvisionSpec(line = SystemPropertyUtils.resolvePlaceholders(line, localPlaceholders));
                    if (!spec.isPathValidUrl()) {
                        line = new ProvisionSpec(spec.getScheme(), new URL(provisionSpec.getPathAsUrl(), spec.getPath()).toExternalForm(), spec.getFilter(), spec.getStartLevel(), spec.shouldStart(), spec.shouldUpdate()).toExternalForm();
                    }
                    if ((scanned = this.m_provisionService.scan(line)) == null || scanned.size() <= 0) continue;
                    for (ScannedBundle scannedBundle : scanned) {
                        scannedBundles.add(new ScannedBundleBean(scannedBundle.getLocation(), defaultStartLevel == null ? scannedBundle.getStartLevel() : defaultStartLevel, defaultStart == null ? scannedBundle.shouldStart() : defaultStart, defaultUpdate == null ? scannedBundle.shouldUpdate() : defaultUpdate));
                    }
                }
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        }
        catch (IOException e) {
            throw new ScannerException("Could not parse the provision file", e);
        }
        return scannedBundles;
    }

    public void setResolver(PropertyResolver propertyResolver) {
        NullArgumentException.validateNotNull(propertyResolver, "PropertyResolver");
        this.m_propertyResolver = propertyResolver;
    }

    ScannerConfiguration createConfiguration() {
        return new ScannerConfigurationImpl(this.m_propertyResolver, "org.ops4j.pax.scanner.composite");
    }
}

