/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io.formats;

import org.openscience.cdk.io.formats.IChemFormatMatcher;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.SimpleChemFormatMatcher;

public class Mol2Format
extends SimpleChemFormatMatcher
implements IChemFormatMatcher {
    private static IResourceFormat myself = null;

    public static IResourceFormat getInstance() {
        if (myself == null) {
            myself = new Mol2Format();
        }
        return myself;
    }

    public String getFormatName() {
        return "Mol2 (Sybyl)";
    }

    public String getMIMEType() {
        return "chemical/x-mol2";
    }

    public String getPreferredNameExtension() {
        return this.getNameExtensions()[0];
    }

    public String[] getNameExtensions() {
        return new String[]{"mol2"};
    }

    public String getReaderClassName() {
        return "org.openscience.cdk.io.Mol2Reader";
    }

    public String getWriterClassName() {
        return "org.openscience.cdk.io.Mol2Writer";
    }

    @Override
    public boolean matches(int lineNumber, String line) {
        return line.indexOf("<TRIPOS>") >= 0;
    }

    public boolean isXMLBased() {
        return false;
    }

    public int getSupportedDataFeatures() {
        return this.getRequiredDataFeatures() | 1 | 2 | 0x200;
    }

    public int getRequiredDataFeatures() {
        return 8;
    }
}

