/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.depict;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.InvalidSmilesException;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.isomorphism.matchers.Expr;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.QueryAtom;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.QueryBond;
import org.openscience.cdk.sgroup.Sgroup;
import org.openscience.cdk.sgroup.SgroupType;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.smiles.SmilesParser;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class Abbreviations
implements Iterable<String> {
    private static final int MAX_FRAG = 50;
    private static final String INTERPUNCT = "\u00b7";
    private final Map<String, String> connectedAbbreviations = new LinkedHashMap<String, String>();
    private final Map<String, String> disconnectedAbbreviations = new LinkedHashMap<String, String>();
    private final Set<String> labels = new LinkedHashSet<String>();
    private final Set<String> disabled = new HashSet<String>();
    private final SmilesGenerator usmigen = SmilesGenerator.unique();
    private final SmilesParser smipar = new SmilesParser(SilentChemObjectBuilder.getInstance());
    private boolean contractOnHetero = true;
    private boolean contractSingleFragments = false;
    private static final String CUT_BOND = "cutbond";

    @Override
    public Iterator<String> iterator() {
        return Collections.unmodifiableSet(this.labels).iterator();
    }

    public boolean isEnabled(String label) {
        return this.labels.contains(label) && !this.disabled.contains(label);
    }

    public boolean setEnabled(String label, boolean enabled) {
        return enabled ? this.labels.contains(label) && this.disabled.remove(label) : this.labels.contains(label) && this.disabled.add(label);
    }

    public void setContractOnHetero(boolean val) {
        this.contractOnHetero = val;
    }

    public void setContractToSingleLabel(boolean val) {
        this.contractSingleFragments = val;
    }

    private static Set<IBond> findCutBonds(IAtomContainer mol, GraphUtil.EdgeToBondMap bmap, int[][] adjlist) {
        HashSet<IBond> cuts = new HashSet<IBond>();
        int numAtoms = mol.getAtomCount();
        for (int i = 0; i < numAtoms; ++i) {
            IAtom atom = mol.getAtom(i);
            int deg = adjlist[i].length;
            int elem = atom.getAtomicNumber();
            if (elem == 6 && deg <= 2 || deg < 2) continue;
            for (int w : adjlist[i]) {
                IBond bond = bmap.get(i, w);
                if (adjlist[w].length < 2 || bond.isInRing()) continue;
                cuts.add(bond);
            }
        }
        return cuts;
    }

    private static List<IAtomContainer> makeCut(IBond cut, IAtomContainer mol, Map<IAtom, Integer> idx, int[][] adjlist) {
        IAtom nbr;
        IAtom atom;
        IAtom beg = cut.getBegin();
        IAtom end = cut.getEnd();
        LinkedHashSet<IAtom> bvisit = new LinkedHashSet<IAtom>();
        LinkedHashSet<IAtom> evisit = new LinkedHashSet<IAtom>();
        ArrayDeque<IAtom> queue = new ArrayDeque<IAtom>();
        bvisit.add(beg);
        evisit.add(end);
        queue.add(beg);
        bvisit.add(end);
        while (!queue.isEmpty()) {
            atom = (IAtom)queue.poll();
            bvisit.add(atom);
            for (int w : adjlist[idx.get(atom)]) {
                nbr = mol.getAtom(w);
                if (bvisit.contains(nbr)) continue;
                queue.add(nbr);
            }
        }
        bvisit.remove(end);
        queue.add(end);
        evisit.add(beg);
        while (!queue.isEmpty()) {
            atom = (IAtom)queue.poll();
            evisit.add(atom);
            for (int w : adjlist[idx.get(atom)]) {
                nbr = mol.getAtom(w);
                if (evisit.contains(nbr)) continue;
                queue.add(nbr);
            }
        }
        evisit.remove(beg);
        IChemObjectBuilder bldr = mol.getBuilder();
        IAtomContainer bfrag = (IAtomContainer)bldr.newInstance(IAtomContainer.class, new Object[0]);
        IAtomContainer efrag = (IAtomContainer)bldr.newInstance(IAtomContainer.class, new Object[0]);
        int diff = bvisit.size() - evisit.size();
        if (diff < -10) {
            evisit.clear();
        } else if (diff > 10) {
            bvisit.clear();
        }
        if (!bvisit.isEmpty()) {
            bfrag.addAtom((IAtom)bldr.newInstance(IPseudoAtom.class, new Object[0]));
            for (IAtom atom2 : bvisit) {
                bfrag.addAtom(atom2);
            }
            bfrag.addBond(0, 1, cut.getOrder());
            bfrag.getBond(0).setProperty((Object)CUT_BOND, (Object)cut);
        }
        if (!evisit.isEmpty()) {
            efrag.addAtom((IAtom)bldr.newInstance(IPseudoAtom.class, new Object[0]));
            for (IAtom atom2 : evisit) {
                efrag.addAtom(atom2);
            }
            efrag.addBond(0, 1, cut.getOrder());
            efrag.getBond(0).setProperty((Object)CUT_BOND, (Object)cut);
        }
        for (IBond bond : mol.bonds()) {
            IAtom a1 = bond.getBegin();
            IAtom a2 = bond.getEnd();
            if (bvisit.contains(a1) && bvisit.contains(a2)) {
                bfrag.addBond(bond);
                continue;
            }
            if (!evisit.contains(a1) || !evisit.contains(a2)) continue;
            efrag.addBond(bond);
        }
        ArrayList<IAtomContainer> res = new ArrayList<IAtomContainer>();
        if (!bfrag.isEmpty()) {
            res.add(bfrag);
        }
        if (!efrag.isEmpty()) {
            res.add(efrag);
        }
        return res;
    }

    private static List<IAtomContainer> generateFragments(IAtomContainer mol) {
        GraphUtil.EdgeToBondMap bmap = GraphUtil.EdgeToBondMap.withSpaceFor((IAtomContainer)mol);
        int[][] adjlist = GraphUtil.toAdjList((IAtomContainer)mol, (GraphUtil.EdgeToBondMap)bmap);
        Cycles.markRingAtomsAndBonds((IAtomContainer)mol, (int[][])adjlist, (GraphUtil.EdgeToBondMap)bmap);
        Set<IBond> cuts = Abbreviations.findCutBonds(mol, bmap, adjlist);
        HashMap<IAtom, Integer> atmidx = new HashMap<IAtom, Integer>();
        for (IAtom atom : mol.atoms()) {
            atmidx.put(atom, atmidx.size());
        }
        ArrayList<IAtomContainer> frags = new ArrayList<IAtomContainer>();
        for (IBond cut : cuts) {
            if (frags.size() >= 50) break;
            frags.addAll(Abbreviations.makeCut(cut, mol, atmidx, adjlist));
        }
        Collections.sort(frags, new Comparator<IAtomContainer>(){

            @Override
            public int compare(IAtomContainer a, IAtomContainer b) {
                return -Integer.compare(a.getBondCount(), b.getBondCount());
            }
        });
        return frags;
    }

    public List<Sgroup> generate(IAtomContainer mol) {
        HashSet<Object> usedAtoms = new HashSet<Object>();
        List sgroups = (List)mol.getProperty((Object)"cdk:CtabSgroups");
        if (sgroups != null) {
            for (Sgroup sgroup : sgroups) {
                usedAtoms.addAll(sgroup.getAtoms());
            }
        }
        ArrayList<Sgroup> newSgroups = new ArrayList<Sgroup>();
        if (usedAtoms.isEmpty()) {
            try {
                IAtomContainer copy = AtomContainerManipulator.copyAndSuppressedHydrogens((IAtomContainer)mol);
                String cansmi = this.usmigen.create(copy);
                String label = this.disconnectedAbbreviations.get(cansmi);
                if (label != null && !this.disabled.contains(label) && this.contractSingleFragments) {
                    Sgroup sgroup = new Sgroup();
                    sgroup.setType(SgroupType.CtabAbbreviation);
                    sgroup.setSubscript(label);
                    for (IAtom atom : mol.atoms()) {
                        sgroup.addAtom(atom);
                    }
                    return Collections.singletonList(sgroup);
                }
                if (cansmi.contains(".")) {
                    IAtomContainerSet parts = ConnectivityChecker.partitionIntoMolecules((IAtomContainer)mol);
                    Sgroup best = null;
                    for (int i = 0; i < parts.getAtomContainerCount(); ++i) {
                        IAtomContainer a = parts.getAtomContainer(i);
                        IAtomContainer b = a.getBuilder().newAtomContainer();
                        for (int j = 0; j < parts.getAtomContainerCount(); ++j) {
                            if (j == i) continue;
                            b.add(parts.getAtomContainer(j));
                        }
                        Sgroup sgroup1 = this.getAbbr(a);
                        Sgroup sgroup2 = this.getAbbr(b);
                        if (sgroup1 != null && sgroup2 != null && this.contractSingleFragments) {
                            Sgroup combined = new Sgroup();
                            label = null;
                            for (IAtom atom : sgroup1.getAtoms()) {
                                combined.addAtom(atom);
                            }
                            for (IAtom atom : sgroup2.getAtoms()) {
                                combined.addAtom(atom);
                            }
                            if (sgroup1.getSubscript().length() > sgroup2.getSubscript().length()) {
                                combined.setSubscript(sgroup1.getSubscript() + INTERPUNCT + sgroup2.getSubscript());
                            } else {
                                combined.setSubscript(sgroup2.getSubscript() + INTERPUNCT + sgroup1.getSubscript());
                            }
                            combined.setType(SgroupType.CtabAbbreviation);
                            return Collections.singletonList(combined);
                        }
                        if (sgroup1 != null && (best == null || sgroup1.getAtoms().size() > best.getAtoms().size())) {
                            best = sgroup1;
                        }
                        if (sgroup2 == null || best != null && sgroup2.getAtoms().size() >= best.getAtoms().size()) continue;
                        best = sgroup2;
                    }
                    if (best != null) {
                        newSgroups.add(best);
                        usedAtoms.addAll(best.getAtoms());
                    }
                }
            }
            catch (CDKException copy) {
                // empty catch block
            }
        }
        List<IAtomContainer> fragments = Abbreviations.generateFragments(mol);
        HashMap sgroupAdjs = new HashMap();
        for (IAtomContainer frag : fragments) {
            try {
                String smi = this.usmigen.create(AtomContainerManipulator.copyAndSuppressedHydrogens((IAtomContainer)frag));
                String label = this.connectedAbbreviations.get(smi);
                if (label == null || this.disabled.contains(label)) continue;
                boolean overlap = false;
                int numAtoms = frag.getAtomCount();
                int numBonds = frag.getBondCount();
                for (int i = 1; i < numAtoms; ++i) {
                    if (!usedAtoms.contains(frag.getAtom(i))) continue;
                    overlap = true;
                    break;
                }
                if (overlap) continue;
                Sgroup sgroup = new Sgroup();
                sgroup.setType(SgroupType.CtabAbbreviation);
                sgroup.setSubscript(label);
                IBond attachBond = (IBond)frag.getBond(0).getProperty((Object)CUT_BOND, IBond.class);
                IAtom attachAtom = null;
                sgroup.addBond(attachBond);
                for (int i = 1; i < numAtoms; ++i) {
                    IAtom atom = frag.getAtom(i);
                    usedAtoms.add(atom);
                    sgroup.addAtom(atom);
                    if (attachBond.getBegin().equals(atom)) {
                        attachAtom = attachBond.getEnd();
                        continue;
                    }
                    if (!attachBond.getEnd().equals(atom)) continue;
                    attachAtom = attachBond.getBegin();
                }
                if (attachAtom != null) {
                    sgroupAdjs.computeIfAbsent(attachAtom, k -> new ArrayList()).add(sgroup);
                }
                newSgroups.add(sgroup);
            }
            catch (CDKException smi) {}
        }
        if (!this.contractOnHetero) {
            return newSgroups;
        }
        block13: for (IAtom attach : mol.atoms()) {
            Object sgroup2;
            if (usedAtoms.contains(attach) || attach.getFormalCharge() != null && attach.getFormalCharge() != 0 || attach.getMassNumber() != null || attach.getAtomicNumber() == 6 || attach.getAtomicNumber() < 2) continue;
            int hcount = attach.getImplicitHydrogenCount();
            HashSet<IAtom> xatoms = new HashSet<IAtom>();
            HashSet<IBond> xbonds = new HashSet<IBond>();
            HashSet<IBond> newbonds = new HashSet<IBond>();
            xatoms.add(attach);
            ArrayList<String> nbrSymbols = new ArrayList<String>();
            HashSet<Object> todelete = new HashSet<Object>();
            for (Object sgroup2 : sgroupAdjs.getOrDefault(attach, Collections.emptyList())) {
                if (this.containsChargeChar(sgroup2.getSubscript()) || sgroup2.getBonds().size() != 1) continue;
                IBond xbond = (IBond)sgroup2.getBonds().iterator().next();
                xbonds.add(xbond);
                xatoms.addAll(sgroup2.getAtoms());
                if (attach.getSymbol().length() == 1 && Character.isLowerCase(sgroup2.getSubscript().charAt(0)) && Elements.ofString((String)(attach.getSymbol() + sgroup2.getSubscript().charAt(0))) != Elements.Unknown) continue block13;
                nbrSymbols.add(sgroup2.getSubscript());
                todelete.add(sgroup2);
            }
            int numSGrpNbrs = nbrSymbols.size();
            sgroup2 = mol.getConnectedBondsList(attach).iterator();
            while (sgroup2.hasNext()) {
                IBond bond = (IBond)sgroup2.next();
                if (xbonds.contains(bond)) continue;
                IAtom nbr = bond.getOther(attach);
                if (mol.getConnectedBondsCount(nbr) == 1) {
                    if (nbr.getMassNumber() != null || nbr.getFormalCharge() != null && nbr.getFormalCharge() != 0) {
                        newbonds.add(bond);
                        continue;
                    }
                    if (nbr.getAtomicNumber() == 1) {
                        ++hcount;
                        xatoms.add(nbr);
                        continue;
                    }
                    if (nbr.getAtomicNumber() <= 0) continue;
                    nbrSymbols.add(this.newSymbol(nbr.getAtomicNumber(), nbr.getImplicitHydrogenCount(), false));
                    xatoms.add(nbr);
                    continue;
                }
                newbonds.add(bond);
            }
            if (nbrSymbols.isEmpty() || newbonds.size() < 1 && new HashSet(nbrSymbols).size() != 1 || newbonds.size() > 2) continue;
            StringBuilder sb = new StringBuilder();
            sb.append(this.newSymbol(attach.getAtomicNumber(), hcount, newbonds.size() == 0));
            String prev = null;
            int count = 0;
            Collections.sort(nbrSymbols, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    int cmp = Integer.compare(o1.length(), o2.length());
                    if (cmp != 0) {
                        return cmp;
                    }
                    return o1.compareTo(o2);
                }
            });
            for (String nbrSymbol : nbrSymbols) {
                if (nbrSymbol.equals(prev)) {
                    ++count;
                    continue;
                }
                boolean useParen = count == 0 || this.countUpper(prev) > 1 || prev != null && nbrSymbol.startsWith(prev);
                this.appendGroup(sb, prev, count, useParen);
                prev = nbrSymbol;
                count = 1;
            }
            this.appendGroup(sb, prev, count, false);
            newSgroups.removeAll(todelete);
            Sgroup newSgroup = new Sgroup();
            newSgroup.setType(SgroupType.CtabAbbreviation);
            newSgroup.setSubscript(sb.toString());
            for (IBond bond : newbonds) {
                newSgroup.addBond(bond);
            }
            for (IAtom atom : xatoms) {
                newSgroup.addAtom(atom);
            }
            newSgroups.add(newSgroup);
            usedAtoms.addAll(xatoms);
        }
        return newSgroups;
    }

    private Sgroup getAbbr(IAtomContainer part) throws CDKException {
        if (part.getAtomCount() == 1) {
            IAtom atom = part.getAtom(0);
            String label = Abbreviations.getBasicElementSymbol(atom);
            if (label != null) {
                Sgroup sgroup = new Sgroup();
                sgroup.setType(SgroupType.CtabAbbreviation);
                sgroup.setSubscript(label);
                sgroup.addAtom(atom);
                return sgroup;
            }
        } else {
            String cansmi = this.usmigen.create(part);
            String label = this.disconnectedAbbreviations.get(cansmi);
            if (label != null && !this.disabled.contains(label)) {
                Sgroup sgroup = new Sgroup();
                sgroup.setType(SgroupType.CtabAbbreviation);
                sgroup.setSubscript(label);
                for (IAtom atom : part.atoms()) {
                    sgroup.addAtom(atom);
                }
                return sgroup;
            }
        }
        return null;
    }

    private int countUpper(String str) {
        if (str == null) {
            return 0;
        }
        int num = 0;
        for (int i = 0; i < str.length(); ++i) {
            if (!Character.isUpperCase(str.charAt(i))) continue;
            ++num;
        }
        return num;
    }

    private boolean containsChargeChar(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c != '-' && c != '+') continue;
            return true;
        }
        return false;
    }

    private boolean digitAtEnd(String str) {
        return Character.isDigit(str.charAt(str.length() - 1));
    }

    private String newSymbol(int atomnum, int hcount, boolean prefix) {
        StringBuilder sb = new StringBuilder();
        Elements elem = Elements.ofNumber((int)atomnum);
        if (elem == Elements.Carbon && hcount == 3) {
            return "Me";
        }
        if (prefix) {
            if (hcount > 0) {
                sb.append('H');
                if (hcount > 1) {
                    sb.append(hcount);
                }
            }
            sb.append(elem.symbol());
        } else {
            sb.append(elem.symbol());
            if (hcount > 0) {
                sb.append('H');
                if (hcount > 1) {
                    sb.append(hcount);
                }
            }
        }
        return sb.toString();
    }

    private void appendGroup(StringBuilder sb, String group, int coef, boolean useParen) {
        if (coef <= 0 || group == null || group.isEmpty()) {
            return;
        }
        if (!useParen) {
            boolean bl = useParen = coef > 1 && (this.countUpper(group) > 1 || this.digitAtEnd(group));
        }
        if (useParen) {
            sb.append('(');
        }
        sb.append(group);
        if (useParen) {
            sb.append(')');
        }
        if (coef > 1) {
            sb.append(coef);
        }
    }

    public int apply(IAtomContainer mol) {
        List<Sgroup> newSgroups = this.generate(mol);
        ArrayList<Object> sgroups = (ArrayList<Sgroup>)mol.getProperty((Object)"cdk:CtabSgroups");
        sgroups = sgroups == null ? new ArrayList<Sgroup>() : new ArrayList(sgroups);
        int prev = sgroups.size();
        for (Sgroup sgroup : newSgroups) {
            double coverage = (double)sgroup.getAtoms().size() / (double)mol.getAtomCount();
            if (!sgroup.getBonds().isEmpty() && !(coverage < 0.4)) continue;
            sgroups.add(sgroup);
        }
        mol.setProperty((Object)"cdk:CtabSgroups", Collections.unmodifiableList(sgroups));
        return sgroups.size() - prev;
    }

    private IQueryAtom matchExact(IAtomContainer mol, IAtom atom) {
        int hcnt;
        IChemObjectBuilder bldr = atom.getBuilder();
        int elem = atom.getAtomicNumber();
        if (elem == 0) {
            return null;
        }
        int val = hcnt = atom.getImplicitHydrogenCount().intValue();
        int con = hcnt;
        for (IBond bond : mol.getConnectedBondsList(atom)) {
            val += bond.getOrder().numeric().intValue();
            ++con;
            if (bond.getOther(atom).getAtomicNumber() != 1) continue;
            ++hcnt;
        }
        Expr expr = new Expr(Expr.Type.ELEMENT, elem).and(new Expr(Expr.Type.TOTAL_DEGREE, con)).and(new Expr(Expr.Type.TOTAL_H_COUNT, hcnt)).and(new Expr(Expr.Type.VALENCE, val));
        return new QueryAtom(expr);
    }

    private IQueryAtomContainer matchExact(IAtomContainer mol) {
        IChemObjectBuilder bldr = mol.getBuilder();
        QueryAtomContainer qry = new QueryAtomContainer(mol.getBuilder());
        HashMap<IAtom, IQueryAtom> atmmap = new HashMap<IAtom, IQueryAtom>();
        for (IAtom atom : mol.atoms()) {
            IQueryAtom qatom = this.matchExact(mol, atom);
            if (qatom == null) continue;
            atmmap.put(atom, qatom);
            qry.addAtom((IAtom)qatom);
        }
        for (IBond bond : mol.bonds()) {
            IAtom beg = (IAtom)atmmap.get(bond.getBegin());
            IAtom end = (IAtom)atmmap.get(bond.getEnd());
            if (beg == null || end == null) continue;
            QueryBond qbond = new QueryBond(beg, end, Expr.Type.TRUE);
            qry.addBond((IBond)qbond);
        }
        return qry;
    }

    private boolean addDisconnectedAbbreviation(IAtomContainer mol, String label) {
        try {
            String cansmi = SmilesGenerator.unique().create(mol);
            this.disconnectedAbbreviations.put(cansmi, label);
            this.labels.add(label);
            return true;
        }
        catch (CDKException e) {
            return false;
        }
    }

    private boolean addConnectedAbbreviation(IAtomContainer mol, String label) {
        try {
            this.connectedAbbreviations.put(this.usmigen.create(mol), label);
            this.labels.add(label);
            return true;
        }
        catch (CDKException e) {
            return false;
        }
    }

    public boolean add(String line) throws InvalidSmilesException {
        return this.add(this.smipar.parseSmiles(line), Abbreviations.getSmilesSuffix(line));
    }

    public boolean add(IAtomContainer mol, String label) {
        if (label == null || label.isEmpty()) {
            return false;
        }
        int numAttach = 0;
        for (IAtom atom : mol.atoms()) {
            if (atom.getImplicitHydrogenCount() == null || atom.getAtomicNumber() == null) {
                throw new IllegalArgumentException("Implicit hydrogen count or atomic number is null");
            }
            if (atom.getAtomicNumber() != 0) continue;
            ++numAttach;
        }
        switch (numAttach) {
            case 0: {
                return this.addDisconnectedAbbreviation(mol, label);
            }
            case 1: {
                return this.addConnectedAbbreviation(mol, label);
            }
        }
        return false;
    }

    private static String getSmilesSuffix(String line) {
        int last = line.length() - 1;
        for (int i = 0; i < last; ++i) {
            if (line.charAt(i) != ' ' && line.charAt(i) != '\t') continue;
            return line.substring(i + 1).trim();
        }
        return "";
    }

    private static String getBasicElementSymbol(IAtom atom) {
        if (atom.getFormalCharge() != null && atom.getFormalCharge() != 0) {
            return null;
        }
        if (atom.getMassNumber() != null && atom.getMassNumber() != 0) {
            return null;
        }
        if (atom.getAtomicNumber() == null || atom.getAtomicNumber() < 1) {
            return null;
        }
        Integer hcnt = atom.getImplicitHydrogenCount();
        if (hcnt == null) {
            return null;
        }
        Elements elem = Elements.ofNumber((int)atom.getAtomicNumber());
        String hsym = hcnt > 0 ? (hcnt > 1 ? "H" + hcnt : "H") : "";
        switch (elem) {
            case Oxygen: 
            case Sulfur: 
            case Selenium: 
            case Tellurium: 
            case Fluorine: 
            case Chlorine: 
            case Bromine: 
            case Iodine: {
                return hsym + elem.symbol();
            }
        }
        return elem.symbol() + hsym;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int loadSmiles(InputStream in) throws IOException {
        int count = 0;
        try (BufferedReader brdr = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
            String line;
            while ((line = brdr.readLine()) != null) {
                if (line.isEmpty() || line.charAt(0) == '#') continue;
                try {
                    if (!this.add(line)) continue;
                    ++count;
                }
                catch (InvalidSmilesException e) {
                    e.printStackTrace();
                }
            }
            return count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadFromFile(String path) throws IOException {
        try (InputStream in = null;){
            in = this.getClass().getResourceAsStream(path);
            if (in != null) {
                int n = this.loadSmiles(in);
                return n;
            }
            File file = new File(path);
            if (file.exists() && file.canRead()) {
                int n = this.loadSmiles(new FileInputStream(file));
                return n;
            }
        }
        return 0;
    }
}

