/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.marker;

import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.PathUtils;
import org.openrewrite.Tree;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.java.internal.JavaTypeCache;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.marker.SourceSet;

public final class JavaSourceSet
implements SourceSet {
    private final UUID id;
    private final String name;
    private final List<JavaType.FullyQualified> classpath;
    private final Map<String, List<JavaType.FullyQualified>> gavToTypes;

    @Deprecated
    public static JavaSourceSet build(String sourceSetName, Collection<Path> classpath, JavaTypeCache ignore, boolean fullTypeInformation) {
        List<String> typeNames;
        if (fullTypeInformation) {
            throw new UnsupportedOperationException();
        }
        if (!classpath.iterator().hasNext()) {
            try (ScanResult scanResult = new ClassGraph().enableClassInfo().enableSystemJarsAndModules().acceptPackages(new String[]{"java"}).ignoreClassVisibility().scan();){
                typeNames = JavaSourceSet.packagesToTypeDeclarations(scanResult);
            }
        }
        try (ScanResult scanResult = new ClassGraph().overrideClasspath(classpath).enableSystemJarsAndModules().enableClassInfo().ignoreClassVisibility().scan();){
            typeNames = JavaSourceSet.packagesToTypeDeclarations(scanResult);
        }
        typeNames.add("java.lang.Object");
        return new JavaSourceSet(Tree.randomId(), sourceSetName, JavaSourceSet.typesFrom(typeNames), Collections.emptyMap());
    }

    private static List<String> packagesToTypeDeclarations(ScanResult scanResult) {
        ArrayList<String> result = new ArrayList<String>();
        for (ClassInfo classInfo : scanResult.getAllClasses()) {
            String typeDeclaration;
            if (classInfo.isAnonymousInnerClass() || classInfo.isPrivate() || classInfo.isSynthetic() || classInfo.getName().contains(".enum.") || classInfo.isStandardClass() && !classInfo.getName().startsWith("java.") || classInfo.getPackageName().startsWith("kotlin.reflect.jvm.internal.impl.resolve.jvm") || (typeDeclaration = JavaSourceSet.declarableFullyQualifiedName(classInfo)) == null) continue;
            result.add(typeDeclaration);
        }
        return result;
    }

    private static List<JavaType.FullyQualified> typesFrom(List<String> typeNames) {
        ArrayList<JavaType.FullyQualified> types = new ArrayList<JavaType.FullyQualified>(typeNames.size());
        for (String typeName : typeNames) {
            types.add(JavaType.ShallowClass.build(typeName));
        }
        return types;
    }

    private static @Nullable String declarableFullyQualifiedName(ClassInfo classInfo) {
        String name;
        if (classInfo.getName().startsWith("java.") && !classInfo.isPublic()) {
            return null;
        }
        if (classInfo.isInnerClass()) {
            StringBuilder sb = new StringBuilder();
            ClassInfoList outerClasses = classInfo.getOuterClasses();
            for (int i = outerClasses.size() - 1; i >= 0; --i) {
                ClassInfo outerClass = (ClassInfo)outerClasses.get(i);
                if (outerClass.isPrivate() || outerClass.isAnonymousInnerClass() || outerClass.isSynthetic() || outerClass.isExternalClass()) {
                    return null;
                }
                if (i == outerClasses.size() - 1) {
                    sb.append(outerClass.getName()).append(".");
                    continue;
                }
                if (!outerClass.getName().startsWith(sb.toString())) {
                    return classInfo.getName();
                }
                sb.append(outerClass.getName().substring(sb.length())).append(".");
            }
            if (!classInfo.getName().startsWith(sb.toString())) {
                return classInfo.getName();
            }
            String nameFragment = classInfo.getName().substring(sb.length());
            if (!JavaSourceSet.isDeclarable(nameFragment)) {
                return null;
            }
            sb.append(nameFragment);
            name = sb.toString();
        } else {
            name = classInfo.getName();
        }
        if (!JavaSourceSet.isDeclarable(name)) {
            return null;
        }
        return name;
    }

    public static JavaSourceSet build(String sourceSetName, Collection<Path> classpath) {
        List<JavaType.FullyQualified> types = JavaSourceSet.getJavaStandardLibraryTypes();
        LinkedHashMap<String, List<JavaType.FullyQualified>> gavToTypes = new LinkedHashMap<String, List<JavaType.FullyQualified>>();
        for (Path path : classpath) {
            List<JavaType.FullyQualified> typesFromPath = JavaSourceSet.typesFromPath(path, null);
            types.addAll(typesFromPath);
            String gav = JavaSourceSet.gavFromPath(path);
            if (gav == null) continue;
            gavToTypes.put(gav, typesFromPath);
        }
        return new JavaSourceSet(Tree.randomId(), sourceSetName, types, gavToTypes);
    }

    static @Nullable String gavFromPath(Path path) {
        String version;
        String artifactId;
        String groupId;
        block8: {
            String pathStr = PathUtils.separatorsToUnix((String)path.toString());
            List<String> pathParts = Arrays.asList(pathStr.split("/"));
            groupId = null;
            artifactId = null;
            version = null;
            try {
                if (pathStr.contains("modules-2/files-2.1") && pathParts.size() >= 5) {
                    groupId = pathParts.get(pathParts.size() - 5);
                    artifactId = pathParts.get(pathParts.size() - 4);
                    version = pathParts.get(pathParts.size() - 3);
                    break block8;
                }
                if (pathParts.contains(".tt")) {
                    int ttIndex = pathParts.indexOf(".tt");
                    if (pathParts.size() - ttIndex > 3) {
                        groupId = String.join((CharSequence)".", pathParts.subList(ttIndex + 1, pathParts.size() - 2));
                        artifactId = pathParts.get(pathParts.size() - 2);
                        version = pathParts.get(pathParts.size() - 1);
                    }
                    break block8;
                }
                if (pathParts.size() < 4) break block8;
                version = pathParts.get(pathParts.size() - 2);
                artifactId = pathParts.get(pathParts.size() - 3);
                StringBuilder groupIdBuilder = new StringBuilder();
                for (int i = pathParts.size() - 3; i > 0; --i) {
                    Path maybeRepositoryRoot = Paths.get(String.join((CharSequence)"/", pathParts.subList(0, i)), new String[0]);
                    if (maybeRepositoryRoot.endsWith("repository") || Files.exists(maybeRepositoryRoot.resolve("repository.xml"), new LinkOption[0])) {
                        groupId = groupIdBuilder.substring(1);
                        break;
                    }
                    groupIdBuilder.insert(0, "." + pathParts.get(i - 1));
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        if (groupId == null || artifactId == null || version == null) {
            return null;
        }
        return groupId + ":" + artifactId + ":" + version;
    }

    private static List<JavaType.FullyQualified> typesFromPath(final Path path, final @Nullable String acceptPackage) {
        ArrayList<JavaType.FullyQualified> types;
        block9: {
            types = new ArrayList<JavaType.FullyQualified>();
            try {
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    try (JarFile jarFile = new JarFile(path.toFile());){
                        Enumeration<JarEntry> entries = jarFile.entries();
                        while (entries.hasMoreElements()) {
                            String s;
                            String entryName = entries.nextElement().getName();
                            if (!entryName.endsWith(".class") || !JavaSourceSet.isDeclarable(s = JavaSourceSet.entryNameToClassName(entryName))) continue;
                            types.add(JavaType.ShallowClass.build(s));
                        }
                        break block9;
                    }
                }
                Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        if (file.getFileName().toString().endsWith(".class")) {
                            String pathStr = file.isAbsolute() ? path.relativize(file).toString() : file.toString();
                            String s = JavaSourceSet.entryNameToClassName(pathStr);
                            if ((acceptPackage == null || s.startsWith(acceptPackage)) && JavaSourceSet.isDeclarable(s)) {
                                types.add(JavaType.ShallowClass.build(s));
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return types;
    }

    private static List<JavaType.FullyQualified> getJavaStandardLibraryTypes() {
        ArrayList<JavaType.FullyQualified> javaStandardLibraryTypes = new ArrayList<JavaType.FullyQualified>();
        Path toolsJar = Paths.get(System.getProperty("java.home"), new String[0]).resolve("../lib/tools.jar");
        if (Files.exists(toolsJar, new LinkOption[0])) {
            javaStandardLibraryTypes.addAll(JavaSourceSet.typesFromPath(toolsJar, "java"));
        } else {
            javaStandardLibraryTypes.addAll(JavaSourceSet.typesFromPath(FileSystems.getFileSystem(URI.create("jrt:/")).getPath("modules", "java.base"), "java"));
        }
        return javaStandardLibraryTypes;
    }

    private static String entryNameToClassName(String entryName) {
        int start = entryName.startsWith("modules/java.base/") ? "modules/java.base/".length() : 0;
        return entryName.substring(start, entryName.length() - ".class".length()).replace('/', '.');
    }

    static boolean isDeclarable(String className) {
        int dotIndex = Math.max(className.lastIndexOf("."), className.lastIndexOf(36));
        return dotIndex != -1 && dotIndex < className.length() - 1 && Character.isJavaIdentifierStart(className.charAt(dotIndex + 1));
    }

    @Generated
    public JavaSourceSet(UUID id, String name, List<JavaType.FullyQualified> classpath, Map<String, List<JavaType.FullyQualified>> gavToTypes) {
        this.id = id;
        this.name = name;
        this.classpath = classpath;
        this.gavToTypes = gavToTypes;
    }

    @Generated
    public UUID getId() {
        return this.id;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<JavaType.FullyQualified> getClasspath() {
        return this.classpath;
    }

    @Generated
    public Map<String, List<JavaType.FullyQualified>> getGavToTypes() {
        return this.gavToTypes;
    }

    @NonNull
    @Generated
    public String toString() {
        return "JavaSourceSet(id=" + this.getId() + ", name=" + this.getName() + ", classpath=" + this.getClasspath() + ", gavToTypes=" + this.getGavToTypes() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JavaSourceSet)) {
            return false;
        }
        JavaSourceSet other = (JavaSourceSet)o;
        UUID this$id = this.getId();
        UUID other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UUID $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }

    @NonNull
    @Generated
    public JavaSourceSet withId(UUID id) {
        return this.id == id ? this : new JavaSourceSet(id, this.name, this.classpath, this.gavToTypes);
    }

    @NonNull
    @Generated
    public JavaSourceSet withName(String name) {
        return this.name == name ? this : new JavaSourceSet(this.id, name, this.classpath, this.gavToTypes);
    }

    @NonNull
    @Generated
    public JavaSourceSet withClasspath(List<JavaType.FullyQualified> classpath) {
        return this.classpath == classpath ? this : new JavaSourceSet(this.id, this.name, classpath, this.gavToTypes);
    }

    @NonNull
    @Generated
    public JavaSourceSet withGavToTypes(Map<String, List<JavaType.FullyQualified>> gavToTypes) {
        return this.gavToTypes == gavToTypes ? this : new JavaSourceSet(this.id, this.name, this.classpath, gavToTypes);
    }
}

