/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.internal;

import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import org.jspecify.annotations.Nullable;
import org.openrewrite.internal.AdaptiveRadixTree;

public class JavaTypeCache
implements Cloneable {
    AdaptiveRadixTree<Object> typeCache = new AdaptiveRadixTree();
    private static final @Nullable Field STRING_VALUE;
    private static final @Nullable Field STRING_CODER;
    private static final boolean USE_REFLECTION;

    public <T> @Nullable T get(String signature) {
        return (T)this.typeCache.search(JavaTypeCache.getKeyBytes(signature));
    }

    public void put(String signature, Object o) {
        this.typeCache.insert(JavaTypeCache.getKeyBytes(signature), o);
    }

    public void clear() {
        this.typeCache.clear();
    }

    public JavaTypeCache clone() {
        try {
            JavaTypeCache clone = (JavaTypeCache)super.clone();
            clone.typeCache = this.typeCache.copy();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    static byte[] getKeyBytes(String s) {
        if (USE_REFLECTION) {
            try {
                byte[] bytes = (byte[])STRING_VALUE.get(s);
                byte coder = (Byte)STRING_CODER.get(s);
                if (coder == 0) {
                    return bytes;
                }
                byte[] prefixed = new byte[bytes.length + 1];
                System.arraycopy(bytes, 0, prefixed, 0, bytes.length);
                prefixed[bytes.length] = 0;
                return prefixed;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return s.getBytes(StandardCharsets.UTF_8);
    }

    static {
        Field coder;
        Field value;
        boolean hasCompactStrings = false;
        try {
            value = String.class.getDeclaredField("value");
            value.setAccessible(true);
            try {
                coder = String.class.getDeclaredField("coder");
                coder.setAccessible(true);
                Field compactStrings = String.class.getDeclaredField("COMPACT_STRINGS");
                compactStrings.setAccessible(true);
                hasCompactStrings = compactStrings.getBoolean(null);
            }
            catch (NoSuchFieldException e) {
                coder = null;
            }
        }
        catch (Exception e) {
            value = null;
            coder = null;
        }
        STRING_VALUE = value;
        STRING_CODER = coder;
        USE_REFLECTION = STRING_VALUE != null && STRING_CODER != null && hasCompactStrings;
    }
}

