/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.lang.var;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.migrate.lang.var.DeclarationCheck;
import org.openrewrite.java.search.UsesJavaVersion;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.marker.Markers;

public class UseVarForGenericMethodInvocations
extends Recipe {
    public String getDisplayName() {
        return "Apply `var` to generic method invocations";
    }

    public String getDescription() {
        return "Apply `var` to variables initialized by invocations of generic methods. This recipe ignores generic factory methods without parameters, because open rewrite cannot handle them correctly ATM.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesJavaVersion(10), (TreeVisitor)new UseVarForGenericsVisitor());
    }

    static final class UseVarForGenericsVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        UseVarForGenericsVisitor() {
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations vd, ExecutionContext ctx) {
            boolean isMethodInvocation;
            vd = super.visitVariableDeclarations(vd, (Object)ctx);
            boolean isGeneralApplicable = DeclarationCheck.isVarApplicable(this.getCursor(), vd);
            if (!isGeneralApplicable) {
                return vd;
            }
            boolean isPrimitive = DeclarationCheck.isPrimitive(vd);
            boolean usesNoGenerics = !DeclarationCheck.useGenerics(vd);
            boolean usesTernary = DeclarationCheck.initializedByTernary(vd);
            if (isPrimitive || usesTernary || usesNoGenerics) {
                return vd;
            }
            Expression initializer = ((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getInitializer();
            boolean bl = isMethodInvocation = initializer != null && initializer.unwrap() instanceof J.MethodInvocation;
            if (!isMethodInvocation) {
                return vd;
            }
            boolean hasNoTypeParams = ((J.MethodInvocation)initializer).getTypeParameters() == null;
            boolean argumentsEmpty = UseVarForGenericsVisitor.allArgumentsEmpty((J.MethodInvocation)initializer);
            if (hasNoTypeParams && argumentsEmpty) {
                return vd;
            }
            if (vd.getType() instanceof JavaType.FullyQualified) {
                this.maybeRemoveImport((JavaType.FullyQualified)vd.getType());
            }
            J.VariableDeclarations finalVd = vd;
            return DeclarationCheck.transformToVar(vd, mi -> this.makeNestedGenericsExplicit((J.MethodInvocation)mi, finalVd));
        }

        private J.MethodInvocation makeNestedGenericsExplicit(J.MethodInvocation mi, J.VariableDeclarations vd) {
            if (!(vd.getTypeExpression() instanceof J.ParameterizedType)) {
                return mi;
            }
            List leftTypeParams = ((J.ParameterizedType)vd.getTypeExpression()).getTypeParameters();
            if (leftTypeParams == null || leftTypeParams.isEmpty()) {
                return mi;
            }
            if (mi.getTypeParameters() == null && mi.getMethodType() != null && this.containsGenericTypeVariable(mi.getMethodType().getReturnType())) {
                ArrayList<JRightPadded> typeParamsList = new ArrayList<JRightPadded>();
                for (Expression typeParam : leftTypeParams) {
                    typeParamsList.add(JRightPadded.build((Object)typeParam));
                }
                mi = mi.withTypeParameters(JContainer.build((Space)Space.EMPTY, typeParamsList, (Markers)Markers.EMPTY));
            }
            return mi.withArguments(ListUtils.map((List)mi.getArguments(), arg -> {
                J.NewClass newClass;
                if (arg instanceof J.NewClass && !UseVarForGenericsVisitor.hasTypeParams((newClass = (J.NewClass)arg).getClazz())) {
                    J.ParameterizedType rightType = (J.ParameterizedType)newClass.getClazz();
                    return newClass.withClazz((TypeTree)Objects.requireNonNull(rightType).withTypeParameters(leftTypeParams));
                }
                return arg;
            }));
        }

        private boolean containsGenericTypeVariable(JavaType type) {
            if (type instanceof JavaType.GenericTypeVariable) {
                return true;
            }
            if (type instanceof JavaType.Parameterized) {
                for (JavaType typeParam : ((JavaType.Parameterized)type).getTypeParameters()) {
                    if (!this.containsGenericTypeVariable(typeParam)) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean hasTypeParams(@Nullable TypeTree clazz) {
            List typeParameters;
            if (clazz instanceof J.ParameterizedType && (typeParameters = ((J.ParameterizedType)clazz).getTypeParameters()) != null) {
                for (Expression curType : typeParameters) {
                    if (curType.getType() == null) continue;
                    return true;
                }
            }
            return false;
        }

        private static boolean allArgumentsEmpty(J.MethodInvocation invocation) {
            for (Expression argument : invocation.getArguments()) {
                if (argument instanceof J.Empty) continue;
                return false;
            }
            return true;
        }
    }
}

