/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.migrate.guava;

import java.util.Collections;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class NoGuavaPredicatesAndOr
extends Recipe {
    private static final MethodMatcher PREDICATES_AND = new MethodMatcher("com.google.common.base.Predicates and(com.google.common.base.Predicate, com.google.common.base.Predicate)");
    private static final MethodMatcher PREDICATES_OR = new MethodMatcher("com.google.common.base.Predicates or(com.google.common.base.Predicate, com.google.common.base.Predicate)");

    public String getDisplayName() {
        return "Prefer `Predicate.and(Predicate)`";
    }

    public String getDescription() {
        return "Prefer `Predicate.and(Predicate)` over `Predicates.and(Predicate, Predicate)`.";
    }

    public Set<String> getTags() {
        return Collections.singleton("guava");
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor precondition = Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(PREDICATES_AND), new UsesMethod(PREDICATES_OR)});
        return Preconditions.check((TreeVisitor)precondition, (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (PREDICATES_AND.matches((MethodCall)method)) {
                    this.maybeRemoveImport("com.google.common.base.Predicate");
                    this.maybeRemoveImport("com.google.common.base.Predicates");
                    this.maybeAddImport("java.util.function.Predicate");
                    if (method.getArguments().size() == 2) {
                        return JavaTemplate.builder((String)"#{any(java.util.function.Predicate)}.and(#{any(java.util.function.Predicate)})").build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getArguments().get(0), method.getArguments().get(1)});
                    }
                }
                if (PREDICATES_OR.matches((MethodCall)method)) {
                    this.maybeRemoveImport("com.google.common.base.Predicate");
                    this.maybeRemoveImport("com.google.common.base.Predicates");
                    this.maybeAddImport("java.util.function.Predicate");
                    if (method.getArguments().size() == 2) {
                        return JavaTemplate.builder((String)"#{any(java.util.function.Predicate)}.or(#{any(java.util.function.Predicate)})").build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method.getArguments().get(0), method.getArguments().get(1)});
                    }
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }
}

