/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.logging.slf4j;

import java.util.function.Supplier;
import java.util.logging.Level;
import org.openrewrite.java.template.RecipeDescriptor;
import org.slf4j.Logger;

@RecipeDescriptor(name="Replace JUL active Level check with corresponding SLF4J method calls", description="Replace calls to `Logger.isLoggable(Level)` with the corresponding SLF4J method calls.")
public class JulToSlf4jLambdaSupplier {

    @RecipeDescriptor(name="Replace JUL `Logger.log(Level.ALL, Supplier<String>)` with SLF4J's `Logger.atInfo().log(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.log(Level.ALL, Supplier<String>)` with `org.slf4j.Logger.atTrace().log(Supplier<String>)`.")
    public static class JulToSlf4jSupplierLogAll {
        void before(java.util.logging.Logger logger, Supplier<String> supplier) {
            logger.log(Level.ALL, supplier);
        }

        void after(Logger logger, Supplier<String> supplier) {
            logger.atTrace().log(supplier);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.log(Level.SEVERE, Supplier<String>)` with SLF4J's `Logger.atInfo().log(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.log(Level.SEVERE, Supplier<String>)` with `org.slf4j.Logger.atError().log(Supplier<String>)`.")
    public static class JulToSlf4jSupplierLogSevere {
        void before(java.util.logging.Logger logger, Supplier<String> supplier) {
            logger.log(Level.SEVERE, supplier);
        }

        void after(Logger logger, Supplier<String> supplier) {
            logger.atError().log(supplier);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.log(Level.WARNING, Supplier<String>)` with SLF4J's `Logger.atInfo().log(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.log(Level.WARNING, Supplier<String>)` with `org.slf4j.Logger.atWarn().log(Supplier<String>)`.")
    public static class JulToSlf4jSupplierLogWarning {
        void before(java.util.logging.Logger logger, Supplier<String> supplier) {
            logger.log(Level.WARNING, supplier);
        }

        void after(Logger logger, Supplier<String> supplier) {
            logger.atWarn().log(supplier);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.log(Level.INFO, Supplier<String>)` with SLF4J's `Logger.atInfo().log(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.log(Level.INFO, Supplier<String>)` with `org.slf4j.Logger.atInfo().log(Supplier<String>)`.")
    public static class JulToSlf4jSupplierLogInfo {
        void before(java.util.logging.Logger logger, Supplier<String> supplier) {
            logger.log(Level.INFO, supplier);
        }

        void after(Logger logger, Supplier<String> supplier) {
            logger.atInfo().log(supplier);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.log(Level.CONFIG, Supplier<String>)` with SLF4J's `Logger.atInfo().log(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.log(Level.CONFIG, Supplier<String>)` with `org.slf4j.Logger.atInfo().log(Supplier<String>)`.")
    public static class JulToSlf4jSupplierLogConfig {
        void before(java.util.logging.Logger logger, Supplier<String> supplier) {
            logger.log(Level.CONFIG, supplier);
        }

        void after(Logger logger, Supplier<String> supplier) {
            logger.atInfo().log(supplier);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.log(Level.FINE, Supplier<String>)` with SLF4J's `Logger.atInfo().log(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.log(Level.FINE, Supplier<String>)` with `org.slf4j.Logger.atDebug().log(Supplier<String>)`.")
    public static class JulToSlf4jSupplierLogFine {
        void before(java.util.logging.Logger logger, Supplier<String> supplier) {
            logger.log(Level.FINE, supplier);
        }

        void after(Logger logger, Supplier<String> supplier) {
            logger.atDebug().log(supplier);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.log(Level.FINER, Supplier<String>)` with SLF4J's `Logger.atInfo().log(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.log(Level.FINER, Supplier<String>)` with `org.slf4j.Logger.atTrace().log(Supplier<String>)`.")
    public static class JulToSlf4jSupplierLogFiner {
        void before(java.util.logging.Logger logger, Supplier<String> supplier) {
            logger.log(Level.FINER, supplier);
        }

        void after(Logger logger, Supplier<String> supplier) {
            logger.atTrace().log(supplier);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.log(Level.FINEST, Supplier<String>)` with SLF4J's `Logger.atInfo().log(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.log(Level.FINEST, Supplier<String>)` with `org.slf4j.Logger.atTrace().log(Supplier<String>)`.")
    public static class JulToSlf4jSupplierLogFinest {
        void before(java.util.logging.Logger logger, Supplier<String> supplier) {
            logger.log(Level.FINEST, supplier);
        }

        void after(Logger logger, Supplier<String> supplier) {
            logger.atTrace().log(supplier);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.severe(Supplier<String>)` with SLF4J's `Logger.atError().log(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.severe(Supplier<String>)` with `org.slf4j.Logger.atError().log(Supplier<String>)`.")
    public static class JulToSlf4jSupplierSevere {
        void before(java.util.logging.Logger logger, Supplier<String> supplier) {
            logger.severe(supplier);
        }

        void after(Logger logger, Supplier<String> supplier) {
            logger.atError().log(supplier);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.warning(Supplier<String>)` with SLF4J's `Logger.atWarn().log(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.warning(Supplier<String>)` with `org.slf4j.Logger.atWarn().log(Supplier<String>)`.")
    public static class JulToSlf4jSupplierWarning {
        void before(java.util.logging.Logger logger, Supplier<String> supplier) {
            logger.warning(supplier);
        }

        void after(Logger logger, Supplier<String> supplier) {
            logger.atWarn().log(supplier);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.info(Supplier<String>)` with SLF4J's `Logger.atInfo().log(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.info(Supplier<String>)` with `org.slf4j.Logger.atInfo().log(Supplier<String>)`.")
    public static class JulToSlf4jSupplierInfo {
        void before(java.util.logging.Logger logger, Supplier<String> supplier) {
            logger.info(supplier);
        }

        void after(Logger logger, Supplier<String> supplier) {
            logger.atInfo().log(supplier);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.config(Supplier<String>)` with SLF4J's `Logger.atInfo().log(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.config(Supplier<String>)` with `org.slf4j.Logger.atInfo().log(Supplier<String>)`.")
    public static class JulToSlf4jSupplierConfig {
        void before(java.util.logging.Logger logger, Supplier<String> supplier) {
            logger.config(supplier);
        }

        void after(Logger logger, Supplier<String> supplier) {
            logger.atInfo().log(supplier);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.fine(Supplier<String>)` with SLF4J's `Logger.atDebug().log(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.fine(Supplier<String>)` with `org.slf4j.Logger.atDebug().log(Supplier<String>)`.")
    public static class JulToSlf4jSupplierFine {
        void before(java.util.logging.Logger logger, Supplier<String> supplier) {
            logger.fine(supplier);
        }

        void after(Logger logger, Supplier<String> supplier) {
            logger.atDebug().log(supplier);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.finer(Supplier<String>)` with SLF4J's `Logger.atTrace().log(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.finer(Supplier<String>)` with `org.slf4j.Logger.atTrace().log(Supplier<String>)`.")
    public static class JulToSlf4jSupplierFiner {
        void before(java.util.logging.Logger logger, Supplier<String> supplier) {
            logger.finer(supplier);
        }

        void after(Logger logger, Supplier<String> supplier) {
            logger.atTrace().log(supplier);
        }
    }

    @RecipeDescriptor(name="Replace JUL `Logger.finest(Supplier<String>)` with SLF4J's `Logger.atTrace().log(Supplier<String>)`", description="Replace calls to `java.util.logging.Logger.finest(Supplier<String>)` with `org.slf4j.Logger.atTrace().log(Supplier<String>)`.")
    public static class JulToSlf4jSupplierFinest {
        void before(java.util.logging.Logger logger, Supplier<String> supplier) {
            logger.finest(supplier);
        }

        void after(Logger logger, Supplier<String> supplier) {
            logger.atTrace().log(supplier);
        }
    }
}

