/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.plugin;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.plugin.AbstractWPLoadDependencyMojo;
import org.nuiton.wikitty.plugin.JettyUtil;
import org.nuiton.wikitty.publication.PropertiesExtended;
import org.nuiton.wikitty.publication.WikittyFileUtil;
import org.nuiton.wikitty.publication.WikittyPublicationFallbackService;
import org.nuiton.wikitty.publication.synchro.WikittyPublicationFileSystem;

public class WPRunMojo
extends AbstractWPLoadDependencyMojo {
    private static final String DEPENDCY_TYPE_WAR = "war";
    protected static final String PUBLICATION_WAR_ARTIFACT_ID = "wikitty-publication-ui";
    protected static final String PUBLICATION_WAR_GROUP_ID = "org.nuiton.wikitty";
    public static final String FALLBACK_PROPERTIE_FILE_NAME = "fallback.properties";
    private ArtifactResolver artifactResolver;
    private ArtifactFactory artifactFactory;
    protected String publicationVersion;
    protected ArtifactRepository localRepository;
    protected List remoteRepositories;

    @Override
    protected void init() throws Exception {
        super.init();
    }

    protected void doAction() throws Exception {
        File webApp = this.resolveFile();
        String build = this.project.getBuild().getDirectory();
        File buildDir = new File(build);
        this.createDirectoryIfNecessary(buildDir);
        File propsFile = new File(build + File.separator + FALLBACK_PROPERTIE_FILE_NAME);
        if (propsFile.exists()) {
            this.deleteFile(propsFile);
        }
        this.createNewFile(propsFile);
        String fileSystemUrlService = this.getProject().getBasedir().toURI().toURL().toExternalForm();
        fileSystemUrlService = fileSystemUrlService + "#src" + WikittyFileUtil.WIKITTY_LABEL_SEPARATOR + "main";
        PropertiesExtended propsFSServiceFall = new PropertiesExtended(propsFile);
        propsFSServiceFall.put((Object)WikittyConfigOption.WIKITTY_WIKITTYSERVICE_COMPONENTS.getKey(), (Object)WikittyPublicationFileSystem.class.getName());
        propsFSServiceFall.put((Object)WikittyConfigOption.WIKITTY_SERVER_URL.getKey(), (Object)fileSystemUrlService);
        propsFSServiceFall.store();
        System.setProperty(WikittyPublicationFallbackService.WIKITTY_FALLBACK_FILE_KEY, FALLBACK_PROPERTIE_FILE_NAME);
        System.setProperty("config.path", this.getProject().getBuild().getDirectory());
        JettyUtil jettyRunMojo = new JettyUtil();
        jettyRunMojo.setWebApp(webApp);
        jettyRunMojo.setProject(this.project);
        jettyRunMojo.execute();
    }

    private File resolveFile() throws IOException, ArtifactResolutionException, ArtifactNotFoundException {
        File result;
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(PUBLICATION_WAR_GROUP_ID, PUBLICATION_WAR_ARTIFACT_ID, this.publicationVersion, DEPENDCY_TYPE_WAR, "");
        try {
            this.artifactResolver.resolve(artifact, this.remoteRepositories, this.localRepository);
            result = artifact.getFile();
            if (result.length() == 0L) {
                this.getLog().debug((CharSequence)"Skipped third party descriptor");
            }
        }
        catch (ArtifactNotFoundException e) {
            this.getLog().debug((CharSequence)("Unable to locate third party files descriptor : " + (Object)((Object)e)));
            result = new File(this.localRepository.getBasedir(), this.localRepository.pathOf(artifact));
            this.createNewFile(result);
        }
        return result;
    }
}

