/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.java.ObjectModelTransformerToJava;
import org.nuiton.eugene.models.object.ObjectModel;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;
import org.nuiton.eugene.models.object.ObjectModelElement;
import org.nuiton.wikitty.generator.WikittyTransformerUtil;

public class WikittyPurifierTransformer
extends ObjectModelTransformerToJava {
    private static final Log log = LogFactory.getLog(WikittyPurifierTransformer.class);
    Map<ObjectModelClass, List<String>> namesUsedByClass = new HashMap<ObjectModelClass, List<String>>();
    List<ObjectModelClass> processedClasses = new ArrayList<ObjectModelClass>();

    protected void processClass(ObjectModelClass clazz) {
        if (!this.processedClasses.contains(clazz)) {
            ArrayList<String> allUsedNames = new ArrayList<String>();
            for (ObjectModelClass superClasses : clazz.getSuperclasses()) {
                if (!WikittyTransformerUtil.isBusinessEntity(superClasses) || this.processedClasses.contains(superClasses)) continue;
                this.processClass(superClasses);
                allUsedNames.addAll((Collection)this.namesUsedByClass.get(superClasses));
            }
            for (ObjectModelAttribute attribute : clazz.getAttributes()) {
                String attributeName = null;
                if (attribute.hasTagValue("alternativeName") && allUsedNames.contains(attributeName = attribute.getTagValue("alternativeName"))) {
                    attribute.getTagValues().remove("alternativeName");
                    attributeName = null;
                }
                if (attributeName == null && allUsedNames.contains(attributeName = attribute.getName())) {
                    attributeName = null;
                }
                if (attributeName == null) {
                    attributeName = attribute.getName() + "From" + clazz.getName();
                    if (allUsedNames.contains(attributeName)) {
                        attributeName = null;
                    } else {
                        this.addTagValue((ObjectModelElement)attribute, "alternativeName", attributeName);
                    }
                }
                if (attributeName == null) {
                    log.error((Object)("no way to resolve conflict with attribute" + attribute.getName() + " from class " + clazz + ". You should add or change a tagValue \"" + "alternativeName" + "\" on this attribute"));
                    continue;
                }
                allUsedNames.add(attributeName);
            }
            this.namesUsedByClass.put(clazz, allUsedNames);
        }
    }

    public void transformFromModel(ObjectModel model) {
        for (ObjectModelClass clazz : model.getClasses()) {
            ObjectModelClass clone = this.cloneClass(clazz, true);
            if (!WikittyTransformerUtil.isBusinessEntity(clazz)) continue;
            this.processClass(clone);
        }
    }
}

