package org.nuiton.wikitty.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.GeneratorUtil;
import org.nuiton.eugene.models.object.ObjectModelAttribute;
import org.nuiton.eugene.models.object.ObjectModelClass;

/**
 * Possible enhancement:
 * - generateParentMethod can generate attribut method access that call
 *   the same method on parent instance class. For that we must have one attribut
 *   instance by parent. This attribut we must be created in setWikitty method
 *   and used same wikitty object.
 *
 * @author poussin
 */
public class WikittyHelperGenerator extends WikengoCommonGenerator {
	
	private static final Log log = LogFactory.getLog(WikittyHelperGenerator.class);

    static protected Pattern extractTypeOnCollection = Pattern.compile("\\w*<(\\w+)>");

    protected String EXT_NAME;

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        String fqn = clazz.getQualifiedName();
        log.info( "Filename for " + clazz.getName() + " is " +  fqn.replace('.', File.separatorChar) + ".java");
        return fqn.replace('.', File.separatorChar) + "Helper.java";
    }

    public void generateFromClass(Writer output, ObjectModelClass clazz)
            throws IOException {
        if (!EugengoUtils.isBusinessEntity(clazz)) {
        	log.info( clazz.getName() + " is not a business entity");
            return;
        }

        log.info("Generate Business entity abstract" + clazz.getName() + "... ");
        generateCopyright(output);

        EXT_NAME = "EXT_" + clazz.getName().toUpperCase();

        String packageName = clazz.getPackageName();
        String name = clazz.getName() + "Helper";
        String nameImpl = clazz.getName() + "Impl";
output.write("package "+packageName+";\n");
output.write("\n");
output.write("");
        ObjectModelClass superClass = findSuperClass(clazz);

        clearImports();
        addImport(clazz);
        addImport(superClass);
        addImport("org.nuiton.wikitty.WikittyUtil");
        addImport("org.nuiton.wikitty.Wikitty");
        addImport("org.nuiton.wikitty.BusinessEntityWikitty");
        addImport("org.nuiton.wikitty.WikittyExtension");
        addImport(Collection.class);
        addImport(Collections.class);
        addImport(List.class);
        addImport(ArrayList.class);

        lookForAttributeImports(clazz);
        generateImports(output, packageName);

        generateClazzDocumentation(output, clazz);

        // l'heritage sur le Impl n'est la que pour profiter des constantes deja definies
output.write("public class "+name+" extends "+nameImpl+" {\n");
output.write("\n");
output.write("");

        String svUID = GeneratorUtil.computeSerialVersionUID(clazz);
output.write("    private static final long serialVersionUID = "+svUID+";\n");
output.write("\n");
output.write("");

output.write("\n");
output.write("    /**\n");
output.write("     * This class is not instanciable, it's just helper\n");
output.write("     */\n");
output.write("    private "+name+"() {\n");
output.write("    }\n");
output.write("\n");
output.write("");

        generateAttributeAccessMethod(output, clazz);
        
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (EugengoUtils.isBusinessEntity(parent)) {
                generateParentMethod(output, parent);
            }
        }

output.write("\n");
output.write("    /**\n");
output.write("     * Check if wikitty has current extension\n");
output.write("     */\n");
output.write("    static public boolean isExtension(Wikitty w) {\n");
output.write("        boolean result = w.hasExtension("+EXT_NAME+");\n");
output.write("        return result;\n");
output.write("    }\n");
output.write("\n");
output.write("    /**\n");
output.write("     * ajout les extensions static de cette classe au wikitty en argument\n");
output.write("     */\n");
output.write("    static public void addExtension(Wikitty w) {\n");
output.write("        for (WikittyExtension ext : extensions) {\n");
output.write("            w.addExtension(ext);\n");
output.write("        }\n");
output.write("    }\n");
output.write("\n");
output.write("    /**\n");
output.write("     * Check equality on all field of this extension, and only those.\n");
output.write("     */\n");
output.write("    static public boolean equals(Wikitty w1, Wikitty w2) {\n");
output.write("        boolean result = true;\n");
output.write("");
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (attr.isNavigable() && !attr.isStatic() &&
                    (attr.getStereotypes() == null || attr.getStereotypes().isEmpty())) {
output.write("        if (result) {\n");
output.write("            Object f1 = w1.getFieldAsObject("+EXT_NAME+", FIELD_"+attr.getName().toUpperCase()+");\n");
output.write("            Object f2 = w2.getFieldAsObject("+EXT_NAME+", FIELD_"+attr.getName().toUpperCase()+");\n");
output.write("            result = f1 == f2 || (f1 != null && f1.equals(f2));\n");
output.write("        }\n");
output.write("");
            }
        }
output.write("\n");
output.write("        return result;\n");
output.write("    }\n");
output.write("\n");
output.write("} //"+name+"\n");
output.write("");

    }
    
    
    
    // Utilitarian methods

    public void generateAttributeAccessMethod(Writer output, ObjectModelClass clazz) throws IOException {
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            if (attr.isNavigable() && !attr.isStatic()
                    && (attr.getStereotypes() == null || attr.getStereotypes().isEmpty())) {
        		if ((attr.getMaxMultiplicity() != 0 && attr.getMaxMultiplicity() != 1)) {
        			//TODO ymartel 20090812: when dataType "List", "Set" or "Collection" in model, must be here!
        			generateCollectionAttributeAccessors(output, attr);
        		} else {
        			generateWikittyAttributeAccessors(output, attr);
        		}
            }
        }
    }

    private void generateParentMethod(Writer output,
            ObjectModelClass clazz) throws IOException {

        // we must generate method for parent of parent
        for (ObjectModelClass parent : clazz.getSuperclasses()) {
            if (EugengoUtils.isBusinessEntity(parent)) {
                generateParentMethod(output, parent);
            }
        }

        // generate method acces for parent attribut
        generateAttributeAccessMethod(output, clazz);
    }
    
    protected void generateWikittyAttributeAccessors(Writer output, 
    		ObjectModelAttribute attr) throws IOException {

        EXT_NAME = "EXT_" + attr.getDeclaringElement().getName().toUpperCase();

    	String attrType = computeType(attr);
    	if (EugengoUtils.notEmpty(attrType)) {
    		attrType = getType(attrType, true);
    	} else {
    		return;
    	}
    	
    	// FIXME EC-20100421 cette methode peut retourner List<String>
    	// et generer la methode getWikitty().getFieldAsList<String>()
    	// qui ne peut pas compiler
        String methodAccessName = getFieldAccessMethodName(attr);

        String attrName = attr.getName();
    	String attrNameCapitalized = EugengoUtils.toUpperCaseFirstLetter(attrName);

output.write("\n");
output.write("    static public void set"+attrNameCapitalized+"(Wikitty w, "+attrType+" "+attrName+") {\n");
output.write("        w.setField("+EXT_NAME+", \""+attrName+"\", "+attrName+");\n");
output.write("    }\n");
output.write("\n");
output.write("    static public "+attrType+" get"+attrNameCapitalized+"(Wikitty w) {\n");
output.write("        "+attrType+" result = w.getFieldAs"+methodAccessName+"("+EXT_NAME+", \""+attrName+"\");\n");
output.write("        return result;\n");
output.write("    }\n");
output.write("\n");
output.write("");
    }

    /**
     * Give the string to put after getFieldAs???, only some type is accepted
     * and we must convert BusinessEntity to Wikitty string
     * @param type
     * @return
     */
    protected String getFieldAccessMethodName(ObjectModelAttribute attr) {
        String result = computeType(attr);
        result = getType(result, true);

        boolean isCollection = (attr.getMaxMultiplicity() != 0
                && attr.getMaxMultiplicity() != 1);
        if (isCollection) {
            if (attr.isUnique()) {
                result = "Set";
            } else {
                result = "List";
            }
        } else {
            // test for Date
            if ("java.util.Date".equals(result) || "Date".equals(result)) {
                result = "Date";
            } else if (getModel().hasClass(result)) { // test for Wikitty object
                ObjectModelClass fieldClass = getModel().getClass(result);
                if (EugengoUtils.isBusinessEntity(fieldClass)) {
                    // for wikittyDto we use String for Id
                    result = "Wikitty";
                }
            } else if (null != getModel().getEnumeration(result)) {
                result = "String";
            }
        }
        result = EugengoUtils.toUpperCaseFirstLetter(result);

        return result;
    }

    protected void generateCollectionAttributeAccessors(Writer output, 
    		ObjectModelAttribute attr) throws IOException {

        EXT_NAME = "EXT_" + attr.getDeclaringElement().getName().toUpperCase();

        String attrType = computeType(attr);
    	if (EugengoUtils.notEmpty(attrType)) {
    		attrType = getType(attrType, true);
    	} else {
    		return;
    	}

        // get collection element type for add and remove method arguement type
        String elementType = getType(attr.getType(), true);

        String methodAccessName = getFieldAccessMethodName(attr);

    	String attrName = attr.getName();
    	String attrNameCapitalized = EugengoUtils.toUpperCaseFirstLetter(attrName);
output.write("    static public "+attrType+" get"+attrNameCapitalized+"(Wikitty w) {\n");
output.write("        "+attrType+" result = w.getFieldAs"+methodAccessName+"("+EXT_NAME+", \""+attrName+"\", "+getClassAndGeneric(attrType)[1]+".class);\n");
output.write("        return result;\n");
output.write("    }\n");
output.write("\n");
output.write("    static public void add"+attrNameCapitalized+"(Wikitty w, "+elementType+" element) {\n");
output.write("        w.addToField("+EXT_NAME+", \""+attrName+"\", element);\n");
output.write("    }\n");
output.write("    \n");
output.write("    static public void remove"+attrNameCapitalized+"(Wikitty w, "+elementType+" element) {\n");
output.write("        w.removeFromField("+EXT_NAME+", \""+attrName+"\", element);\n");
output.write("    }\n");
output.write("    \n");
output.write("    static public void clear"+attrNameCapitalized+"(Wikitty w) {\n");
output.write("        w.clearField("+EXT_NAME+", \""+attrName+"\");\n");
output.write("    }\n");
output.write("\n");
output.write("");
    }
    
    private static Set<String> commonNumerics;
    static {
        commonNumerics = new HashSet<String>();
        commonNumerics.add("byte");
        commonNumerics.add("Byte");
        commonNumerics.add("short");
        commonNumerics.add("Short");
        commonNumerics.add("int");
        commonNumerics.add("Integer");
        commonNumerics.add("long");
        commonNumerics.add("Long");
        commonNumerics.add("float");
        commonNumerics.add("Float");
        commonNumerics.add("double");
        commonNumerics.add("Double");
    }

    private static Set<String> commonStrings;
    static {
        commonStrings = new HashSet<String>();
        commonStrings.add("char");
        commonStrings.add("Char");
        commonStrings.add("String");
    }

    private static Set<String> commonTypes;
    static {
        commonTypes = new HashSet<String>();
        commonTypes.addAll(commonNumerics);
        commonTypes.addAll(commonStrings);
        commonTypes.add("boolean");
        commonTypes.add("Boolean");
        commonTypes.add("Date");
    }

}
