package org.nuiton.wikitty.generator;

import java.io.File;
import java.io.IOException;
import java.io.Writer;

import org.nuiton.eugene.models.object.ObjectModelInterface;
import org.nuiton.eugene.models.object.ObjectModelOperation;

public class InterfaceGenerator extends WikengoCommonGenerator {

    @Override
    public String getFilenameForInterface(ObjectModelInterface interfacez) {
        String fqn = interfacez.getQualifiedName();
        return fqn.replace('.', File.separatorChar) + ".java";
    }

    @Override
    public void generateFromInterface(Writer output,
            ObjectModelInterface interfacez) throws IOException {
        // Generate only is not stereotype is specified
        if (!interfacez.getStereotypes().isEmpty()) {
            return;
        }

        generateCopyright(output);

        String packageName = interfacez.getPackageName();
        String name = interfacez.getName();
output.write("package "+packageName+";\n");
output.write("\n");
output.write("");

        clearImports();
        lookForOperationImports(interfacez);
        generateImports(output, packageName);

        generateClazzDocumentation(output, interfacez);
output.write("public interface "+name+" {\n");
output.write("\n");
output.write("");

        for (ObjectModelOperation op : interfacez.getOperations()) {
            generateOperationHeader(output, op, true);
        }

output.write("} //"+name+"\n");
output.write("");

    }

}
