/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.conform;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Assert;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyImportExportService;
import org.nuiton.wikitty.conform.AbstractTestConformance;
import org.nuiton.wikitty.search.Element;
import org.nuiton.wikitty.search.Search;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImportExportTest
extends AbstractTestConformance {
    protected static final Log log = LogFactory.getLog(ImportExportTest.class);
    protected WikittyImportExportService ieService;

    protected WikittyImportExportService getImportExportService() {
        if (this.ieService == null) {
            this.ieService = new WikittyImportExportService(null, this.ws);
        }
        return this.ieService;
    }

    @Test
    public void testExport() throws Exception {
        this.ws.clear(null);
        final ArrayList<Wikitty> wikitties = ImportExportTest.createSampleWikitty(this.ws);
        Criteria criteria = Search.query().eq(Element.ELT_EXTENSION, "wikittyExt").criteria();
        String result = this.getImportExportService().syncExportAllByCriteria(WikittyImportExportService.FORMAT.XML, criteria);
        log.debug((Object)("[XML] " + result));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new ByteArrayInputStream(result.getBytes()));
        Node rootNode = document.getChildNodes().item(0);
        Assert.assertEquals((String)"wikengo", (String)rootNode.getNodeName());
        this.acceptNodeList(rootNode.getChildNodes(), new NodeVisitor(){

            @Override
            public void visitNode(Node node, Map<String, String> attrs) {
                String nodeName = node.getNodeName();
                if ("extension".equals(nodeName)) {
                    Assert.assertEquals((String)"1.0", (String)attrs.get("version"));
                    Assert.assertEquals((String)"wikittyExt", (String)attrs.get("name"));
                } else if ("object".equals(nodeName)) {
                    Wikitty wikitty = null;
                    String id = attrs.get("id");
                    for (Wikitty w : wikitties) {
                        if (!w.getId().equals(id)) continue;
                        wikitty = w;
                        break;
                    }
                    Assert.assertNotNull(wikitty);
                    Assert.assertEquals((String)"1.0", (String)attrs.get("version"));
                    Assert.assertEquals((String)"wikittyExt[1.0]", (String)attrs.get("extensions"));
                    wikitties.remove(wikitty);
                } else {
                    Assert.fail((String)("Node [" + node.getNodeName() + "] is neither an extension or an object"));
                }
            }
        });
        Assert.assertTrue((String)"some objects were not exported ...", (boolean)wikitties.isEmpty());
    }

    private void acceptNodeList(NodeList nodeList, NodeVisitor visitor) {
        int len = nodeList.getLength();
        HashMap<String, String> attrs = new HashMap<String, String>();
        for (int i = 0; i < len; ++i) {
            attrs.clear();
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) continue;
            NamedNodeMap map = node.getAttributes();
            if (map != null) {
                int attrLen = map.getLength();
                for (int j = 0; j < attrLen; ++j) {
                    attrs.put(map.item(j).getNodeName(), map.item(j).getNodeValue());
                }
            }
            visitor.visitNode(node, attrs);
        }
    }

    @Test
    public void testImport() throws Exception {
        String xml = "<wikengo>  <extension name='wikittyExt' version='1.0' requires=''>    <field>STRING fieldName0[0-1]</field>    <field>NUMERIC fieldName1[1-1]</field>    <field>DATE fieldName2[1-1]</field>  </extension>  <object id='f4ef949b-09e4-438f-b359-2a4332771c81' version='1.0' extensions='wikittyExt[1.0]'>    <wikittyExt.fieldName0>table</wikittyExt.fieldName0>    <wikittyExt.fieldName1>3300</wikittyExt.fieldName1>    <wikittyExt.fieldName2>1982-01-22T23:00:00.000+0000Z</wikittyExt.fieldName2>  </object>  <object id='7ca86742-5957-4659-b12f-4915cbef9193' version='1.0' extensions='wikittyExt[1.0]'>    <wikittyExt.fieldName0>chaise</wikittyExt.fieldName0>    <wikittyExt.fieldName1>113311</wikittyExt.fieldName1>    <wikittyExt.fieldName2>2009-09-25T22:00:00.000+0000Z</wikittyExt.fieldName2>  </object>  <object id='77d7640c-573d-421c-a7e9-9b70bd025983' version='1.0' extensions='wikittyExt[1.0]'>    <wikittyExt.fieldName0>bureau</wikittyExt.fieldName0>    <wikittyExt.fieldName1>223322</wikittyExt.fieldName1>    <wikittyExt.fieldName2>2029-12-24T23:00:00.000+0000Z</wikittyExt.fieldName2>  </object></wikengo>";
        this.getImportExportService().syncImport(WikittyImportExportService.FORMAT.XML, xml);
        String[] ids = new String[]{"f4ef949b-09e4-438f-b359-2a4332771c81", "7ca86742-5957-4659-b12f-4915cbef9193", "77d7640c-573d-421c-a7e9-9b70bd025983"};
        List wikitties = this.ws.restore(null, Arrays.asList(ids));
        Assert.assertEquals((int)3, (int)wikitties.size());
    }

    static interface NodeVisitor {
        public void visitNode(Node var1, Map<String, String> var2);
    }
}

