/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.wikitty.Criteria;
import org.nuiton.wikitty.FieldType;
import org.nuiton.wikitty.LabelHelper;
import org.nuiton.wikitty.LabelImpl;
import org.nuiton.wikitty.PagedResult;
import org.nuiton.wikitty.Tree;
import org.nuiton.wikitty.TreeNode;
import org.nuiton.wikitty.TreeNodeHelper;
import org.nuiton.wikitty.TreeNodeImpl;
import org.nuiton.wikitty.UpdateResponse;
import org.nuiton.wikitty.Wikitty;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.WikittyExtension;
import org.nuiton.wikitty.WikittyExtensionMigration;
import org.nuiton.wikitty.WikittyExtensionMigrationRename;
import org.nuiton.wikitty.WikittyExtensionStorage;
import org.nuiton.wikitty.WikittySearchEngin;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyServiceListener;
import org.nuiton.wikitty.WikittyStorage;
import org.nuiton.wikitty.WikittyTransaction;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.search.Search;

public class WikittyServiceImpl
implements WikittyService {
    private static Log log = LogFactory.getLog(WikittyServiceImpl.class);
    protected WikittyExtensionMigration defaultExtensionMigration = new WikittyExtensionMigrationRename();
    protected WikittySearchEngin searchEngin;
    protected WikittyExtensionStorage extensionStorage;
    protected WikittyStorage wikittyStorage;

    protected WikittyServiceImpl() {
    }

    public WikittyServiceImpl(WikittyExtensionStorage extensionStorage, WikittyStorage wikittyStorage, WikittySearchEngin searchEngin) {
        this.extensionStorage = extensionStorage;
        this.wikittyStorage = wikittyStorage;
        this.searchEngin = searchEngin;
    }

    protected WikittySearchEngin getSearchEngin() {
        return this.searchEngin;
    }

    protected WikittyExtensionStorage getExtensionStorage() {
        return this.extensionStorage;
    }

    protected WikittyStorage getWikittyStorage() {
        return this.wikittyStorage;
    }

    @Override
    public void addWikittyServiceListener(WikittyServiceListener listener, WikittyService.ServiceListenerType type) {
        throw new UnsupportedOperationException("Can't add listener on " + WikittyServiceImpl.class.getName());
    }

    @Override
    public void removeWikittyServiceListener(WikittyServiceListener listener, WikittyService.ServiceListenerType type) {
        throw new UnsupportedOperationException("Can't remove listener on " + WikittyServiceImpl.class.getName());
    }

    @Override
    public String login(String login, String password) {
        log.warn((Object)"login asked, but there is no security service");
        return null;
    }

    @Override
    public void logout(String securityToken) {
        log.warn((Object)"logout asked, but there is no security service");
    }

    @Override
    public boolean canWrite(String securityToken, Wikitty wikitty) {
        return true;
    }

    @Override
    public boolean canDelete(String securityToken, String wikittyId) {
        return true;
    }

    @Override
    public boolean canRead(String securityToken, String wikittyId) {
        return true;
    }

    protected void checkConstraint(Collection<Wikitty> wikitties) {
        for (Wikitty w : wikitties) {
            for (WikittyExtension ext : w.getExtensions()) {
                for (String fieldName : ext.getFieldNames()) {
                    FieldType type = ext.getFieldType(fieldName);
                    if (!type.isNotNull() || null != w.getFieldAsObject(ext.getName(), fieldName)) continue;
                    throw new WikittyException(String.format("Field %s must not be null", fieldName));
                }
            }
        }
    }

    @Override
    public UpdateResponse store(String securityToken, WikittyTransaction transaction, Collection<Wikitty> wikitties, boolean disableAutoVersionIncrement) {
        this.checkConstraint(wikitties);
        HashSet<WikittyExtension> allExtensions = new HashSet<WikittyExtension>();
        for (Wikitty w : wikitties) {
            allExtensions.addAll(w.getExtensions());
        }
        UpdateResponse extUpdate = this.getExtensionStorage().store(transaction, allExtensions);
        UpdateResponse wikUpdate = this.getWikittyStorage().store(transaction, wikitties, disableAutoVersionIncrement);
        UpdateResponse indexUpdate = this.getSearchEngin().store(transaction, wikitties);
        UpdateResponse result = new UpdateResponse();
        result.add(extUpdate);
        result.add(wikUpdate);
        result.add(indexUpdate);
        return result;
    }

    @Override
    public UpdateResponse store(String securityToken, Wikitty wikitty) {
        if (wikitty != null) {
            WikittyTransaction transaction = new WikittyTransaction();
            try {
                transaction.begin();
                List<Wikitty> wikitties = Arrays.asList(wikitty);
                UpdateResponse result = this.store(securityToken, transaction, wikitties, false);
                transaction.commit();
                return result;
            }
            catch (Exception eee) {
                transaction.rollback();
                throw new WikittyException(eee);
            }
        }
        throw new WikittyException("You can't store null wikitty object");
    }

    @Override
    public UpdateResponse store(String securityToken, Collection<Wikitty> wikitties) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            UpdateResponse result = this.store(securityToken, transaction, wikitties, false);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }

    @Override
    public UpdateResponse store(String securityToken, Collection<Wikitty> wikitties, boolean disableAutoVersionIncrement) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            UpdateResponse result = this.store(securityToken, transaction, wikitties, disableAutoVersionIncrement);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }

    @Override
    public List<String> getAllExtensionIds(String securityToken) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            List<String> result = this.getExtensionStorage().getAllExtensionIds(transaction);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }

    @Override
    public List<String> getAllExtensionsRequires(String securityToken, String extensionName) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            List<String> result = this.getExtensionStorage().getAllExtensionsRequires(transaction, extensionName);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }

    @Override
    public UpdateResponse storeExtension(String securityToken, WikittyTransaction transaction, Collection<WikittyExtension> exts) {
        UpdateResponse result = this.getExtensionStorage().store(transaction, exts);
        return result;
    }

    @Override
    public UpdateResponse storeExtension(String securityToken, Collection<WikittyExtension> exts) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            UpdateResponse result = this.storeExtension(securityToken, transaction, exts);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }

    @Override
    public UpdateResponse storeExtension(String securityToken, WikittyExtension ext) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            UpdateResponse result = this.storeExtension(securityToken, transaction, Arrays.asList(ext));
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }

    @Override
    public WikittyExtension restoreExtension(String securityToken, WikittyTransaction transaction, String id) {
        String name = WikittyExtension.computeName(id);
        String version = WikittyExtension.computeVersion(id);
        WikittyExtension result = this.getExtensionStorage().restore(transaction, name, version);
        return result;
    }

    @Override
    public WikittyExtension restoreExtension(String securityToken, String id) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            WikittyExtension result = this.restoreExtension(securityToken, transaction, id);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken, WikittyTransaction transaction, String name) {
        String version = this.getExtensionStorage().getLastVersion(transaction, name);
        if (version == null) {
            return null;
        }
        WikittyExtension result = this.getExtensionStorage().restore(transaction, name, version);
        return result;
    }

    @Override
    public WikittyExtension restoreExtensionLastVersion(String securityToken, String name) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            WikittyExtension result = this.restoreExtensionLastVersion(securityToken, transaction, name);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }

    protected Wikitty restore(String securityToken, WikittyTransaction transaction, String id) {
        if (!this.getWikittyStorage().exists(transaction, id)) {
            return null;
        }
        if (this.getWikittyStorage().isDeleted(transaction, id)) {
            return null;
        }
        Wikitty result = this.getWikittyStorage().restore(transaction, id, new String[0]);
        if (result != null) {
            result = this.upgradeData(securityToken, transaction, result);
        }
        return result;
    }

    @Override
    public List<Wikitty> restore(String securityToken, WikittyTransaction transaction, List<String> ids) {
        ArrayList<Wikitty> result = new ArrayList<Wikitty>();
        for (String id : ids) {
            Wikitty w = this.restore(securityToken, transaction, id);
            if (w == null) continue;
            result.add(w);
        }
        return result;
    }

    @Override
    public List<Wikitty> restore(String securityToken, List<String> ids) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            List<Wikitty> result = this.restore(securityToken, transaction, ids);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't restore wikitty collection", (Throwable)eee);
            }
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }

    @Override
    public Wikitty restore(String securityToken, String id) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            Wikitty result = this.restore(securityToken, transaction, id);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }

    protected Wikitty upgradeData(String securityToken, WikittyTransaction transaction, Wikitty wikitty) {
        Wikitty result = wikitty;
        Collection<WikittyExtension> extensions = wikitty.getExtensions();
        for (WikittyExtension extension : extensions) {
            String extensionName = extension.getName();
            log.debug((Object)("extensionName=" + extensionName));
            WikittyExtension currentExtension = extension;
            String currentExtensionVersion = currentExtension.getVersion();
            WikittyExtension lastExtension = this.restoreExtensionLastVersion(securityToken, transaction, extensionName);
            String lastExtensionVersion = lastExtension.getVersion();
            log.debug((Object)("lastExtensionVersion=" + lastExtensionVersion));
            WikittyExtensionMigration migration = WikittyExtensionMigration.migrationRegistry.get(extensionName);
            if (migration == null) {
                migration = this.defaultExtensionMigration;
            }
            while (WikittyUtil.versionGreaterThan(lastExtensionVersion, currentExtensionVersion)) {
                String nextExtensionVersion = WikittyUtil.incrementMajorRevision(currentExtensionVersion);
                String nextExtensionId = WikittyExtension.computeId(extensionName, nextExtensionVersion);
                WikittyExtension nextExtension = this.restoreExtension(securityToken, transaction, nextExtensionId);
                log.debug((Object)("currentExtensionVersion=" + currentExtensionVersion));
                log.debug((Object)("nextExtensionVersion=" + nextExtensionVersion));
                if (nextExtension != null) {
                    result = migration.migrate(this, transaction, result, currentExtension, nextExtension);
                    currentExtension = nextExtension;
                }
                currentExtensionVersion = nextExtensionVersion;
            }
        }
        return result;
    }

    protected void delete(String securityToken, WikittyTransaction transaction, Collection<String> ids) throws WikittyException {
        ArrayList<Wikitty> storedWikitties = new ArrayList<Wikitty>();
        LinkedList<String> idList = new LinkedList<String>(ids);
        Iterator i = idList.iterator();
        while (i.hasNext()) {
            Wikitty treeNode;
            String id = (String)i.next();
            if (!this.getWikittyStorage().exists(transaction, id)) {
                i.remove();
            }
            if (this.getWikittyStorage().isDeleted(transaction, id)) {
                i.remove();
            }
            Criteria criteria = Search.query().eq("TreeNode.parent", id).criteria();
            List<String> wikittyNodesId = this.findAllByCriteria(securityToken, transaction, criteria).getAll();
            for (String wikittyNodeId : wikittyNodesId) {
                if (ids.contains(wikittyNodeId)) continue;
                treeNode = this.restore(securityToken, transaction, wikittyNodeId);
                TreeNodeHelper.setParent(treeNode, null);
                storedWikitties.add(treeNode);
            }
            criteria = Search.query().eq("TreeNode.children", id).criteria();
            wikittyNodesId = this.findAllByCriteria(securityToken, transaction, criteria).getAll();
            for (String wikittyNodeId : wikittyNodesId) {
                if (ids.contains(wikittyNodeId)) continue;
                treeNode = this.restore(securityToken, transaction, wikittyNodeId);
                TreeNodeHelper.removeChildren(treeNode, id);
                storedWikitties.add(treeNode);
            }
        }
        this.getWikittyStorage().delete(transaction, idList);
        this.getSearchEngin().delete(transaction, idList);
        this.store(securityToken, transaction, storedWikitties, false);
    }

    @Override
    public void delete(String securityToken, String id) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            List<String> ids = Arrays.asList(id);
            this.delete(securityToken, transaction, ids);
            transaction.commit();
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }

    @Override
    public void delete(String securityToken, Collection<String> ids) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            this.delete(securityToken, transaction, ids);
            transaction.commit();
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }

    @Override
    public void clear(String securityToken) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            this.getSearchEngin().clear(transaction);
            this.getWikittyStorage().clear(transaction);
            this.getExtensionStorage().clear(transaction);
            transaction.commit();
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }

    @Override
    public PagedResult<String> findAllByCriteria(String securityToken, WikittyTransaction transaction, Criteria criteria) {
        PagedResult<String> result = this.getSearchEngin().findAllByCriteria(transaction, criteria);
        return result;
    }

    @Override
    public PagedResult<String> findAllByCriteria(String securityToken, Criteria criteria) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            PagedResult<String> result = this.findAllByCriteria(securityToken, transaction, criteria);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }

    @Override
    public Wikitty findByCriteria(String securityToken, WikittyTransaction transaction, Criteria criteria) {
        criteria.setFirstIndex(0).setEndIndex(1);
        PagedResult<String> pages = this.findAllByCriteria(securityToken, transaction, criteria);
        Wikitty result = null;
        if (pages.size() > 0) {
            String id = pages.getFirst();
            result = this.restore(securityToken, transaction, id);
        }
        return result;
    }

    @Override
    public Wikitty findByCriteria(String securityToken, Criteria criteria) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            Wikitty result = this.findByCriteria(securityToken, transaction, criteria);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }

    @Override
    public void addLabel(String securityToken, String wikittyId, String label) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            Wikitty w = this.restore(securityToken, transaction, wikittyId);
            w.addExtension(LabelImpl.extensions);
            LabelImpl l = new LabelImpl(w);
            l.addLabels(label);
            this.store(securityToken, transaction, Arrays.asList(w), false);
            transaction.commit();
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }

    @Override
    public PagedResult<String> findAllByLabel(String securityToken, String label, int firstIndex, int endIndex) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            LabelImpl l = new LabelImpl();
            l.addLabels(label);
            Criteria criteria = Search.query(l.getWikitty()).criteria().setFirstIndex(firstIndex).setEndIndex(endIndex);
            PagedResult<String> result = this.findAllByCriteria(securityToken, transaction, criteria);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }

    @Override
    public Wikitty findByLabel(String securityToken, String label) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            LabelImpl l = new LabelImpl();
            l.addLabels(label);
            Criteria criteria = Search.query(l.getWikitty()).criteria();
            Wikitty result = this.findByCriteria(securityToken, transaction, criteria);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }

    @Override
    public Set<String> findAllAppliedLabels(String securityToken, String wikittyId) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            Wikitty w = this.restore(securityToken, transaction, wikittyId);
            Set<String> result = LabelHelper.getLabels(w);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }

    protected Tree restoreTree(String securityToken, WikittyTransaction transaction, String wikittyId) {
        Wikitty w = this.restore(securityToken, transaction, wikittyId);
        if (w == null) {
            return null;
        }
        if (!w.hasExtension("TreeNode")) {
            throw new WikittyException(String.format("Wikitty '%s' do not handle extension %s", wikittyId, "TreeNode"));
        }
        Tree tree = new Tree();
        TreeNodeImpl node = new TreeNodeImpl(w);
        tree.setNode(node);
        TreeNodeImpl exempleNode = new TreeNodeImpl();
        exempleNode.setParent(wikittyId);
        Criteria criteria = Search.query(exempleNode.getWikitty()).criteria().setFirstIndex(0).setEndIndex(-1);
        PagedResult<String> childNodesId = this.findAllByCriteria(securityToken, transaction, criteria);
        for (String childNodeId : childNodesId.getAll()) {
            tree.addChild(this.restoreTree(securityToken, transaction, childNodeId));
        }
        return tree;
    }

    @Override
    public Tree restoreTree(String securityToken, String wikittyId) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            Tree tree = this.restoreTree(securityToken, transaction, wikittyId);
            transaction.commit();
            return tree;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }

    @Override
    public Map.Entry<TreeNode, Integer> restoreNode(String securityToken, String wikittyId, Criteria filter) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            Wikitty w = this.restore(securityToken, transaction, wikittyId);
            if (w == null) {
                transaction.commit();
                return null;
            }
            if (!w.hasExtension("TreeNode")) {
                throw new WikittyException(String.format("Wikitty '%s' do not handle extension %s", wikittyId, "TreeNode"));
            }
            TreeNodeImpl node = new TreeNodeImpl(w);
            Integer count = this.getSearchEngin().findNodeCount(transaction, w, filter);
            AbstractMap.SimpleEntry<TreeNode, Integer> result = new AbstractMap.SimpleEntry<TreeNode, Integer>(node, count);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }

    @Override
    public Map<TreeNode, Integer> restoreChildren(String securityToken, String wikittyId, Criteria filter) {
        WikittyTransaction transaction = new WikittyTransaction();
        try {
            transaction.begin();
            Wikitty w = this.restore(securityToken, transaction, wikittyId);
            if (w == null) {
                transaction.commit();
                return null;
            }
            if (!w.hasExtension("TreeNode")) {
                throw new WikittyException(String.format("Wikitty '%s' do not handle extension %s", wikittyId, "TreeNode"));
            }
            LinkedHashMap<TreeNode, Integer> result = new LinkedHashMap<TreeNode, Integer>();
            Map<String, Integer> search = this.getSearchEngin().findAllChildrenCount(transaction, w, filter);
            Set<Map.Entry<String, Integer>> children = search.entrySet();
            for (Map.Entry<String, Integer> child : children) {
                Integer count = child.getValue();
                String id = child.getKey();
                Wikitty wikitty = this.restore(securityToken, transaction, id);
                TreeNodeImpl node = new TreeNodeImpl(wikitty);
                result.put(node, count);
            }
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }

    @Override
    public Wikitty restoreVersion(String securityToken, String wikittyId, String version) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public UpdateResponse syncEngin(final String securityToken) {
        final WikittyTransaction transaction = new WikittyTransaction();
        try {
            int numberForCommit = 1000;
            final WikittySearchEngin searchEngin = this.getSearchEngin();
            final UpdateResponse result = new UpdateResponse();
            final ArrayList<Wikitty> wikitties = new ArrayList<Wikitty>(1000);
            transaction.begin();
            searchEngin.clear(transaction);
            transaction.commit();
            transaction.begin();
            this.getWikittyStorage().scanWikitties(transaction, new WikittyStorage.Scanner(){
                int count = 0;

                @Override
                public void scan(String wikittyId) {
                    Wikitty wikitty = WikittyServiceImpl.this.restore(securityToken, transaction, wikittyId);
                    Date deleteDate = wikitty.getDeleteDate();
                    if (deleteDate == null) {
                        ++this.count;
                        wikitties.add(wikitty);
                        if (this.count == 1000) {
                            UpdateResponse response = searchEngin.store(transaction, wikitties);
                            result.add(response);
                            transaction.commit();
                            this.count = 0;
                            wikitties.clear();
                            transaction.begin();
                        }
                    }
                }
            });
            UpdateResponse response = searchEngin.store(transaction, wikitties);
            result.add(response);
            transaction.commit();
            return result;
        }
        catch (Exception eee) {
            transaction.rollback();
            throw new WikittyException(eee);
        }
    }
}

